/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.LoadBalancerProvider;
import com.appoptics.ext.io.grpc.ServiceProviders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoadBalancerRegistry {
    private static final Logger logger = Logger.getLogger(LoadBalancerRegistry.class.getName());
    private static LoadBalancerRegistry instance;
    private static final Iterable<Class<?>> HARDCODED_CLASSES;
    private final LinkedHashSet<LoadBalancerProvider> allProviders = new LinkedHashSet();
    private final LinkedHashMap<String, LoadBalancerProvider> effectiveProviders = new LinkedHashMap();

    private synchronized void addProvider(LoadBalancerProvider loadBalancerProvider) {
        b.a(loadBalancerProvider.isAvailable(), (Object)"isAvailable() returned false");
        this.allProviders.add(loadBalancerProvider);
    }

    private synchronized void refreshProviderMap() {
        this.effectiveProviders.clear();
        for (LoadBalancerProvider loadBalancerProvider : this.allProviders) {
            String string = loadBalancerProvider.getPolicyName();
            LoadBalancerProvider loadBalancerProvider2 = this.effectiveProviders.get(string);
            if (loadBalancerProvider2 != null && loadBalancerProvider2.getPriority() >= loadBalancerProvider.getPriority()) continue;
            this.effectiveProviders.put(string, loadBalancerProvider);
        }
    }

    public static synchronized LoadBalancerRegistry getDefaultRegistry() {
        if (instance == null) {
            Object object = ServiceProviders.loadAll(LoadBalancerProvider.class, HARDCODED_CLASSES, LoadBalancerProvider.class.getClassLoader(), new LoadBalancerPriorityAccessor());
            instance = new LoadBalancerRegistry();
            object = object.iterator();
            while (object.hasNext()) {
                LoadBalancerProvider loadBalancerProvider = (LoadBalancerProvider)object.next();
                logger.fine("Service loader found " + loadBalancerProvider);
                if (!loadBalancerProvider.isAvailable()) continue;
                instance.addProvider(loadBalancerProvider);
            }
            instance.refreshProviderMap();
        }
        return instance;
    }

    public final synchronized LoadBalancerProvider getProvider(String string) {
        return this.effectiveProviders.get(b.a(string, (Object)"policy"));
    }

    static List<Class<?>> getHardCodedClasses() {
        ArrayList arrayList = new ArrayList();
        try {
            arrayList.add(Class.forName("com.appoptics.ext.io.grpc.internal.PickFirstLoadBalancerProvider"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "Unable to find pick-first LoadBalancer", classNotFoundException);
        }
        try {
            arrayList.add(Class.forName("com.appoptics.ext.io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.FINE, "Unable to find round-robin LoadBalancer", classNotFoundException);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static {
        HARDCODED_CLASSES = LoadBalancerRegistry.getHardCodedClasses();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LoadBalancerPriorityAccessor
    implements ServiceProviders.PriorityAccessor<LoadBalancerProvider> {
        LoadBalancerPriorityAccessor() {
        }

        @Override
        public final boolean isAvailable(LoadBalancerProvider loadBalancerProvider) {
            return loadBalancerProvider.isAvailable();
        }

        @Override
        public final int getPriority(LoadBalancerProvider loadBalancerProvider) {
            return loadBalancerProvider.getPriority();
        }
    }
}

