/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquivalentAddressGroup {
    public static final Attributes.Key<String> ATTR_AUTHORITY_OVERRIDE = Attributes.Key.create("com.appoptics.ext.io.grpc.EquivalentAddressGroup.authorityOverride");
    private final List<SocketAddress> addrs;
    private final Attributes attrs;
    private final int hashCode;

    public EquivalentAddressGroup(List<SocketAddress> list) {
        this(list, Attributes.EMPTY);
    }

    public EquivalentAddressGroup(List<SocketAddress> list, Attributes attributes) {
        b.a(!list.isEmpty(), (Object)"addrs is empty");
        this.addrs = Collections.unmodifiableList(new ArrayList<SocketAddress>(list));
        this.attrs = b.a(attributes, (Object)"attrs");
        this.hashCode = this.addrs.hashCode();
    }

    public EquivalentAddressGroup(SocketAddress socketAddress) {
        this(socketAddress, Attributes.EMPTY);
    }

    public EquivalentAddressGroup(SocketAddress socketAddress, Attributes attributes) {
        this(Collections.singletonList(socketAddress), attributes);
    }

    public final List<SocketAddress> getAddresses() {
        return this.addrs;
    }

    public final Attributes getAttributes() {
        return this.attrs;
    }

    public final String toString() {
        return "[" + this.addrs + "/" + this.attrs + "]";
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof EquivalentAddressGroup)) {
            return false;
        }
        object = (EquivalentAddressGroup)object;
        if (this.addrs.size() != ((EquivalentAddressGroup)object).addrs.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.addrs.size(); ++i2) {
            if (this.addrs.get(i2).equals(((EquivalentAddressGroup)object).addrs.get(i2))) continue;
            return false;
        }
        return this.attrs.equals(((EquivalentAddressGroup)object).attrs);
    }
}

