/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deadline
implements Comparable<Deadline> {
    private static final SystemTicker SYSTEM_TICKER = new SystemTicker();
    private static final long MAX_OFFSET = TimeUnit.DAYS.toNanos(36500L);
    private static final long MIN_OFFSET = -MAX_OFFSET;
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final Ticker ticker;
    private final long deadlineNanos;
    private volatile boolean expired;

    public static Deadline after(long l2, TimeUnit timeUnit) {
        return Deadline.after(l2, timeUnit, SYSTEM_TICKER);
    }

    public static Deadline after(long l2, TimeUnit timeUnit, Ticker ticker) {
        Deadline.checkNotNull(timeUnit, "units");
        return new Deadline(ticker, timeUnit.toNanos(l2), true);
    }

    private Deadline(Ticker ticker, long l2, boolean bl) {
        Ticker ticker2 = ticker;
        this(ticker2, ticker2.nanoTime(), l2, bl);
    }

    private Deadline(Ticker ticker, long l2, long l3, boolean bl) {
        this.ticker = ticker;
        l3 = Math.min(MAX_OFFSET, Math.max(MIN_OFFSET, l3));
        this.deadlineNanos = l2 + l3;
        this.expired = bl && l3 <= 0L;
    }

    public final boolean isExpired() {
        if (!this.expired) {
            if (this.deadlineNanos - this.ticker.nanoTime() <= 0L) {
                this.expired = true;
            } else {
                return false;
            }
        }
        return true;
    }

    public final boolean isBefore(Deadline deadline) {
        this.checkTicker(deadline);
        return this.deadlineNanos - deadline.deadlineNanos < 0L;
    }

    public final Deadline minimum(Deadline deadline) {
        this.checkTicker(deadline);
        if (this.isBefore(deadline)) {
            return this;
        }
        return deadline;
    }

    public final long timeRemaining(TimeUnit timeUnit) {
        long l2 = this.ticker.nanoTime();
        if (!this.expired && this.deadlineNanos - l2 <= 0L) {
            this.expired = true;
        }
        return timeUnit.convert(this.deadlineNanos - l2, TimeUnit.NANOSECONDS);
    }

    public final String toString() {
        long l2 = this.timeRemaining(TimeUnit.NANOSECONDS);
        long l3 = Math.abs(l2) / NANOS_PER_SECOND;
        long l4 = Math.abs(l2) % NANOS_PER_SECOND;
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 < 0L) {
            stringBuilder.append('-');
        }
        stringBuilder.append(l3);
        if (l4 > 0L) {
            stringBuilder.append(String.format(Locale.US, ".%09d", l4));
        }
        stringBuilder.append("s from now");
        if (this.ticker != SYSTEM_TICKER) {
            stringBuilder.append(" (ticker=" + this.ticker + ")");
        }
        return stringBuilder.toString();
    }

    @Override
    public final int compareTo(Deadline deadline) {
        this.checkTicker(deadline);
        long l2 = this.deadlineNanos - deadline.deadlineNanos;
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        return Arrays.asList(this.ticker, this.deadlineNanos).hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Deadline)) {
            return false;
        }
        object = (Deadline)object;
        if (this.ticker == null ? ((Deadline)object).ticker != null : this.ticker != ((Deadline)object).ticker) {
            return false;
        }
        return this.deadlineNanos == ((Deadline)object).deadlineNanos;
    }

    private static <T> T checkNotNull(T t2, Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    private void checkTicker(Deadline deadline) {
        if (this.ticker != deadline.ticker) {
            throw new AssertionError((Object)("Tickers (" + this.ticker + " and " + deadline.ticker + ") don't match. Custom Ticker should only be used in tests!"));
        }
    }

    private static class SystemTicker
    extends Ticker {
        private SystemTicker() {
        }

        public long nanoTime() {
            return System.nanoTime();
        }
    }

    public static abstract class Ticker {
        public abstract long nanoTime();
    }
}

