'use strict';
const assert = require('assert');
const absolutizeUrl = require('../src/browser/absolutizeUrl');

describe('absolutizeUrl', () => {
  it('works', () => {
    assert.strictEqual(
      absolutizeUrl('style.css', 'https://some.org'),
      'https://some.org/style.css',
    );
    assert.strictEqual(
      absolutizeUrl('style.css?#hello=true', 'https://some.org'),
      'https://some.org/style.css?#hello=true',
    );
    assert.strictEqual(
      absolutizeUrl('style.css', 'https://some.org/app'),
      'https://some.org/style.css',
    );
    assert.strictEqual(
      absolutizeUrl('style.css', 'https://some.org/app/'),
      'https://some.org/app/style.css',
    );
    assert.strictEqual(
      absolutizeUrl('style.css', 'https://some.org/app/bla'),
      'https://some.org/app/style.css',
    );
    assert.strictEqual(
      absolutizeUrl('/style.css', 'https://some.org/app/bla'),
      'https://some.org/style.css',
    );
  });
});
