/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum RenderStatus {
    NEED_MORE_RESOURCE,
    RENDERING,
    RENDERED,
    ERROR,
    NEED_MORE_DOM;

    private static Map<String, RenderStatus> namesMap;
    private static Map<Integer, RenderStatus> valueToTextMapping;

    @JsonCreator
    public static RenderStatus forValue(String value) {
        return namesMap.get(StringUtils.lowerCase((String)value));
    }

    @JsonValue
    public String toValue() {
        for (Map.Entry<String, RenderStatus> entry : namesMap.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        namesMap = new HashMap<String, RenderStatus>(3);
        namesMap.put("need-more-resources", NEED_MORE_RESOURCE);
        namesMap.put("rendering", RENDERING);
        namesMap.put("rendered", RENDERED);
        namesMap.put("error", ERROR);
    }
}

