/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.services.EyesService;
import com.applitools.eyes.services.ServiceTaskListener;
import com.applitools.eyes.visualgrid.model.DomAnalyzer;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.HashObject;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ResourceCollectionService
extends EyesService<FrameData, Map<String, RGridResource>> {
    private static final int RESOURCE_TIMEOUT = 30000;
    final Map<String, RGridResource> resourcesCacheMap;
    private IDebugResourceWriter debugResourceWriter;
    final Map<String, SyncTaskListener<Void>> uploadedResourcesCache = Collections.synchronizedMap(new HashMap());
    final Map<String, DomAnalyzer> tasksInDomAnalyzingProcess = Collections.synchronizedMap(new HashMap());
    protected final List<Pair<String, Pair<RGridDom, Map<String, RGridResource>>>> waitingForUploadQueue = Collections.synchronizedList(new ArrayList());
    UfgConnector defaultResourcesConnector;
    UfgConnector customResourcesConnector;
    private String[] autProxyDomains;
    private boolean isAutProxySet = false;

    public ResourceCollectionService(Logger logger, UfgConnector serverConnector, IDebugResourceWriter debugResourceWriter, Map<String, RGridResource> resourcesCacheMap) {
        super(logger, serverConnector);
        this.debugResourceWriter = debugResourceWriter != null ? debugResourceWriter : new NullDebugResourceWriter();
        this.resourcesCacheMap = resourcesCacheMap;
        this.defaultResourcesConnector = new UfgConnector(logger);
        this.defaultResourcesConnector.setTimeout(30000);
        this.customResourcesConnector = new UfgConnector(logger);
        this.customResourcesConnector.setTimeout(30000);
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.defaultResourcesConnector.setLogger(logger);
        this.customResourcesConnector.setLogger(logger);
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter != null ? debugResourceWriter : new NullDebugResourceWriter();
    }

    public void setAutProxy(AbstractProxySettings proxySettings, String[] autProxyDomains, boolean isWhiteList) {
        if (!this.isAutProxySet) {
            this.isAutProxySet = true;
            this.autProxyDomains = autProxyDomains;
            if (proxySettings != null) {
                UfgConnector chosenConnector = autProxyDomains == null || !isWhiteList ? this.defaultResourcesConnector : this.customResourcesConnector;
                chosenConnector.setProxy(proxySettings);
            } else if (autProxyDomains != null) {
                this.logger.log(TraceLevel.Warn, Stage.RESOURCE_COLLECTION, "Aut proxy was set with null. Ignoring domains list and removing proxy for all resource download requests");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<DomAnalyzer> domAnalyzers;
        Iterator frameData;
        while (!this.inputQueue.isEmpty()) {
            final Pair nextInput = (Pair)this.inputQueue.remove(0);
            frameData = (FrameData)nextInput.getRight();
            try {
                DomAnalyzer domAnalyzer = new DomAnalyzer(this.logger, this.defaultResourcesConnector, this.customResourcesConnector, this.autProxyDomains, this.debugResourceWriter, (FrameData)((Object)frameData), this.resourcesCacheMap, new TaskListener<Map<String, RGridResource>>(){

                    public void onComplete(Map<String, RGridResource> resourceMap) {
                        RGridDom dom = new RGridDom(frameData.getCdt(), resourceMap, frameData.getUrl());
                        dom.setTestIds(frameData.getTestIds());
                        ResourceCollectionService.this.waitingForUploadQueue.add((Pair<String, Pair<RGridDom, Map<String, RGridResource>>>)Pair.of((Object)nextInput.getLeft(), (Object)Pair.of((Object)dom, resourceMap)));
                        ResourceCollectionService.this.tasksInDomAnalyzingProcess.remove(nextInput.getLeft());
                    }

                    public void onFail() {
                        ResourceCollectionService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)new EyesException("Dom analyzer failed")));
                        ResourceCollectionService.this.tasksInDomAnalyzingProcess.remove(nextInput.getLeft());
                    }
                });
                this.tasksInDomAnalyzingProcess.put((String)nextInput.getLeft(), domAnalyzer);
            }
            catch (Throwable t) {
                this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
            }
        }
        frameData = this.tasksInDomAnalyzingProcess;
        synchronized (frameData) {
            domAnalyzers = new ArrayList<DomAnalyzer>(this.tasksInDomAnalyzingProcess.values());
        }
        for (DomAnalyzer domAnalyzer : domAnalyzers) {
            domAnalyzer.run();
        }
        while (!this.waitingForUploadQueue.isEmpty()) {
            final Pair<String, Pair<RGridDom, Map<String, RGridResource>>> nextInput = this.waitingForUploadQueue.remove(0);
            final Pair pair = (Pair)nextInput.getRight();
            ServiceTaskListener<List<RGridResource>> checkResourceListener = new ServiceTaskListener<List<RGridResource>>(){

                @Override
                public void onComplete(List<RGridResource> resources) {
                    try {
                        ResourceCollectionService.this.uploadResources(((RGridDom)pair.getLeft()).getTestIds(), resources);
                    }
                    catch (Throwable t) {
                        this.onFail(t);
                        return;
                    }
                    ResourceCollectionService.this.outputQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)pair.getRight()));
                }

                @Override
                public void onFail(Throwable t) {
                    ResourceCollectionService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
                }
            };
            try {
                this.checkResourcesStatus((RGridDom)pair.getLeft(), (Map)pair.getRight(), checkResourceListener);
            }
            catch (Throwable t) {
                checkResourceListener.onFail(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkResourcesStatus(final RGridDom dom, final Map<String, RGridResource> resourceMap, final ServiceTaskListener<List<RGridResource>> listener) throws JsonProcessingException {
        ArrayList<HashObject> hashesToCheck = new ArrayList<HashObject>();
        final HashMap<String, String> hashToResourceUrl = new HashMap<String, String>();
        for (RGridResource rGridResource : resourceMap.values()) {
            String url = rGridResource.getUrl();
            String hash = rGridResource.getSha256();
            String hashFormat = rGridResource.getHashFormat();
            Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
            synchronized (map) {
                if (!this.uploadedResourcesCache.containsKey(hash)) {
                    hashesToCheck.add(new HashObject(hashFormat, hash));
                    hashToResourceUrl.put(hash, url);
                }
            }
        }
        final RGridResource domResource = dom.asResource();
        Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
        synchronized (map) {
            if (!this.uploadedResourcesCache.containsKey(domResource.getSha256())) {
                hashesToCheck.add(new HashObject(domResource.getHashFormat(), domResource.getSha256()));
                hashToResourceUrl.put(domResource.getSha256(), domResource.getUrl());
            }
        }
        if (hashesToCheck.isEmpty()) {
            listener.onComplete(new ArrayList());
            return;
        }
        final HashObject[] hashObjectArray = hashesToCheck.toArray(new HashObject[0]);
        this.serverConnector.checkResourceStatus(new TaskListener<Boolean[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Boolean[] result) {
                if (result == null) {
                    this.onFail();
                    return;
                }
                ResourceCollectionService.this.logger.log(TraceLevel.Info, dom.getTestIds(), Stage.RESOURCE_COLLECTION, Type.CHECK_RESOURCE, new Pair[]{Pair.of((Object)"result", (Object)result)});
                ArrayList<RGridResource> missingResources = new ArrayList<RGridResource>();
                for (int i = 0; i < result.length; ++i) {
                    String hash = hashObjectArray[i].getHash();
                    String resourceUrl = (String)hashToResourceUrl.get(hash);
                    if (result[i] != null && result[i].booleanValue()) {
                        Map<String, SyncTaskListener<Void>> map = ResourceCollectionService.this.uploadedResourcesCache;
                        synchronized (map) {
                            RGridResource resource = resourceUrl.equals(domResource.getUrl()) && hash.equals(domResource.getSha256()) ? domResource : (RGridResource)resourceMap.get(resourceUrl);
                            resource.resetContent();
                            ResourceCollectionService.this.uploadedResourcesCache.put(resource.getSha256(), null);
                            continue;
                        }
                    }
                    if (resourceUrl.equals(domResource.getUrl()) && hash.equals(domResource.getSha256())) {
                        missingResources.add(domResource);
                        continue;
                    }
                    missingResources.add((RGridResource)resourceMap.get(resourceUrl));
                }
                listener.onComplete(missingResources);
            }

            public void onFail() {
                listener.onFail((Throwable)new EyesException("Failed checking resources with the server"));
            }
        }, dom.getTestIds(), null, hashObjectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadResources(Set<String> testIds, List<RGridResource> resources) {
        this.logger.log(TraceLevel.Info, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"resources", resources)});
        for (RGridResource resource : resources) {
            Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
            synchronized (map) {
                if (this.uploadedResourcesCache.containsKey(resource.getSha256())) {
                    continue;
                }
                SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("uploadResource %s %s", resource.getSha256(), resource.getUrl()));
                this.serverConnector.renderPutResource(testIds, "NONE", resource, (TaskListener<Void>)listener);
                this.uploadedResourcesCache.put(resource.getSha256(), (SyncTaskListener<Void>)listener);
            }
        }
        for (RGridResource resource : resources) {
            SyncTaskListener<Void> listener = this.uploadedResourcesCache.get(resource.getSha256());
            if (listener == null) continue;
            listener.get();
        }
        this.logger.log(TraceLevel.Info, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"completed", (Object)true)});
    }
}

