/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.visualgrid.model.BlobData;
import com.applitools.eyes.visualgrid.model.CdtData;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;

public class DomAnalyzer {
    private final Logger logger;
    private final UfgConnector connector;
    private final IDebugResourceWriter debugResourceWriter;
    private final FrameData domData;
    private final UserAgent userAgent;
    private final AtomicInteger framesLevel = new AtomicInteger();
    final Map<String, RGridResource> cachedResources;
    private final Set<String> domResources = Collections.synchronizedSet(new HashSet());
    Phaser resourcesPhaser = new Phaser();

    public DomAnalyzer(Logger logger, UfgConnector connector, IDebugResourceWriter resourceWriter, FrameData domData, Map<String, RGridResource> cachedResources, UserAgent userAgent) {
        this.logger = logger;
        this.connector = connector;
        this.debugResourceWriter = resourceWriter;
        this.domData = domData;
        this.cachedResources = cachedResources;
        this.userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RGridResource> analyze() {
        HashMap<URI, FrameData> resourceUrls = new HashMap<URI, FrameData>();
        this.writeFrameDataAsResource();
        this.parseScriptResult(this.domData, resourceUrls);
        this.logger.verbose(String.format("fetching %d resources: %s", resourceUrls.size(), resourceUrls));
        this.resourcesPhaser = new Phaser();
        this.fetchAllResources(resourceUrls);
        try {
            if (this.resourcesPhaser.getRegisteredParties() > 0) {
                this.resourcesPhaser.awaitAdvanceInterruptibly(0, 10L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            this.resourcesPhaser.forceTermination();
        }
        this.logger.verbose("done fetching resources.");
        HashMap<String, RGridResource> resourceMapping = new HashMap<String, RGridResource>();
        Set<String> set = this.domResources;
        synchronized (set) {
            for (String url : this.domResources) {
                RGridResource resource = this.cachedResources.get(url);
                if (resource == null) {
                    this.logger.log(String.format("Illegal state: resource is null for url %s", url));
                    continue;
                }
                String hash = resource.getSha256();
                this.logger.verbose(String.format("adding resource to map. hash: %s, url: %s: ", hash, url));
                resourceMapping.put(url, resource);
            }
        }
        this.buildAllRGDoms(resourceMapping, this.domData);
        this.logger.verbose(String.format("exit - returning %s resources ", resourceMapping.size()));
        return resourceMapping;
    }

    private void writeFrameDataAsResource() {
        if (this.debugResourceWriter == null || this.debugResourceWriter instanceof NullDebugResourceWriter) {
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            byte[] content = objectMapper.writeValueAsBytes((Object)this.domData);
            RGridResource resource = new RGridResource(this.domData.getUrl(), "x-applitools-html/cdt", content);
            this.debugResourceWriter.write(resource);
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    private void parseScriptResult(FrameData domData, Map<URI, FrameData> resourceUrls) {
        Base64 codec = new Base64();
        String baseUrlStr = domData.getUrl();
        this.logger.verbose("baseUrl: " + baseUrlStr);
        URI baseUrl = null;
        try {
            baseUrl = new URI(baseUrlStr);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        this.parseBlobs(codec, baseUrl, domData.getBlobs());
        this.parseResourceUrls(domData, resourceUrls, baseUrl);
        this.parseFrames(domData, resourceUrls);
        String baseUrlAsString = null;
        if (baseUrl != null) {
            baseUrlAsString = baseUrl.toString();
        }
        this.parseAndCollectExternalResources(domData, baseUrlAsString, resourceUrls);
    }

    private void parseFrames(FrameData frameData, Map<URI, FrameData> resourceUrls) {
        this.logger.verbose("handling 'frames' key (level: " + this.framesLevel.incrementAndGet() + ")");
        for (FrameData frameObj : frameData.getFrames()) {
            this.parseScriptResult(frameObj, resourceUrls);
        }
        this.logger.verbose("done handling 'frames' key (level: " + this.framesLevel.getAndDecrement() + ")");
    }

    private void parseResourceUrls(FrameData result, Map<URI, FrameData> resourceUrls, URI baseUrl) {
        ArrayList<String> sanitizedUrls = new ArrayList<String>();
        for (String url : result.getResourceUrls()) {
            try {
                url = GeneralUtils.sanitizeURL((String)url);
                sanitizedUrls.add(url);
                resourceUrls.put(baseUrl.resolve(url), result);
            }
            catch (Exception e) {
                this.logger.log("Error resolving url:" + url);
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
        result.setResourceUrls(sanitizedUrls);
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBlobs(Base64 codec, URI baseUrl, List<BlobData> resources) {
        Set<String> set = this.domResources;
        synchronized (set) {
            for (BlobData blob : resources) {
                String sanitizedURL = GeneralUtils.sanitizeURL((String)blob.getUrl());
                blob.setUrl(sanitizedURL);
                RGridResource resource = this.parseBlobToGridResource(codec, baseUrl, blob);
                this.domResources.add(resource.getUrl());
                Map<String, RGridResource> map = this.cachedResources;
                synchronized (map) {
                    if (this.cachedResources.containsKey(resource.getUrl())) {
                        continue;
                    }
                    String contentType = resource.getContentType();
                    if (contentType == null || !contentType.equalsIgnoreCase("x-applitools-html/cdt")) {
                        this.cachedResources.put(resource.getUrl(), resource);
                    }
                }
            }
        }
    }

    private RGridResource parseBlobToGridResource(Base64 codec, URI baseUrl, BlobData blobAsMap) {
        String contentAsString = blobAsMap.getValue();
        byte[] content = codec.decode(contentAsString);
        String urlAsString = blobAsMap.getUrl();
        urlAsString = GeneralUtils.sanitizeURL((String)urlAsString);
        Integer errorStatusCode = blobAsMap.getErrorStatusCode();
        try {
            URI url = baseUrl.resolve(urlAsString);
            urlAsString = GeneralUtils.sanitizeURL((String)url.toString());
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + urlAsString);
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        return new RGridResource(urlAsString, blobAsMap.getType(), content, errorStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndCollectExternalResources(FrameData frameData, String baseUrl, Map<URI, FrameData> resourceUrls) {
        Set<String> set = this.domResources;
        synchronized (set) {
            for (String url : this.domResources) {
                RGridResource resource = this.cachedResources.get(url);
                Set<URI> newResources = resource.parse(this.logger, baseUrl);
                if (newResources == null) continue;
                for (URI uri : newResources) {
                    resourceUrls.put(uri, frameData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchAllResources(Map<URI, FrameData> resourceUrls) {
        if (resourceUrls.isEmpty()) {
            return;
        }
        this.logger.verbose("enter");
        for (Map.Entry<URI, FrameData> entry : resourceUrls.entrySet()) {
            URI uri = entry.getKey();
            final FrameData frameData = entry.getValue();
            final String uriStr = GeneralUtils.sanitizeURL((String)uri.toString());
            Map<String, RGridResource> map = this.cachedResources;
            synchronized (map) {
                if (this.cachedResources.containsKey(uriStr)) {
                    this.logger.verbose(String.format("url already fetched: %s", uriStr));
                    RGridResource resource = this.cachedResources.get(uriStr);
                    Set<String> set = this.domResources;
                    synchronized (set) {
                        this.domResources.add(resource.getUrl());
                    }
                    Map<URI, FrameData> newResourceUrls = this.handleCollectedResource(frameData, resource);
                    if (!newResourceUrls.isEmpty()) {
                        this.fetchAllResources(newResourceUrls);
                    }
                    continue;
                }
                try {
                    this.resourcesPhaser.register();
                    this.connector.downloadResource(uri, this.userAgent.getOriginalUserAgentString(), this.domData.getUrl(), new TaskListener<RGridResource>(){

                        public void onComplete(RGridResource downloadedResource) {
                            try {
                                if (downloadedResource == null) {
                                    DomAnalyzer.this.logger.log(String.format("Resource is null for url %s", uriStr));
                                    return;
                                }
                                Map newResourceUrls = DomAnalyzer.this.handleCollectedResource(frameData, downloadedResource);
                                if (newResourceUrls.isEmpty()) {
                                    return;
                                }
                                DomAnalyzer.this.fetchAllResources(newResourceUrls);
                            }
                            finally {
                                DomAnalyzer.this.resourcesPhaser.arriveAndDeregister();
                            }
                        }

                        public void onFail() {
                            DomAnalyzer.this.resourcesPhaser.arriveAndDeregister();
                            DomAnalyzer.this.logger.log(String.format("Failed downloading from uri %s", uriStr));
                        }
                    });
                }
                catch (Exception e) {
                    this.logger.log("error converting " + uri + " to url");
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                }
            }
        }
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URI, FrameData> handleCollectedResource(FrameData frameData, RGridResource resource) {
        Object object = this.cachedResources;
        synchronized (object) {
            if (!this.cachedResources.containsKey(resource.getUrl())) {
                this.cachedResources.put(resource.getUrl(), resource);
            }
        }
        object = this.domResources;
        synchronized (object) {
            this.domResources.add(resource.getUrl());
        }
        try {
            this.debugResourceWriter.write(resource);
            this.logger.verbose("done writing to debugWriter");
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        String contentType = resource.getContentType();
        this.logger.verbose("handling " + contentType + " resource from URL: " + resource.getUrl());
        Set<URI> newResources = resource.parse(this.logger, this.domData.getUrl());
        HashMap<URI, FrameData> newResourceMap = new HashMap<URI, FrameData>();
        for (URI uri : newResources) {
            frameData.getResourceUrls().add(uri.toString());
            newResourceMap.put(uri, frameData);
        }
        return newResourceMap;
    }

    private void buildAllRGDoms(Map<String, RGridResource> resourceMapping, FrameData domData) {
        URL baseUrl = null;
        String domDataUrl = domData.getUrl();
        this.logger.verbose("url in DOM: " + domDataUrl);
        try {
            baseUrl = new URL(domDataUrl);
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        this.logger.verbose("baseUrl: " + baseUrl);
        List<FrameData> allFrame = domData.getFrames();
        this.logger.verbose("FrameData count: " + allFrame.size());
        HashMap<String, RGridResource> mapping = new HashMap<String, RGridResource>();
        for (FrameData frameObj : allFrame) {
            URL frameUrl;
            List<BlobData> allFramesBlobs = frameObj.getBlobs();
            List<String> allResourceUrls = frameObj.getResourceUrls();
            try {
                frameUrl = new URL(baseUrl, frameObj.getUrl());
            }
            catch (MalformedURLException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                continue;
            }
            for (BlobData blob : allFramesBlobs) {
                String blobUrl = blob.getUrl();
                RGridResource rGridResource = resourceMapping.get(blobUrl);
                mapping.put(blobUrl, rGridResource);
            }
            for (String resourceUrl : allResourceUrls) {
                RGridResource rGridResource = resourceMapping.get(resourceUrl);
                mapping.put(resourceUrl, rGridResource);
            }
            List<CdtData> cdt = frameObj.getCdt();
            RGridDom rGridDom = new RGridDom(cdt, mapping, frameUrl.toString(), this.logger, "buildAllRGDoms");
            try {
                RGridResource domResource = rGridDom.asResource();
                resourceMapping.put(frameUrl.toString(), domResource);
                this.debugResourceWriter.write(domResource);
                this.buildAllRGDoms(resourceMapping, frameObj);
            }
            catch (JsonProcessingException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
    }
}

