/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.eyes.SessionUrls;
import com.applitools.eyes.StepInfo;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.selenium.universal.dto.SessionUrlsDto;
import com.applitools.eyes.selenium.universal.dto.StepInfoDto;
import com.applitools.eyes.selenium.universal.dto.response.CommandCloseResponseDto;
import com.applitools.eyes.selenium.universal.mapper.RectangleSizeMapper;
import java.util.List;
import java.util.stream.Collectors;

public class TestResultsMapper {
    public static TestResults toTestResults(CommandCloseResponseDto response) {
        SessionUrlsDto respApiUrls;
        if (response == null) {
            return null;
        }
        TestResults testResults = new TestResults();
        testResults.setId(response.getId());
        testResults.setName(response.getName());
        testResults.setSecretToken(response.getSecretToken());
        testResults.setStatus(TestResultsMapper.toTestResultsStatus(response.getStatus()));
        testResults.setAppName(response.getAppName());
        testResults.setBatchName(response.getBatchName());
        testResults.setBatchId(response.getBatchId());
        testResults.setBranchName(response.getBranchName());
        testResults.setHostOS(response.getHostOS());
        testResults.setHostApp(response.getHostApp());
        testResults.setHostDisplaySize(RectangleSizeMapper.toRectangleSize(response.getHostDisplaySize()));
        testResults.setStartedAt(null);
        testResults.setDuration(response.getDuration());
        testResults.setStepsInfo(TestResultsMapper.toStepInfoArray(response.getStepsInfo()));
        testResults.setNew(response.isNew());
        testResults.setDifferent(response.getDifferent().booleanValue());
        testResults.setAborted(response.getAborted().booleanValue());
        testResults.setUrl(response.getUrl());
        SessionUrlsDto respAppUrls = response.getAppUrls();
        if (respAppUrls != null) {
            SessionUrls appUrls = new SessionUrls();
            appUrls.setSession(respAppUrls.getSession());
            appUrls.setBatch(respAppUrls.getBatch());
            testResults.setAppUrls(appUrls);
        }
        if ((respApiUrls = response.getApiUrls()) != null) {
            SessionUrls apiUrls = new SessionUrls();
            apiUrls.setSession(respApiUrls.getSession());
            apiUrls.setBatch(respApiUrls.getBatch());
            testResults.setApiUrls(apiUrls);
        }
        testResults.setSteps(response.getSteps().intValue());
        testResults.setMatches(response.getMatches().intValue());
        testResults.setMismatches(response.getMismatches().intValue());
        testResults.setMissing(response.getMissing().intValue());
        testResults.setExactMatches(response.getExactMatches().intValue());
        testResults.setStrictMatches(response.getStrictMatches().intValue());
        testResults.setContentMatches(response.getContentMatches().intValue());
        testResults.setLayoutMatches(response.getLayoutMatches().intValue());
        testResults.setNoneMatches(response.getNoneMatches().intValue());
        testResults.setAccessibilityStatus(response.getAccessibilityStatus());
        return testResults;
    }

    private static StepInfo toStepInfo(StepInfoDto stepInfoDto) {
        if (stepInfoDto == null) {
            return null;
        }
        StepInfo stepInfo = new StepInfo();
        StepInfo.AppUrls appUrls = new StepInfo.AppUrls(stepInfo);
        appUrls.setStep(stepInfoDto.getAppUrls() == null ? null : stepInfoDto.getAppUrls().getStep());
        appUrls.setStepEditor(stepInfoDto.getAppUrls() == null ? null : stepInfoDto.getAppUrls().getStepEditor());
        stepInfo.setAppUrls(appUrls);
        StepInfo.ApiUrls apiUrls = new StepInfo.ApiUrls(stepInfo);
        apiUrls.setBaselineImage(stepInfoDto.getApiUrls() == null ? null : stepInfoDto.getApiUrls().getBaselineImage());
        apiUrls.setCheckpointImage(stepInfoDto.getApiUrls() == null ? null : stepInfoDto.getApiUrls().getCheckpointImage());
        apiUrls.setCheckpointImageThumbnail(stepInfoDto.getApiUrls() == null ? null : stepInfoDto.getApiUrls().getCheckpointImageThumbnail());
        apiUrls.setCurrentImage(stepInfoDto.getApiUrls() == null ? null : stepInfoDto.getApiUrls().getCurrentImage());
        apiUrls.setDiffImage(stepInfoDto.getApiUrls() == null ? null : stepInfoDto.getApiUrls().getDiffImage());
        stepInfo.setApiUrls(apiUrls);
        stepInfo.setName(stepInfoDto.getName());
        stepInfo.setIsDifferent(stepInfoDto.getDifferent());
        stepInfo.setHasBaselineImage(stepInfoDto.getHasBaselineImage().booleanValue());
        stepInfo.setHasCurrentImage(stepInfoDto.getHasCurrentImage().booleanValue());
        return stepInfo;
    }

    private static TestResultsStatus toTestResultsStatus(String status) {
        if (status == null) {
            return TestResultsStatus.Disabled;
        }
        return TestResultsStatus.valueOf((String)status);
    }

    private static StepInfo[] toStepInfoArray(List<StepInfoDto> stepInfoDtoList) {
        if (stepInfoDtoList == null || stepInfoDtoList.isEmpty()) {
            return null;
        }
        return (StepInfo[])stepInfoDtoList.stream().map(TestResultsMapper::toStepInfo).toArray(StepInfo[]::new);
    }

    public static List<TestResults> toTestResultsList(List<CommandCloseResponseDto> responseDtoList) {
        if (responseDtoList == null || responseDtoList.isEmpty()) {
            return null;
        }
        return responseDtoList.stream().map(TestResultsMapper::toTestResults).collect(Collectors.toList());
    }
}

