/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.eyes.selenium.universal.dto.SelectorRegionDto;
import com.applitools.utils.GeneralUtils;
import org.openqa.selenium.By;

public class SelectorRegionMapper {
    public static SelectorRegionDto toSelectorRegionDto(By by) {
        if (by == null) {
            return null;
        }
        SelectorRegionDto selectorRegionDto = new SelectorRegionDto();
        String selector = GeneralUtils.getLastWordOfStringWithRegex((String)by.toString(), (String)":");
        selectorRegionDto.setSelector(selector);
        if (by instanceof By.ById) {
            selectorRegionDto.setType("css selector");
            selectorRegionDto.setSelector(String.format("[id=\"%s\"]", selector));
        } else if (by instanceof By.ByXPath) {
            selectorRegionDto.setType("xpath");
        } else if (by instanceof By.ByLinkText) {
            selectorRegionDto.setType("link text");
        } else if (by instanceof By.ByPartialLinkText) {
            selectorRegionDto.setType("partial link text");
        } else if (by instanceof By.ByName) {
            selectorRegionDto.setType("css selector");
            selectorRegionDto.setSelector(String.format("[name=\"%s\"]", selector));
        } else if (by instanceof By.ByTagName) {
            selectorRegionDto.setType("css selector");
        } else if (by instanceof By.ByClassName) {
            selectorRegionDto.setType("css selector");
            selectorRegionDto.setSelector(".".concat(selector));
        } else if (by instanceof By.ByCssSelector) {
            selectorRegionDto.setType("css selector");
        }
        return selectorRegionDto;
    }
}

