/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.universal.dto.ContextReferenceDto;
import com.applitools.eyes.selenium.universal.dto.ElementRegionDto;
import com.applitools.eyes.selenium.universal.dto.SelectorRegionDto;
import com.applitools.eyes.selenium.universal.mapper.ElementRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.SelectorRegionMapper;
import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ContextReferenceMapper {
    public static ContextReferenceDto toContextReferenceDto(FrameLocator frameLocator) {
        WebElement scrollElement;
        By scrollBy;
        WebElement element;
        By by;
        if (frameLocator == null) {
            return null;
        }
        ContextReferenceDto contextReferenceDto = new ContextReferenceDto();
        if (!Strings.isNullOrEmpty((String)frameLocator.getFrameNameOrId())) {
            contextReferenceDto.setFrame(frameLocator.getFrameNameOrId());
        }
        if (frameLocator.getFrameIndex() != null) {
            contextReferenceDto.setFrame(frameLocator.getFrameIndex());
        }
        if ((by = frameLocator.getFrameSelector()) != null) {
            SelectorRegionDto selectorRegionDto = SelectorRegionMapper.toSelectorRegionDto(by);
            contextReferenceDto.setFrame(selectorRegionDto);
        }
        if ((element = frameLocator.getFrameReference()) != null) {
            ElementRegionDto elementRegionDto = ElementRegionMapper.toElementRegionDto(element);
            contextReferenceDto.setFrame(elementRegionDto);
        }
        if ((scrollBy = frameLocator.getScrollRootSelector()) != null) {
            SelectorRegionDto scrollSelector = SelectorRegionMapper.toSelectorRegionDto(scrollBy);
            contextReferenceDto.setScrollRootElement(scrollSelector);
        }
        if ((scrollElement = frameLocator.getScrollRootElement()) != null) {
            ElementRegionDto elementRegionDto1 = ElementRegionMapper.toElementRegionDto(scrollElement);
            contextReferenceDto.setScrollRootElement(elementRegionDto1);
        }
        return contextReferenceDto;
    }

    public static List<ContextReferenceDto> toContextReferenceDtoList(List<FrameLocator> frameLocatorList) {
        if (frameLocatorList == null || frameLocatorList.isEmpty()) {
            return null;
        }
        return frameLocatorList.stream().map(ContextReferenceMapper::toContextReferenceDto).collect(Collectors.toList());
    }
}

