/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.ICheckSettings;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.universal.dto.CheckSettingsDto;
import com.applitools.eyes.selenium.universal.mapper.CodedRegionReferenceMapper;
import com.applitools.eyes.selenium.universal.mapper.ContextReferenceMapper;
import com.applitools.eyes.selenium.universal.mapper.TAccessibilityRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.TFloatingRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.TRegionMapper;
import com.applitools.eyes.selenium.universal.mapper.VisualGridOptionMapper;
import java.util.Arrays;

public class CheckSettingsMapper {
    public static CheckSettingsDto toCheckSettingsDto(ICheckSettings checkSettings) {
        if (!(checkSettings instanceof SeleniumCheckSettings)) {
            return null;
        }
        SeleniumCheckSettings seleniumCheckSettings = (SeleniumCheckSettings)checkSettings;
        CheckSettingsDto checkSettingsDto = new CheckSettingsDto();
        checkSettingsDto.setName(seleniumCheckSettings.getName());
        checkSettingsDto.setDisableBrowserFetching(seleniumCheckSettings.isDisableBrowserFetching());
        checkSettingsDto.setLayoutBreakpoints(seleniumCheckSettings.getLayoutBreakpoints().isEmpty() ? seleniumCheckSettings.isDefaultLayoutBreakpointsSet() : seleniumCheckSettings.getLayoutBreakpoints());
        checkSettingsDto.setVisualGridOptions(VisualGridOptionMapper.toVisualGridOptionDtoList(seleniumCheckSettings.getVisualGridOptions()));
        checkSettingsDto.setHooks(seleniumCheckSettings.getScriptHooks());
        checkSettingsDto.setRenderId(null);
        checkSettingsDto.setVariationGroupId(seleniumCheckSettings.getVariationGroupId());
        checkSettingsDto.setTimeout(seleniumCheckSettings.getTimeout());
        checkSettingsDto.setWaitBeforeCapture(seleniumCheckSettings.getWaitBeforeCapture());
        checkSettingsDto.setExact(null);
        checkSettingsDto.setMatchLevel(seleniumCheckSettings.getMatchLevel() == null ? null : seleniumCheckSettings.getMatchLevel().getName());
        checkSettingsDto.setSendDom(seleniumCheckSettings.isSendDom());
        checkSettingsDto.setUseDom(seleniumCheckSettings.isUseDom());
        checkSettingsDto.setEnablePatterns(seleniumCheckSettings.isEnablePatterns());
        checkSettingsDto.setIgnoreCaret(seleniumCheckSettings.getIgnoreCaret());
        checkSettingsDto.setIgnoreDisplacements(seleniumCheckSettings.isIgnoreDisplacements());
        checkSettingsDto.setAccessibilitySettings(null);
        checkSettingsDto.setIgnoreRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getIgnoreRegions())));
        checkSettingsDto.setLayoutRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getLayoutRegions())));
        checkSettingsDto.setStrictRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getStrictRegions())));
        checkSettingsDto.setContentRegions(CodedRegionReferenceMapper.toCodedRegionReferenceList(Arrays.asList(seleniumCheckSettings.getContentRegions())));
        checkSettingsDto.setFloatingRegions(TFloatingRegionMapper.toTFloatingRegionDtoList(Arrays.asList(seleniumCheckSettings.getFloatingRegions())));
        checkSettingsDto.setAccessibilityRegions(TAccessibilityRegionMapper.toTAccessibilityRegionDtoList(Arrays.asList(seleniumCheckSettings.getAccessibilityRegions())));
        checkSettingsDto.setPageId(seleniumCheckSettings.getPageId());
        checkSettingsDto.setLazyLoad(seleniumCheckSettings.getLazyLoadOptions());
        checkSettingsDto.setRegion(TRegionMapper.toTRegionFromCheckSettings(checkSettings));
        checkSettingsDto.setFrames(ContextReferenceMapper.toContextReferenceDtoList(seleniumCheckSettings.getFrameChain()));
        checkSettingsDto.setScrollRootElement(TRegionMapper.toTRegionDtoFromScrolls(seleniumCheckSettings.getScrollRootSelector(), seleniumCheckSettings.getScrollRootElement()));
        checkSettingsDto.setFully(seleniumCheckSettings.getStitchContent());
        return checkSettingsDto;
    }
}

