/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.selenium.Reference;
import com.applitools.eyes.selenium.universal.dto.Command;
import com.applitools.eyes.selenium.universal.dto.EventDto;
import com.applitools.eyes.selenium.universal.dto.MatchResultDto;
import com.applitools.eyes.selenium.universal.dto.RectangleSizeDto;
import com.applitools.eyes.selenium.universal.dto.RequestDto;
import com.applitools.eyes.selenium.universal.dto.ResponseDto;
import com.applitools.eyes.selenium.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.selenium.universal.dto.response.CommandCloseResponseDto;
import com.applitools.eyes.selenium.universal.server.UniversalSdkNativeLoader;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;

public class USDKConnection {
    private WebSocket webSocket;
    protected Logger logger = new Logger();
    private ObjectMapper objectMapper;
    private Map<String, SyncTaskListener<ResponseDto<?>>> map = new HashMap();

    public USDKConnection() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void init() {
        this.webSocket = this.openWebsocket();
    }

    private WebSocket openWebsocket() {
        try {
            String url = String.format("ws://localhost:%s/eyes", UniversalSdkNativeLoader.getPort());
            return (WebSocket)Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)new DefaultAsyncHttpClientConfig.Builder().setWebSocketMaxFrameSize(0x10000000)).prepareGet(url).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket webSocket, int i, String s) {
                }

                public void onTextFrame(String payload, boolean finalFragment, int rsv) {
                    if (payload.contains("Core.makeManager") || payload.contains("EyesManager.openEyes")) {
                        try {
                            ResponseDto referenceResponseDto = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<Reference>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(referenceResponseDto.getKey());
                            syncTaskLister.onComplete((Object)referenceResponseDto);
                            USDKConnection.this.map.remove(referenceResponseDto.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("Eyes.check")) {
                        try {
                            ResponseDto checkResponse = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<MatchResultDto>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(checkResponse.getKey());
                            syncTaskLister.onComplete((Object)checkResponse);
                            USDKConnection.this.map.remove(checkResponse.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("Eyes.locate")) {
                        try {
                            ResponseDto locateResponse = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<Map<String, List<Region>>>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(locateResponse.getKey());
                            syncTaskLister.onComplete((Object)locateResponse);
                            USDKConnection.this.map.remove(locateResponse.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("Eyes.close") || payload.contains("Eyes.abort") || payload.contains("EyesManager.closeAllEyes")) {
                        try {
                            ResponseDto closeResponse = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<List<CommandCloseResponseDto>>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(closeResponse.getKey());
                            syncTaskLister.onComplete((Object)closeResponse);
                            USDKConnection.this.map.remove(closeResponse.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("Eyes.extractTextRegions")) {
                        try {
                            ResponseDto extractTextRegionsResponse = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<Map<String, List<TextRegion>>>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(extractTextRegionsResponse.getKey());
                            syncTaskLister.onComplete((Object)extractTextRegionsResponse);
                            USDKConnection.this.map.remove(extractTextRegionsResponse.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("Eyes.extractText")) {
                        try {
                            ResponseDto responseDto = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<List<String>>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(responseDto.getKey());
                            syncTaskLister.onComplete((Object)responseDto);
                            USDKConnection.this.map.remove(responseDto.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("Core.getViewportSize")) {
                        try {
                            ResponseDto getViewportSizeResponse = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<RectangleSizeDto>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(getViewportSizeResponse.getKey());
                            syncTaskLister.onComplete((Object)getViewportSizeResponse);
                            USDKConnection.this.map.remove(getViewportSizeResponse.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (payload.contains("EyesManager.closeManager")) {
                        try {
                            ResponseDto closeManagerResponse = (ResponseDto)USDKConnection.this.objectMapper.readValue(payload, (TypeReference)new TypeReference<ResponseDto<TestResultsSummaryDto>>(){});
                            SyncTaskListener syncTaskLister = (SyncTaskListener)USDKConnection.this.map.get(closeManagerResponse.getKey());
                            syncTaskLister.onComplete((Object)closeManagerResponse);
                            USDKConnection.this.map.remove(closeManagerResponse.getKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onError(Throwable t) {
                    throw new EyesException("Websocket communication error: " + t.getMessage(), t);
                }
            }).build()).get();
        }
        catch (Exception e) {
            throw new EyesException("Communication with server failed, reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized SyncTaskListener executeCommand(Command command, boolean waitResult) throws Exception {
        if (command instanceof EventDto) {
            this.webSocket.sendTextFrame(this.objectMapper.writeValueAsString((Object)command));
            return null;
        }
        RequestDto request = (RequestDto)command;
        SyncTaskListener syncTaskListener = new SyncTaskListener(this.logger, request.getKey());
        this.map.put(request.getKey(), syncTaskListener);
        this.webSocket.sendTextFrame(this.objectMapper.writeValueAsString((Object)request));
        return syncTaskListener;
    }
}

