/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.NullLogHandler;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.WebDriverProxySettings;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.locators.TextRegionSettings;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.locators.VisualLocatorsProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.CommandExecutor;
import com.applitools.eyes.selenium.Configuration;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.Reference;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.universal.dto.CheckSettingsDto;
import com.applitools.eyes.selenium.universal.dto.ConfigurationDto;
import com.applitools.eyes.selenium.universal.dto.DriverDto;
import com.applitools.eyes.selenium.universal.dto.OCRExtractSettingsDto;
import com.applitools.eyes.selenium.universal.dto.OCRSearchSettingsDto;
import com.applitools.eyes.selenium.universal.dto.RectangleSizeDto;
import com.applitools.eyes.selenium.universal.dto.VisualLocatorSettingsDto;
import com.applitools.eyes.selenium.universal.dto.response.CommandCloseResponseDto;
import com.applitools.eyes.selenium.universal.mapper.CheckSettingsMapper;
import com.applitools.eyes.selenium.universal.mapper.ConfigurationMapper;
import com.applitools.eyes.selenium.universal.mapper.DriverMapper;
import com.applitools.eyes.selenium.universal.mapper.OCRExtractSettingsDtoMapper;
import com.applitools.eyes.selenium.universal.mapper.OCRSearchSettingsMapper;
import com.applitools.eyes.selenium.universal.mapper.RectangleSizeMapper;
import com.applitools.eyes.selenium.universal.mapper.TestResultsMapper;
import com.applitools.eyes.selenium.universal.mapper.VisualLocatorSettingsMapper;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.utils.ArgumentGuard;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Eyes
implements IEyesBase {
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private boolean isVisualGridEyes = false;
    private EyesRunner runner;
    private com.applitools.eyes.config.Configuration configuration = new com.applitools.eyes.config.Configuration();
    private ImageRotation rotation;
    private WebDriver driver;
    VisualLocatorsProvider visualLocatorsProvider;
    ConfigurationProvider configurationProvider = new ConfigurationProvider(){

        public com.applitools.eyes.config.Configuration get() {
            return Eyes.this.configuration;
        }
    };
    private CommandExecutor commandExecutor;
    private Reference eyesRef;
    private boolean isClosed;

    public Eyes() {
        this(new ClassicRunner());
    }

    public Eyes(EyesRunner runner0) {
        this.runner = runner0 == null ? new ClassicRunner() : runner0;
        this.commandExecutor = this.runner.getCommandExecutor();
    }

    public WebDriver open(WebDriver webDriver) {
        return this.open(webDriver, this.configuration.getAppName(), this.configuration.getTestName());
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, this.configuration.getViewportSize());
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        if (this.getIsDisabled().booleanValue()) {
            return driver;
        }
        WebDriverProxySettings wdProxy = this.configuration.getWebDriverProxy();
        String wdProxyUrl = wdProxy != null ? wdProxy.getProxyUrl() : null;
        DriverDto driverDto = DriverMapper.toDriverDto(driver, wdProxyUrl);
        this.configurationProvider.get().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.configurationProvider.get().setViewportSize(new RectangleSize(viewportSize));
        }
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto(this.configuration, this.runner.isDontCloseBatches());
        this.eyesRef = this.commandExecutor.managerOpenEyes(this.runner.getManagerRef(), driverDto, configurationDto);
        this.driver = driver;
        return driver;
    }

    public void setServerUrl(String serverUrl) {
        this.configuration.setServerUrl(serverUrl);
    }

    public void setServerUrl(URI serverUri) {
        this.configuration.setServerUrl(serverUri.toString());
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        this.configuration.setProxy(proxySettings);
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.configuration.setIsDisabled(isDisabled);
    }

    public void check(ICheckSettings checkSettings) {
        this.check((String)null, checkSettings);
    }

    public TestResults close() {
        return this.close(true);
    }

    public TestResults abortIfNotClosed() {
        return this.abort();
    }

    public TestResults abort() {
        if (!this.isClosed && this.getIsOpen()) {
            List<CommandCloseResponseDto> abortResponse = this.commandExecutor.abort(this.eyesRef, true);
            List<TestResults> testResults = TestResultsMapper.toTestResultsList(abortResponse);
            this.eyesRef = null;
            if (testResults != null) {
                return testResults.isEmpty() ? null : testResults.get(0);
            }
        }
        return null;
    }

    public void abortAsync() {
        if (!this.isClosed && this.getIsOpen()) {
            this.commandExecutor.abort(this.eyesRef, false);
            this.eyesRef = null;
        }
    }

    public Boolean getIsDisabled() {
        return this.configuration.getIsDisabled();
    }

    public String getApiKey() {
        return this.configuration.getApiKey();
    }

    public void setApiKey(String apiKey) {
        this.configuration.setApiKey(apiKey);
    }

    public void setBranchName(String branchName) {
        this.configuration.setBranchName(branchName);
    }

    public void setParentBranchName(String branchName) {
        this.configuration.setParentBranchName(branchName);
    }

    public void setHideCaret(boolean hideCaret) {
        this.configuration.setHideCaret(hideCaret);
    }

    public void setMatchTimeout(int ms) {
        this.configuration.setMatchTimeout(Integer.valueOf(ms));
    }

    public int getMatchTimeout() {
        return this.configuration.getMatchTimeout();
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.configuration.setSaveNewTests(Boolean.valueOf(saveNewTests));
    }

    public boolean getSaveNewTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.configuration.setSaveFailedTests(Boolean.valueOf(saveFailedTests));
    }

    public boolean getSaveFailedTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setBatch(BatchInfo batch) {
        this.configuration.setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.configuration.getBatch();
    }

    public void setFailureReports(FailureReports failureReports) {
        this.configuration.setFailureReports(failureReports);
    }

    public FailureReports getFailureReports() {
        return this.configuration.getFailureReports();
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.configuration.setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configuration.getDefaultMatchSettings();
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.configuration.getDefaultMatchSettings().setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.configuration.getDefaultMatchSettings().getMatchLevel();
    }

    public String getFullAgentId() {
        return this.configuration.getAgentId();
    }

    public boolean getIsOpen() {
        return this.eyesRef != null;
    }

    public static URI getDefaultServerUrl() {
        return SeleniumEyes.getDefaultServerUrl();
    }

    public void setLogHandler(LogHandler logHandler) {
    }

    public LogHandler getLogHandler() {
        return new NullLogHandler();
    }

    public Logger getLogger() {
        return new Logger();
    }

    public void setImageCut(CutProvider cutProvider) {
        this.configuration.setCutProvider(cutProvider);
    }

    public boolean getIsCutProviderExplicitlySet() {
        return false;
    }

    public void check(String tag, ICheckSettings checkSettings) {
        if (tag != null) {
            checkSettings = checkSettings.withName(tag);
        }
        CheckSettingsDto checkSettingsDto = CheckSettingsMapper.toCheckSettingsDto(checkSettings);
        this.checkDto(checkSettingsDto);
    }

    private void checkDto(CheckSettingsDto checkSettingsDto) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        if (!this.getIsOpen()) {
            this.abort();
            throw new EyesException("you must call open() before checking");
        }
        ArgumentGuard.notNull((Object)checkSettingsDto, (String)"checkSettings");
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto(this.configuration, this.runner.isDontCloseBatches());
        this.commandExecutor.eyesCheck(this.eyesRef, checkSettingsDto, configurationDto);
    }

    public TestResults close(boolean shouldThrowException) {
        if (this.getIsDisabled().booleanValue()) {
            return null;
        }
        if (!this.getIsOpen()) {
            throw new EyesException("Eyes not open");
        }
        List<CommandCloseResponseDto> closeResponse = this.commandExecutor.close(this.eyesRef, true);
        this.eyesRef = null;
        this.isClosed = true;
        List<TestResults> testResults = TestResultsMapper.toTestResultsList(closeResponse);
        testResults.forEach(testResults1 -> this.runner.logSessionResultsAndThrowException(shouldThrowException, (TestResults)testResults1));
        return testResults.get(0);
    }

    public void setScaleRatio(Double scaleRatio) {
        this.configuration.setScaleRatio(scaleRatio);
    }

    public Double getScaleRatio() {
        return this.configuration.getScaleRatio();
    }

    public void addProperty(String name, String value) {
        this.configuration.addProperty(name, value);
    }

    public void clearProperties() {
        this.configuration.clearProperties();
    }

    public void setSaveDebugScreenshots(Boolean saveDebugScreenshots) {
        this.configuration.setSaveDebugScreenshots(saveDebugScreenshots);
    }

    public Boolean getSaveDebugScreenshots() {
        return this.configuration.getSaveDebugScreenshots();
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.configuration.setDebugScreenshotsPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.configuration.getDebugScreenshotsPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.configuration.setDebugScreenshotsPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.configuration.getDebugScreenshotsPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return null;
    }

    public boolean getIgnoreCaret() {
        return this.configuration.getIgnoreCaret();
    }

    public void setIgnoreCaret(boolean value) {
        this.configuration.setIgnoreCaret(Boolean.valueOf(value));
    }

    public int getStitchOverlap() {
        return this.configuration.getStitchOverlap();
    }

    public void setStitchOverlap(int pixels) {
        this.configuration.setStitchOverlap(Integer.valueOf(pixels));
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(Region region, int matchTimeout, String tag) throws TestFailedException {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.check((ICheckSettings)Target.region(region).timeout(matchTimeout).withName(tag));
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, -1, null, true);
    }

    public void checkRegion(WebElement element, boolean stitchContent) {
        this.checkRegion(element, -1, null, stitchContent);
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.checkRegion(element, -1, tag, stitchContent);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag) {
        this.checkRegion(element, matchTimeout, tag, true);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.check((ICheckSettings)Target.region(element).timeout(matchTimeout).withName(tag).fully(stitchContent));
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, -1, null, false);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.checkRegion(selector, -1, null, stitchContent);
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag, true);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.checkRegion(selector, -1, tag, stitchContent);
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        this.checkRegion(selector, matchTimeout, tag, true);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, null, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameIndex, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, null, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, -1, null);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, null, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, true);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameReference, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkElement(WebElement element) {
        this.checkElement(element, null);
    }

    public void checkElement(WebElement element, String tag) {
        this.checkElement(element, -1, tag);
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.checkElement(selector, -1, null);
    }

    public void checkElement(By selector, String tag) {
        this.checkElement(selector, -1, tag);
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
    }

    public void addTextTrigger(Region control, String text) {
    }

    public void addTextTrigger(WebElement element, String text) {
    }

    public RectangleSize getViewportSize() {
        return null;
    }

    public static RectangleSize getViewportSize(WebDriver driver) {
        DriverDto driverDto = DriverMapper.toDriverDto(driver, null);
        RectangleSizeDto rectangleSizeDto = CommandExecutor.getViewportSize(driverDto);
        return RectangleSizeMapper.toRectangleSize(rectangleSizeDto);
    }

    public static void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesDriverUtils.setViewportSize((Logger)new Logger(), (WebDriver)driver, (RectangleSize)size);
    }

    public boolean getHideCaret() {
        return this.configuration.getHideCaret();
    }

    public boolean shouldStitchContent() {
        return false;
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.configuration.setForceFullPageScreenshot(shouldForce);
    }

    public boolean getForceFullPageScreenshot() {
        Boolean forceFullPageScreenshot = this.configuration.getForceFullPageScreenshot();
        if (forceFullPageScreenshot == null) {
            return this.isVisualGridEyes;
        }
        return forceFullPageScreenshot;
    }

    public void setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.configuration.setWaitBeforeScreenshots(waitBeforeScreenshots);
    }

    public int getWaitBeforeScreenshots() {
        return this.configuration.getWaitBeforeScreenshots();
    }

    public void setScrollToRegion(boolean shouldScroll) {
    }

    public boolean getScrollToRegion() {
        return false;
    }

    public void setStitchMode(StitchMode mode) {
        this.configuration.setStitchMode(mode);
    }

    public StitchMode getStitchMode() {
        return this.configuration.getStitchMode();
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.configuration.setHideScrollbars(shouldHide);
    }

    public boolean getHideScrollbars() {
        return this.configuration.getHideScrollbars();
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.configuration.setRotation(Integer.valueOf(rotation.getRotation()));
        this.rotation = rotation;
    }

    public double getDevicePixelRatio() {
        return 0.0;
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    public void checkWindow(String tag, boolean fully) {
        this.check(tag, (ICheckSettings)Target.window().fully(fully));
    }

    public void check(ICheckSettings ... checkSettings) {
        for (ICheckSettings checkSettings1 : checkSettings) {
            this.check(checkSettings1);
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.checkFrame(frameNameOrId, null);
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.checkFrame(frameNameOrId, -1, tag);
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully().timeout(matchTimeout));
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout).fully());
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout));
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, null);
    }

    public URI getServerUrl() {
        return this.configuration.getServerUrl();
    }

    public void setAgentId(String agentId) {
        this.configuration.setAgentId(agentId);
    }

    public String getAgentId() {
        return this.configuration.getAgentId();
    }

    public void setServerConnector(ServerConnector serverConnector) {
    }

    public AbstractProxySettings getProxy() {
        return this.configuration.getProxy();
    }

    public void setAppName(String appName) {
        this.configuration.setAppName(appName);
    }

    public String getAppName() {
        return this.configuration.getAppName();
    }

    public String getHostOS() {
        return this.configuration.getHostOS();
    }

    public String getHostApp() {
        return this.configuration.getHostApp();
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.configuration.setBaselineEnvName(baselineEnvName);
    }

    public String getBaselineEnvName() {
        return this.configuration.getBaselineEnvName();
    }

    public void setEnvName(String envName) {
        this.configuration.setEnvironmentName(envName);
    }

    public String getEnvName() {
        return this.configuration.getEnvironmentName();
    }

    public PositionProvider getPositionProvider() {
        return null;
    }

    public void setPositionProvider(PositionProvider positionProvider) {
    }

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
    }

    public void log(String message) {
    }

    public boolean isSendDom() {
        return this.configuration.isSendDom();
    }

    public void setSendDom(boolean isSendDom) {
        this.configuration.setSendDom(Boolean.valueOf(isSendDom));
    }

    public void setHostOS(String hostOS) {
        this.configuration.setHostOS(hostOS);
    }

    public void setHostApp(String hostApp) {
        this.configuration.setHostApp(hostApp);
    }

    public RenderingInfo getRenderingInfo() {
        return null;
    }

    public String getBranchName() {
        return this.configuration.getBranchName();
    }

    public String getParentBranchName() {
        return this.configuration.getParentBranchName();
    }

    public void setBaselineBranchName(String branchName) {
        this.configuration.setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configuration.getBaselineBranchName();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.configuration.setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configuration.getSaveDiffs();
    }

    public void setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.configuration.setIgnoreDisplacements(Boolean.valueOf(isIgnoreDisplacements));
    }

    public boolean getIgnoreDisplacements() {
        return this.configuration.getIgnoreDisplacements();
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.configuration.setDebugResourceWriter(debugResourceWriter);
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public FrameChain getOriginalFC() {
        return null;
    }

    public PositionProvider getCurrentFramePositionProvider() {
        return null;
    }

    public Region getRegionToCheck() {
        return null;
    }

    public void setRegionToCheck(Region regionToCheck) {
    }

    public WebElement getCurrentFrameScrollRootElement() {
        return null;
    }

    public ServerConnector getServerConnector() {
        return null;
    }

    public Configuration getConfiguration() {
        return new Configuration(this.configuration);
    }

    public void setConfiguration(com.applitools.eyes.config.Configuration configuration) {
        AbstractProxySettings proxy;
        URI serverUrl;
        ArgumentGuard.notNull((Object)configuration, (String)"configuration");
        String apiKey = configuration.getApiKey();
        if (apiKey != null) {
            this.setApiKey(apiKey);
        }
        if ((serverUrl = configuration.getServerUrl()) != null) {
            this.setServerUrl(serverUrl.toString());
        }
        if ((proxy = configuration.getProxy()) != null) {
            this.setProxy(proxy);
        }
        this.configuration = new com.applitools.eyes.config.Configuration(configuration);
    }

    public void closeAsync() {
        if (Boolean.TRUE.equals(this.getIsDisabled())) {
            return;
        }
        if (!this.getIsOpen()) {
            throw new EyesException("Eyes not open");
        }
        List<CommandCloseResponseDto> closeResponse = this.commandExecutor.close(this.eyesRef, false);
        this.eyesRef = null;
        this.isClosed = true;
        if (closeResponse != null) {
            List<TestResults> testResults = TestResultsMapper.toTestResultsList(closeResponse);
            testResults.forEach(testResults1 -> this.runner.logSessionResultsAndThrowException(false, (TestResults)testResults1));
        }
    }

    public Map<String, List<Region>> locate(VisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        VisualLocatorSettingsDto visualLocatorSettingsDto = VisualLocatorSettingsMapper.toVisualLocatorSettingsDto(visualLocatorSettings);
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto(this.configuration, this.runner.isDontCloseBatches());
        return this.commandExecutor.locate(this.eyesRef, visualLocatorSettingsDto, configurationDto);
    }

    public Map<String, List<TextRegion>> extractTextRegions(TextRegionSettings textRegionSettings) {
        OCRSearchSettingsDto ocrSearchSettingsDto = OCRSearchSettingsMapper.toOCRSearchSettingsDto(textRegionSettings);
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto(this.configuration, this.runner.isDontCloseBatches());
        return this.commandExecutor.extractTextRegions(this.eyesRef, ocrSearchSettingsDto, configurationDto);
    }

    public List<String> extractText(BaseOcrRegion ... ocrRegions) {
        List<OCRExtractSettingsDto> ocrExtractSettingsDtoList = OCRExtractSettingsDtoMapper.toOCRExtractSettingsDtoList(Arrays.asList(ocrRegions));
        ConfigurationDto configurationDto = ConfigurationMapper.toConfigurationDto(this.configuration, this.runner.isDontCloseBatches());
        return this.commandExecutor.extractText(this.eyesRef, ocrExtractSettingsDtoList, configurationDto);
    }

    public Reference getEyesRef() {
        return this.eyesRef;
    }

    public com.applitools.eyes.config.Configuration configure() {
        return this.configuration;
    }
}

