/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.selenium.PathNodeValue;
import com.applitools.utils.GeneralUtils;
import org.openqa.selenium.By;

public class ElementSelector
implements PathNodeValue {
    private String type;
    private String selector;

    public ElementSelector(By by) {
        String selector;
        this.selector = selector = GeneralUtils.getLastWordOfStringWithRegex((String)by.toString(), (String)":");
        if (by instanceof By.ById) {
            this.type = "css selector";
            this.selector = String.format("[id=\"%s\"]", selector);
        } else if (by instanceof By.ByXPath) {
            this.type = "xpath";
        } else if (by instanceof By.ByLinkText) {
            this.type = "link text";
        } else if (by instanceof By.ByPartialLinkText) {
            this.type = "partial link text";
        } else if (by instanceof By.ByName) {
            this.type = "css selector";
            this.selector = String.format("[name=\"%s\"]", selector);
        } else if (by instanceof By.ByTagName) {
            this.type = "css selector";
        } else if (by instanceof By.ByClassName) {
            this.type = "css selector";
            this.selector = ".".concat(selector);
        } else if (by instanceof By.ByCssSelector) {
            this.type = "css selector";
        }
    }

    public ElementSelector(String selector) {
        this.type = "css selector";
        this.selector = selector;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getType() {
        return this.type;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setType(String type) {
        this.type = type;
    }
}

