/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.selenium.CommandExecutor;
import com.applitools.eyes.selenium.Reference;
import com.applitools.eyes.selenium.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.selenium.universal.mapper.TestResultsSummaryMapper;
import com.applitools.eyes.selenium.universal.server.UniversalSdkNativeLoader;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EyesRunner {
    protected ServerConnector serverConnector = new ServerConnector();
    private TestResultsSummary allTestResults = null;
    protected CommandExecutor commandExecutor;
    protected Reference managerRef;
    protected static String BASE_AGENT_ID = "eyes.sdk.java";
    protected static String VERSION = ClassVersionGetter.CURRENT_VERSION;
    private Boolean dontCloseBatches;
    protected Logger logger = new Logger();
    private final Map<String, IBatchCloser> batchesServerConnectorsMap = new HashMap<String, IBatchCloser>();

    public EyesRunner() {
        this.runServer(BASE_AGENT_ID, VERSION);
    }

    public EyesRunner(String baseAgentId, String version) {
        this.runServer(baseAgentId, version);
    }

    protected void runServer(String baseAgentId, String version) {
        UniversalSdkNativeLoader.start();
        this.commandExecutor = CommandExecutor.getInstance(baseAgentId, version);
    }

    public abstract TestResultsSummary getAllTestResultsImpl(boolean var1);

    public TestResultsSummary getAllTestResults() {
        return this.getAllTestResults(true);
    }

    public TestResultsSummary getAllTestResults(boolean shouldThrowException) {
        TestResultsSummaryDto dto = this.commandExecutor.closeManager(this.managerRef, shouldThrowException);
        return TestResultsSummaryMapper.fromDto(dto, shouldThrowException);
    }

    private void deleteAllBatches() {
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public void setDontCloseBatches(boolean dontCloseBatches) {
        this.dontCloseBatches = dontCloseBatches;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addBatch(String batchId, IBatchCloser batchCloser) {
        if (!this.batchesServerConnectorsMap.containsKey(batchId)) {
            this.batchesServerConnectorsMap.put(batchId, batchCloser);
        }
    }

    public void setServerUrl(String serverUrl) {
        if (serverUrl != null) {
            URI defaultServerUrl = GeneralUtils.getServerUrl();
            if (this.serverConnector.getServerUrl().equals(defaultServerUrl) && !serverUrl.equals(defaultServerUrl.toString())) {
                try {
                    this.serverConnector.setServerUrl(new URI(serverUrl));
                }
                catch (URISyntaxException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
                }
            } else if (!this.serverConnector.getServerUrl().toString().equals(serverUrl)) {
                throw new EyesException(String.format("Server url was already set to %s", this.serverConnector.getServerUrl()));
            }
        }
    }

    public String getServerUrl() {
        return this.serverConnector.getServerUrl().toString();
    }

    public String getApiKey() {
        return this.serverConnector.getApiKey();
    }

    public void setApiKey(String apiKey) {
        if (apiKey != null) {
            if (!this.serverConnector.wasApiKeySet()) {
                this.serverConnector.setApiKey(apiKey);
            } else if (!this.serverConnector.getApiKey().equals(apiKey)) {
                throw new EyesException(String.format("Api key was already set to %s", this.serverConnector.getApiKey()));
            }
        }
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public ServerConnector getServerConnector() {
        return this.serverConnector;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
    }

    public AbstractProxySettings getProxy() {
        return null;
    }

    public void setAgentId(String agentId) {
        if (agentId != null) {
            this.serverConnector.setAgentId(agentId);
        }
    }

    public String getAgentId() {
        return this.serverConnector.getAgentId();
    }

    public Reference getManagerRef() {
        return this.managerRef;
    }

    public void setManagerRef(Reference managerRef) {
        this.managerRef = managerRef;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public void logSessionResultsAndThrowException(boolean throwEx, TestResults results) {
        if (results == null) {
            return;
        }
        TestResultsStatus status = results.getStatus();
        String sessionResultsUrl = results.getUrl();
        String scenarioIdOrName = results.getName();
        String appIdOrName = results.getAppName();
        if (status == null) {
            throw new EyesException("Status is null in the test results");
        }
        this.logger.log(results.getId(), Stage.CLOSE, Type.TEST_RESULTS, new Pair[]{Pair.of((Object)"status", (Object)status), Pair.of((Object)"url", (Object)sessionResultsUrl)});
        switch (status) {
            case Failed: {
                if (!throwEx) break;
                throw new TestFailedException(results, scenarioIdOrName, appIdOrName);
            }
            case Passed: {
                break;
            }
            case NotOpened: {
                if (!throwEx) break;
                throw new EyesException("Called close before calling open");
            }
            case Unresolved: {
                if (results.isNew().booleanValue()) {
                    if (!throwEx) break;
                    throw new NewTestException(results, scenarioIdOrName, appIdOrName);
                }
                if (!throwEx) break;
                throw new DiffsFoundException(results, scenarioIdOrName, appIdOrName);
            }
        }
    }

    public Boolean isDontCloseBatches() {
        return this.dontCloseBatches;
    }
}

