/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.fluent.GetFloatingRegion;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class FloatingRegionByElement
implements GetFloatingRegion {
    private WebElement element;
    private int maxUpOffset;
    private int maxDownOffset;
    private int maxLeftOffset;
    private int maxRightOffset;

    public FloatingRegionByElement(WebElement element, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.element = element;
        this.maxUpOffset = maxUpOffset;
        this.maxDownOffset = maxDownOffset;
        this.maxLeftOffset = maxLeftOffset;
        this.maxRightOffset = maxRightOffset;
    }

    public FloatingMatchSettings getRegion(EyesBase eyesBase, EyesScreenshot screenshot) {
        Point locationAsPoint = this.element.getLocation();
        Dimension size = this.element.getSize();
        Location adjustedLocation = screenshot.getLocationInScreenshot(new Location(locationAsPoint.getX(), locationAsPoint.getY()), CoordinatesType.CONTEXT_RELATIVE);
        return new FloatingMatchSettings(adjustedLocation.getX(), adjustedLocation.getY(), size.getWidth(), size.getHeight(), this.maxUpOffset, this.maxDownOffset, this.maxLeftOffset, this.maxRightOffset);
    }
}

