/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class SafariScreenshotImageProvider
implements ImageProvider {
    private final Eyes eyes;
    private final Logger logger;
    private final TakesScreenshot tsInstance;
    private final IEyesJsExecutor jsExecutor;
    private final UserAgent userAgent;

    public SafariScreenshotImageProvider(Eyes eyes, Logger logger, TakesScreenshot tsInstance, UserAgent userAgent) {
        this.eyes = eyes;
        this.logger = logger;
        this.tsInstance = tsInstance;
        this.jsExecutor = new SeleniumJavaScriptExecutor((EyesWebDriver)eyes.getDriver());
        this.userAgent = userAgent;
    }

    public BufferedImage getImage() {
        this.logger.verbose("Getting screenshot as base64...");
        String screenshot64 = (String)this.tsInstance.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Creating BufferedImage...");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        this.eyes.getDebugScreenshotsProvider().save(image, "SAFARI");
        if (this.eyes.getIsCutProviderExplicitlySet()) {
            return image;
        }
        double scaleRatio = this.eyes.getDevicePixelRatio();
        RectangleSize originalViewportSize = this.eyes.getViewportSize();
        RectangleSize viewportSize = originalViewportSize.scale(scaleRatio);
        this.logger.verbose("logical viewport size: " + originalViewportSize);
        if (this.userAgent.getOS().equals("IOS")) {
            int topBarHeight = 20;
            int leftBarWidth = 0;
            int bottomBarHeight = 44;
            int rightBarWidth = 0;
            int urlBarHeight = 44;
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            int displayLogicalWidth = (int)Math.ceil((double)imageWidth / scaleRatio);
            int displayLogicalHeight = (int)Math.ceil((double)imageHeight / scaleRatio);
            this.logger.verbose("physical device pixel size: " + imageWidth + " x " + imageHeight);
            this.logger.verbose("physical device logical size: " + displayLogicalWidth + " x " + displayLogicalHeight);
            if (displayLogicalHeight == 736 && displayLogicalWidth == 414) {
                this.logger.verbose("iPhone 5.5 inch detected");
                topBarHeight = 18;
            } else if (displayLogicalHeight == 812 && displayLogicalWidth == 375) {
                this.logger.verbose("iPhone 5.8 inch portrait detected");
                topBarHeight = 44;
                bottomBarHeight = 83;
            } else if (displayLogicalWidth == 812 && displayLogicalHeight == 375) {
                this.logger.verbose("iPhone 5.8 inch landscape detected");
                leftBarWidth = 44;
                rightBarWidth = 44;
            }
            if (displayLogicalHeight < displayLogicalWidth) {
                this.logger.verbose("landscape mode detected");
                topBarHeight = 0;
                bottomBarHeight = displayLogicalWidth == 812 && displayLogicalHeight == 375 ? 15 : 0;
            }
            if (Integer.parseInt(this.userAgent.getBrowserMajorVersion()) >= 11) {
                this.logger.verbose("safari version 11 or higher detected");
                urlBarHeight = 50;
            }
            viewportSize = new RectangleSize((int)Math.ceil((double)imageWidth - (double)(leftBarWidth + rightBarWidth) * scaleRatio), (int)Math.ceil((double)imageHeight - (double)(topBarHeight + urlBarHeight + bottomBarHeight) * scaleRatio));
            this.logger.verbose("computed physical viewport size: " + viewportSize);
            this.logger.verbose("cropping IOS browser image");
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region((int)Math.ceil((double)leftBarWidth * scaleRatio), (int)Math.ceil((double)(topBarHeight + urlBarHeight) * scaleRatio), viewportSize.getWidth(), viewportSize.getHeight()));
        } else if (!this.eyes.getForceFullPageScreenshot()) {
            Location loc;
            FrameChain currentFrameChain = ((EyesWebDriver)this.eyes.getDriver()).getFrameChain();
            if (currentFrameChain.size() == 0) {
                ScrollPositionProvider positionProvider = new ScrollPositionProvider(this.logger, this.jsExecutor);
                loc = positionProvider.getCurrentPosition();
            } else {
                loc = currentFrameChain.getDefaultContentScrollPosition();
            }
            loc = loc.scale(scaleRatio);
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(loc, viewportSize));
        }
        return image;
    }
}

