/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class FirefoxScreenshotImageProvider
implements ImageProvider {
    private final SeleniumEyes eyes;
    private final TakesScreenshot tsInstance;

    public FirefoxScreenshotImageProvider(SeleniumEyes eyes, TakesScreenshot tsInstance) {
        this.eyes = eyes;
        this.tsInstance = tsInstance;
    }

    public BufferedImage getImage() {
        EyesSeleniumDriver eyesSeleniumDriver = (EyesSeleniumDriver)this.eyes.getDriver();
        FrameChain frameChain = eyesSeleniumDriver.getFrameChain().clone();
        eyesSeleniumDriver.switchTo().defaultContent();
        String screenshot64 = (String)this.tsInstance.getScreenshotAs(OutputType.BASE64);
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        this.eyes.getDebugScreenshotsProvider().save(image, "FIREFOX");
        ((EyesTargetLocator)eyesSeleniumDriver.switchTo()).frames(frameChain);
        return image;
    }
}

