/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class SeleniumScrollPositionProvider
implements ScrollPositionProvider,
ISeleniumPositionProvider {
    protected final Logger logger;
    protected final IEyesJsExecutor executor;
    protected final WebElement scrollRootElement;

    public SeleniumScrollPositionProvider(Logger logger, IEyesJsExecutor executor, WebElement scrollRootElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        this.logger = logger;
        this.executor = executor;
        this.scrollRootElement = scrollRootElement;
        logger.verbose("creating ScrollPositionProvider");
    }

    public static Location getCurrentPosition(IEyesJsExecutor executor, WebElement scrollRootElement) {
        Object position = executor.executeScript("return arguments[0].scrollLeft+';'+arguments[0].scrollTop;", new Object[]{scrollRootElement});
        return EyesDriverUtils.parseLocationString((Object)position);
    }

    public Location getCurrentPosition() {
        return SeleniumScrollPositionProvider.getCurrentPosition(this.executor, this.scrollRootElement);
    }

    public Location setPosition(Location location) {
        this.logger.verbose(String.format("setting position of %s to %s", this.scrollRootElement, location));
        Object position = this.executor.executeScript(String.format("arguments[0].scrollLeft=%d; arguments[0].scrollTop=%d; return (arguments[0].scrollLeft+';'+arguments[0].scrollTop);", location.getX(), location.getY()), new Object[]{this.scrollRootElement});
        return EyesDriverUtils.parseLocationString((Object)position);
    }

    public void setPosition(WebElement element) {
        Point loc = element.getLocation();
        this.setPosition(new Location(loc.x, loc.y));
    }

    public RectangleSize getEntireSize() {
        RectangleSize entireSize = EyesDriverUtils.getEntireElementSize((Logger)this.logger, (IEyesJsExecutor)this.executor, (WebElement)this.scrollRootElement);
        this.logger.verbose("ScrollPositionProvider - Entire size: " + entireSize);
        return entireSize;
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ScrollPositionMemento s = (ScrollPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }

    @Override
    public WebElement getScrolledElement() {
        return this.scrollRootElement;
    }

    public boolean equals(SeleniumScrollPositionProvider other) {
        return this.scrollRootElement.equals(other.scrollRootElement);
    }

    public boolean equals(Object other) {
        if (other instanceof SeleniumScrollPositionProvider) {
            return this.equals((SeleniumScrollPositionProvider)other);
        }
        return false;
    }

    public int hashCode() {
        if (this.scrollRootElement != null) {
            return this.scrollRootElement.hashCode();
        }
        return 0;
    }

    public String toString() {
        return "ScrollPositionProvider{scrollRootElement=" + this.scrollRootElement + '}';
    }
}

