/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.CaretVisibilityProvider;
import com.applitools.eyes.selenium.CheckState;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.ContextBasedScaleProviderFactory;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.NullPositionProvider;
import com.applitools.eyes.selenium.PageState;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.capture.DomCapture;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.selenium.capture.FullPageCaptureAlgorithm;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.capture.MobileScreenshotImageProvider;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.PositionProviderFactory;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensationFactory;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.positioning.SeleniumScrollPositionProvider;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.http.annotation.Obsolete;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumEyes
extends EyesBase
implements ISeleniumEyes,
IBatchCloser {
    private FrameChain originalFC;
    private WebElement userDefinedSRE;
    private PositionProvider currentFramePositionProvider;
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int RESPONSE_TIME_DEFAULT_DEADLINE = 10;
    private static final int RESPONSE_TIME_DEFAULT_DIFF_FROM_DEADLINE = 20;
    private EyesSeleniumDriver driver;
    private boolean doNotGetTitle;
    public boolean checkFrameOrElement;
    private Region regionToCheck;
    private String originalOverflow;
    private ImageRotation rotation;
    private double devicePixelRatio;
    private PropertyHandler<RegionVisibilityStrategy> regionVisibilityStrategyHandler;
    private SeleniumJavaScriptExecutor jsExecutor;
    private UserAgent userAgent;
    private ImageProvider imageProvider;
    private RegionPositionCompensation regionPositionCompensation;
    private Region effectiveViewport;
    private EyesScreenshotFactory screenshotFactory;
    private String cachedAUTSessionId;
    private final ConfigurationProvider configurationProvider;
    private ClassicRunner runner;

    @Obsolete
    public boolean shouldStitchContent() {
        return false;
    }

    public SeleniumEyes(ConfigurationProvider configurationProvider, ClassicRunner runner) {
        this.configurationProvider = configurationProvider;
        this.checkFrameOrElement = false;
        this.doNotGetTitle = false;
        this.devicePixelRatio = 0.0;
        this.regionVisibilityStrategyHandler = new SimplePropertyHandler();
        this.regionVisibilityStrategyHandler.set((Object)new MoveToRegionVisibilityStrategy(this.logger));
        this.runner = runner;
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    @Override
    public void apiKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    @Override
    public void serverUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void serverUrl(URI serverUrl) {
        this.setServerUrl(serverUrl);
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public FrameChain getOriginalFC() {
        return this.originalFC;
    }

    public PositionProvider getCurrentFramePositionProvider() {
        return this.currentFramePositionProvider;
    }

    public Region getRegionToCheck() {
        return this.regionToCheck;
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.regionToCheck = regionToCheck;
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategyHandler = shouldScroll ? new ReadOnlyPropertyHandler(this.logger, (Object)new MoveToRegionVisibilityStrategy(this.logger)) : new ReadOnlyPropertyHandler(this.logger, (Object)new NopRegionVisibilityStrategy(this.logger));
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategyHandler.get() instanceof NopRegionVisibilityStrategy);
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    @Override
    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) throws EyesException {
        this.getConfigurationInstance().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.getConfigurationInstance().setViewportSize(new RectangleSize(viewportSize));
        }
        return this.open(driver);
    }

    @Override
    public WebDriver open(WebDriver driver) throws EyesException {
        this.openLogger();
        this.cachedAUTSessionId = null;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return driver;
        }
        this.initDriver(driver);
        this.jsExecutor = new SeleniumJavaScriptExecutor(this.driver);
        String uaString = this.driver.getUserAgent();
        if (uaString != null) {
            if (uaString.startsWith("useragent:")) {
                uaString = uaString.substring(10);
            }
            this.userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        this.initDevicePixelRatio();
        this.screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
        this.imageProvider = ImageProviderFactory.getImageProvider(this.userAgent, this, this.logger, (TakesScreenshot)this.driver);
        this.regionPositionCompensation = RegionPositionCompensationFactory.getRegionPositionCompensation(this.userAgent, this, this.logger);
        if (!this.getConfigurationInstance().isVisualGrid()) {
            this.openBase();
        }
        this.driver.setRotation(this.rotation);
        this.runner.addBatch(this.getConfigurationInstance().getBatch().getId(), this);
        return this.driver;
    }

    private void initDevicePixelRatio() {
        this.logger.verbose("Trying to extract device pixel ratio...");
        try {
            this.devicePixelRatio = this.driver.getDevicePixelRatio();
        }
        catch (Exception ex) {
            this.logger.verbose("Failed to extract device pixel ratio! Using default.");
            this.devicePixelRatio = 1.0;
        }
        this.logger.verbose("Device pixel ratio: " + this.devicePixelRatio);
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesSeleniumDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesSeleniumDriver) {
            this.driver = (EyesSeleniumDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            this.regionVisibilityStrategyHandler.set((Object)new NopRegionVisibilityStrategy(this.logger));
        }
    }

    public WebElement getScrollRootElement() {
        if (this.userDefinedSRE == null) {
            this.userDefinedSRE = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        }
        return this.userDefinedSRE;
    }

    private PositionProvider createPositionProvider() {
        return this.createPositionProvider(this.userDefinedSRE);
    }

    private PositionProvider createPositionProvider(WebElement scrollRootElement) {
        StitchMode stitchMode = this.getConfigurationInstance().getStitchMode();
        this.logger.verbose("initializing position provider. stitchMode: " + stitchMode);
        switch (stitchMode) {
            case CSS: {
                return new CssTranslatePositionProvider(this.logger, this.jsExecutor, scrollRootElement);
            }
        }
        return ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    @Override
    public void check(ICheckSettings ... checkSettings) {
        boolean originalForceFPS;
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(ICheckSettings[%d]): Ignored", checkSettings.length));
            return;
        }
        Boolean forceFullPageScreenshot = this.getConfigurationInstance().getForceFullPageScreenshot();
        boolean bl = originalForceFPS = forceFullPageScreenshot == null ? false : forceFullPageScreenshot;
        if (checkSettings.length > 1) {
            this.getConfigurationInstance().setForceFullPageScreenshot(true);
        }
        this.logger.verbose(this.getConfigurationInstance().toString());
        Hashtable<Integer, GetSimpleRegion> getRegions = new Hashtable<Integer, GetSimpleRegion>();
        Hashtable<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary = new Hashtable<Integer, ICheckSettingsInternal>();
        for (int i = 0; i < checkSettings.length; ++i) {
            ISeleniumCheckTarget seleniumCheckTarget;
            ICheckSettings settings = checkSettings[i];
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)settings;
            ((Dictionary)checkSettingsInternalDictionary).put(i, checkSettingsInternal);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            if (targetRegion != null) {
                ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByRectangle(targetRegion));
                continue;
            }
            ISeleniumCheckTarget iSeleniumCheckTarget = seleniumCheckTarget = settings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)settings : null;
            if (seleniumCheckTarget == null) continue;
            seleniumCheckTarget.init(this.logger, this.driver);
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement == null && seleniumCheckTarget.getFrameChain().size() == 1) {
                targetElement = EyesSeleniumUtils.findFrameByFrameCheckTarget(seleniumCheckTarget.getFrameChain().get(0), this.driver);
            }
            if (targetElement == null) continue;
            ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByElement(targetElement));
        }
        this.userDefinedSRE = EyesSeleniumUtils.getScrollRootElement(this.logger, this.driver, (IScrollRootElementContainer)checkSettings[0]);
        this.currentFramePositionProvider = null;
        this.setPositionProvider(this.createPositionProvider());
        this.matchRegions(getRegions, checkSettingsInternalDictionary, checkSettings);
        this.getConfigurationInstance().setForceFullPageScreenshot(originalForceFPS);
    }

    private void matchRegions(Dictionary<Integer, GetSimpleRegion> getRegions, Dictionary<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary, ICheckSettings[] checkSettings) {
        boolean hasFrames;
        if (getRegions.size() == 0) {
            return;
        }
        this.originalFC = this.driver.getFrameChain().clone();
        Region bBox = this.findBoundingBox(getRegions, checkSettings);
        MatchWindowTask mwt = new MatchWindowTask(this.logger, this.getServerConnector(), this.runningSession, this.getConfigurationInstance().getMatchTimeout(), (EyesBase)this);
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory, new RenderingInfo());
        Object activeElement = null;
        if (this.getConfigurationInstance().getHideCaret()) {
            try {
                activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Cannot hide caret! " + e.getMessage());
            }
        }
        Region region = Region.EMPTY;
        boolean bl = hasFrames = this.driver.getFrameChain().size() > 0;
        if (hasFrames) {
            region = new Region(bBox.getLocation(), ((EyesRemoteWebElement)this.userDefinedSRE).getClientSize());
        } else {
            WebElement defaultRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            if (!this.userDefinedSRE.equals(defaultRootElement)) {
                EyesRemoteWebElement eyesScrollRootElement = this.userDefinedSRE instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)this.userDefinedSRE : new EyesRemoteWebElement(this.logger, this.driver, this.userDefinedSRE);
                Point location = eyesScrollRootElement.getLocation();
                SizeAndBorders sizeAndBorders = eyesScrollRootElement.getSizeAndBorders();
                region = new Region(location.getX() + sizeAndBorders.getBorders().getLeft(), location.getY() + sizeAndBorders.getBorders().getTop(), sizeAndBorders.getSize().getWidth(), sizeAndBorders.getSize().getHeight());
            }
        }
        region.intersect(this.effectiveViewport);
        this.markElementForLayoutRCA(null);
        BufferedImage screenshotImage = algo.getStitchedRegion(region, bBox, (PositionProvider)this.positionProviderHandler.get(), (PositionProvider)this.positionProviderHandler.get(), RectangleSize.EMPTY);
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage, EyesWebDriverScreenshot.ScreenshotType.VIEWPORT, Location.ZERO);
        for (int i = 0; i < checkSettings.length; ++i) {
            if (!((Hashtable)getRegions).containsKey(i)) continue;
            GetSimpleRegion simpleRegion = getRegions.get(i);
            ICheckSettingsInternal checkSettingsInternal = checkSettingsInternalDictionary.get(i);
            List<EyesScreenshot> subScreenshots = this.getSubScreenshots(hasFrames ? Region.EMPTY : bBox, screenshot, simpleRegion);
            this.matchRegion(checkSettingsInternal, mwt, subScreenshots);
        }
        if (this.getConfigurationInstance().getHideCaret() && activeElement != null) {
            try {
                this.driver.executeScript("arguments[0].focus();", activeElement);
            }
            catch (WebDriverException e) {
                this.logger.verbose("WARNING: Could not return focus to active element! " + e.getMessage());
            }
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(this.originalFC);
    }

    private List<EyesScreenshot> getSubScreenshots(Region bBox, EyesWebDriverScreenshot screenshot, GetSimpleRegion getSimpleRegion) {
        ArrayList<EyesScreenshot> subScreenshots = new ArrayList<EyesScreenshot>();
        for (Region r : getSimpleRegion.getRegions((EyesScreenshot)screenshot)) {
            this.logger.verbose("original sub-region: " + r);
            r = r.offset(-bBox.getLeft(), -bBox.getTop());
            EyesWebDriverScreenshot subScreenshot = screenshot.getSubScreenshotForRegion(r, false);
            subScreenshots.add(subScreenshot);
        }
        return subScreenshots;
    }

    private void matchRegion(ICheckSettingsInternal checkSettingsInternal, MatchWindowTask mwt, List<EyesScreenshot> subScreenshots) {
        String name = checkSettingsInternal.getName();
        String source = EyesDriverUtils.isMobileDevice((WebDriver)this.driver) ? null : this.driver.getCurrentUrl();
        for (EyesScreenshot subScreenshot : subScreenshots) {
            this.debugScreenshotsProvider.save(subScreenshot.getImage(), String.format("subscreenshot_%s", name));
            ImageMatchSettings ims = MatchWindowTask.createImageMatchSettings((ICheckSettingsInternal)checkSettingsInternal, (EyesScreenshot)subScreenshot, (EyesBase)this);
            Location location = subScreenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.SCREENSHOT_AS_IS);
            AppOutput appOutput = new AppOutput(name, ImageUtils.encodeAsPng((BufferedImage)subScreenshot.getImage()), null, null);
            AppOutputWithScreenshot appOutputWithScreenshot = new AppOutputWithScreenshot(appOutput, subScreenshot, location);
            MatchResult matchResult = mwt.performMatch(new ArrayList(), appOutputWithScreenshot, name, false, ims, (EyesBase)this, null, source);
            this.logger.verbose("matchResult.asExcepted: " + matchResult.getAsExpected());
        }
    }

    private Region findBoundingBox(Dictionary<Integer, GetSimpleRegion> getRegions, ICheckSettings[] checkSettings) {
        RectangleSize rectSize = this.getViewportSize();
        this.logger.verbose("rectSize: " + rectSize);
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, new BufferedImage(rectSize.getWidth(), rectSize.getHeight(), 1));
        return this.findBoundingBox(getRegions, checkSettings, screenshot);
    }

    private Region findBoundingBox(Dictionary<Integer, GetSimpleRegion> getRegions, ICheckSettings[] checkSettings, EyesScreenshot screenshot) {
        Region bBox = null;
        for (int i = 0; i < checkSettings.length; ++i) {
            GetSimpleRegion simpleRegion = getRegions.get(i);
            if (simpleRegion == null) continue;
            List regions = simpleRegion.getRegions(screenshot);
            for (Region region : regions) {
                if (bBox == null) {
                    bBox = new Region((IRegion)region);
                    continue;
                }
                bBox = bBox.expandToContain(region);
            }
        }
        Location offset = screenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.CONTEXT_AS_IS);
        return bBox.offset(offset);
    }

    private WebElement getTargetElement(ISeleniumCheckTarget seleniumCheckTarget) {
        assert (seleniumCheckTarget != null);
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        } else if (targetElement != null && !(targetElement instanceof EyesRemoteWebElement)) {
            targetElement = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)targetElement);
        }
        return targetElement;
    }

    @Override
    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check('%s', %s): Ignored", name, checkSettings));
            return;
        }
        ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    public void setIsDisabled(boolean disabled) {
        super.setIsDisabled(disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryCaptureDom() {
        String fullWindowDom = "";
        FrameChain fc = this.driver.getFrameChain().clone();
        try {
            Frame frame = fc.peek();
            WebElement scrollRootElement = null;
            if (frame != null) {
                scrollRootElement = frame.getScrollRootElement();
            }
            if (scrollRootElement == null) {
                scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            }
            SeleniumScrollPositionProvider positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
            DomCapture domCapture = new DomCapture(this);
            fullWindowDom = domCapture.getPageDom((PositionProvider)positionProvider);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        finally {
            ((EyesTargetLocator)this.driver.switchTo()).frames(fc);
        }
        return fullWindowDom;
    }

    protected void setEffectiveViewportSize(RectangleSize size) {
        this.effectiveViewport = new Region(Location.ZERO, size);
        this.logger.verbose("setting effective viewport size to " + size);
    }

    @Override
    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("check(%s): Ignored", checkSettings));
            return;
        }
        try {
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
            ArgumentGuard.notOfType((Object)checkSettings, ISeleniumCheckTarget.class, (String)"checkSettings");
            boolean isMobileDevice = EyesDriverUtils.isMobileDevice((WebDriver)this.driver);
            String source = null;
            if (!isMobileDevice) {
                source = this.driver.getCurrentUrl();
                this.logger.verbose("URL: " + source);
            }
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
            ISeleniumCheckTarget seleniumCheckTarget = (ISeleniumCheckTarget)checkSettings;
            CheckState state = new CheckState();
            seleniumCheckTarget.setState(state);
            Boolean forceFullPageScreenshot = this.getConfigurationInstance().getForceFullPageScreenshot();
            Boolean fully = checkSettingsInternal.getStitchContent();
            state.setStitchContent(fully != null && fully != false || forceFullPageScreenshot != null && forceFullPageScreenshot != false);
            ((SeleniumCheckSettings)checkSettings).sanitizeSettings(this.logger, this.driver, state.isStitchContent());
            seleniumCheckTarget.init(this.logger, this.driver);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            this.logger.verbose("setting userDefinedSRE ...");
            WebElement scrollRootElement = this.userDefinedSRE = SeleniumEyes.tryGetUserDefinedSREFromSREContainer(seleniumCheckTarget, this.driver);
            if (scrollRootElement == null && !isMobileDevice) {
                scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            }
            this.logger.verbose("userDefinedSRE set to " + (this.userDefinedSRE != null ? this.userDefinedSRE.toString() : "null"));
            this.logger.verbose("scrollRootElement set to " + scrollRootElement);
            this.currentFramePositionProvider = null;
            this.positionProviderHandler.set((Object)PositionProviderFactory.getPositionProvider(this.logger, this.getConfigurationInstance().getStitchMode(), this.jsExecutor, scrollRootElement, this.userAgent));
            CaretVisibilityProvider caretVisibilityProvider = new CaretVisibilityProvider(this.logger, this.driver, this.getConfigurationInstance());
            PageState pageState = new PageState(this.logger, this.driver, this.getConfigurationInstance().getStitchMode(), this.userAgent);
            pageState.preparePage(seleniumCheckTarget, this.getConfigurationInstance(), scrollRootElement);
            FrameChain frameChainAfterSwitchToTarget = this.driver.getFrameChain().clone();
            RectangleSize viewportSize = this.effectiveViewport.getSize();
            Region effectiveViewport = this.computeEffectiveViewport(frameChainAfterSwitchToTarget, viewportSize);
            state.setEffectiveViewport(effectiveViewport);
            WebElement targetElement = this.getTargetElementFromSettings(seleniumCheckTarget);
            caretVisibilityProvider.hideCaret();
            if (targetElement != null) {
                if (isMobileDevice) {
                    this.checkNativeElement(checkSettingsInternal, targetElement);
                } else if (state.isStitchContent()) {
                    this.checkFullElement(checkSettingsInternal, targetElement, targetRegion, state, source);
                } else {
                    this.checkElement(checkSettingsInternal, targetElement, targetRegion, state, source);
                }
            } else if (targetRegion != null) {
                boolean originalFully = state.isStitchContent();
                state.setStitchContent(true);
                this.checkFullRegion(checkSettingsInternal, targetRegion, state, source);
                state.setStitchContent(originalFully);
            } else if (!isMobileDevice && seleniumCheckTarget.getFrameChain().size() > 0) {
                if (state.isStitchContent()) {
                    this.checkFullFrame(checkSettingsInternal, state, source);
                } else {
                    this.logger.log("Target.Frame(frame).Fully(false)");
                    this.logger.log("WARNING: This shouldn't have been called, as it is covered by `CheckElement_(...)`");
                }
            } else if (state.isStitchContent()) {
                this.checkFullWindow(checkSettingsInternal, state, scrollRootElement, source);
            } else {
                this.checkWindow(checkSettingsInternal, source);
            }
            caretVisibilityProvider.restoreCaret();
            pageState.restorePageState();
        }
        catch (Exception ex) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)ex);
            throw ex;
        }
    }

    private void checkFullFrame(ICheckSettingsInternal checkSettingsInternal, CheckState state, String source) {
        this.logger.verbose("Target.Frame(frame).Fully(true)");
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Location visualOffset = this.getFrameChainOffset(currentFrameChain);
        Frame currentFrame = currentFrameChain.peek();
        state.setEffectiveViewport(state.getEffectiveViewport().getIntersected(new Region(visualOffset, currentFrame.getInnerSize())));
        WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
        RectangleSize currentSREScrollSize = EyesRemoteWebElement.getScrollSize(currentFrameSRE, (JavascriptExecutor)this.driver, this.logger);
        state.setFullRegion(new Region(state.getEffectiveViewport().getLocation(), currentSREScrollSize));
        this.checkWindowBase(null, checkSettingsInternal, source);
    }

    private void checkFullRegion(ICheckSettingsInternal checkSettingsInternal, Region targetRegion, CheckState state, String source) {
        if (((ISeleniumCheckTarget)checkSettingsInternal).getFrameChain().size() > 0) {
            this.logger.verbose("Target.Frame(frame).Region(x,y,w,h).Fully(true)");
        } else {
            this.logger.verbose("Target.Region(x,y,w,h).Fully(true)");
        }
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Frame currentFrame = currentFrameChain.peek();
        if (currentFrame != null) {
            Region currentFrameBoundsWithoutBorders = SeleniumEyes.removeBorders(currentFrame.getBounds(), currentFrame.getBorderWidths());
            state.setEffectiveViewport(state.getEffectiveViewport().getIntersected(currentFrameBoundsWithoutBorders));
            WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
            RectangleSize currentSREScrollSize = EyesRemoteWebElement.getScrollSize(currentFrameSRE, (JavascriptExecutor)this.driver, this.logger);
            state.setFullRegion(new Region(state.getEffectiveViewport().getLocation(), currentSREScrollSize));
        } else {
            Location visualOffset = this.getFrameChainOffset(currentFrameChain);
            targetRegion = targetRegion.offset(visualOffset);
        }
        this.checkWindowBase(targetRegion, checkSettingsInternal, source);
    }

    private static Region removeBorders(Region region, Borders borders) {
        return new Region(region.getLeft() + borders.getLeft(), region.getTop() + borders.getTop(), region.getWidth() - borders.getHorizontal(), region.getHeight() - borders.getVertical(), region.getCoordinatesType());
    }

    private void checkElement(ICheckSettingsInternal checkSettingsInternal, WebElement targetElement, Region targetRegion, CheckState state, String source) {
        List<FrameLocator> frameLocators = ((ISeleniumCheckTarget)checkSettingsInternal).getFrameChain();
        if (frameLocators.size() > 0) {
            this.logger.verbose("Target.Frame(frame).Region(element).Fully(false)");
        } else {
            this.logger.verbose("Target.Region(element).Fully(false)");
        }
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Region bounds = EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
        Location visualOffset = this.getFrameChainOffset(currentFrameChain);
        bounds = bounds.offset(visualOffset);
        WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
        PositionProvider currentFramePositionProvider = this.getPositionProviderForScrollRootElement(currentFrameSRE);
        Location currentFramePosition = currentFramePositionProvider.getCurrentPosition();
        currentFramePositionProvider.setPosition(bounds.offset(currentFramePosition).getLocation());
        Region actualElementBounds = EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
        actualElementBounds = actualElementBounds.offset(visualOffset);
        Location actualFramePosition = new Location(bounds.getLeft() - actualElementBounds.getLeft(), bounds.getTop() - actualElementBounds.getTop());
        bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fcClone = currentFrameChain.clone();
        while (!state.getEffectiveViewport().isIntersected(bounds) && fcClone.size() > 0) {
            fcClone.pop();
            switchTo.parentFrame();
            currentFrameSRE = this.getCurrentFrameScrollRootElement();
            currentFramePositionProvider = this.getPositionProviderForScrollRootElement(currentFrameSRE);
            currentFramePosition = currentFramePositionProvider.getCurrentPosition();
            bounds = bounds.offset(currentFramePosition);
            actualFramePosition = currentFramePositionProvider.setPosition(bounds.getLocation());
            bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
        }
        switchTo.frames(currentFrameChain);
        Region crop = SeleniumEyes.computeCropRectangle(bounds, targetRegion);
        if (crop == null) {
            crop = bounds;
        }
        this.checkWindowBase(crop, checkSettingsInternal, source);
    }

    private void checkFullElement(ICheckSettingsInternal checkSettingsInternal, WebElement targetElement, Region targetRegion, CheckState state, String source) {
        boolean isScrollableElement;
        if (((ISeleniumCheckTarget)checkSettingsInternal).getFrameChain().size() > 0) {
            this.logger.verbose("Target.Frame(frame)...Region(element).Fully(true)");
        } else {
            this.logger.verbose("Target.Region(element).Fully(true)");
        }
        String originalOverflow = EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)"hidden", (WebElement)targetElement);
        RectangleSize scrollSize = EyesRemoteWebElement.getScrollSize(targetElement, (JavascriptExecutor)this.driver, this.logger);
        Region elementBounds = EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
        Region elementInnerBounds = EyesRemoteWebElement.getClientBoundsWithoutBorders(targetElement, this.driver, this.logger);
        boolean bl = isScrollableElement = scrollSize.getHeight() > elementInnerBounds.getHeight() || scrollSize.getWidth() > elementInnerBounds.getWidth();
        if (isScrollableElement) {
            elementBounds = elementInnerBounds;
        }
        this.initPositionProvidersForCheckElement(isScrollableElement, targetElement, state);
        Location originalElementLocation = elementBounds.getLocation();
        String positionStyle = ((EyesRemoteWebElement)targetElement).getComputedStyle("position");
        if (!positionStyle.equalsIgnoreCase("fixed")) {
            if (this.getConfiguration().getStitchMode().equals((Object)StitchMode.CSS)) {
                this.bringRegionToViewCss(elementBounds, state.getEffectiveViewport().getLocation());
                elementBounds = isScrollableElement ? EyesRemoteWebElement.getClientBoundsWithoutBorders(targetElement, this.driver, this.logger) : EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
                state.setEffectiveViewport(this.computeEffectiveViewport(this.driver.getFrameChain().clone(), this.effectiveViewport.getSize()));
            } else {
                elementBounds = this.bringRegionToView(elementBounds, state.getEffectiveViewport().getLocation());
            }
        }
        Region fullElementBounds = new Region((IRegion)elementBounds);
        fullElementBounds.setWidth(Math.max(fullElementBounds.getWidth(), scrollSize.getWidth()));
        fullElementBounds.setHeight(Math.max(fullElementBounds.getHeight(), scrollSize.getHeight()));
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Location screenshotOffset = this.getFrameChainOffset(currentFrameChain);
        this.logger.verbose("screenshotOffset: " + screenshotOffset);
        fullElementBounds = fullElementBounds.offset(screenshotOffset);
        state.setFullRegion(fullElementBounds);
        if (this.getConfigurationInstance().getStitchMode() == StitchMode.CSS && this.userDefinedSRE != null) {
            Region viewportInScreenshot = state.getEffectiveViewport();
            int elementTranslationWidth = originalElementLocation.getX() - elementBounds.getLeft();
            int elementTranslationHeight = originalElementLocation.getY() - elementBounds.getTop();
            state.setEffectiveViewport(new Region(viewportInScreenshot.getLeft(), viewportInScreenshot.getTop(), viewportInScreenshot.getWidth() - elementTranslationWidth, viewportInScreenshot.getHeight() - elementTranslationHeight));
        }
        if (this.getConfigurationInstance().getStitchMode() == StitchMode.SCROLL && !isScrollableElement) {
            EyesRemoteWebElement sre = (EyesRemoteWebElement)this.getCurrentFrameScrollRootElement();
            state.setStitchOffset(new RectangleSize(sre.getScrollLeft(), sre.getScrollTop()));
        }
        Region elementBoundsInScreenshotCoordinates = elementBounds.offset(screenshotOffset);
        Region intersectedViewport = state.getEffectiveViewport().getIntersected(elementBoundsInScreenshotCoordinates);
        state.setEffectiveViewport(intersectedViewport);
        Region crop = SeleniumEyes.computeCropRectangle(fullElementBounds, targetRegion);
        this.checkWindowBase(crop, checkSettingsInternal, source);
        EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)originalOverflow, (WebElement)targetElement);
    }

    private void checkNativeElement(ICheckSettingsInternal checkSettingsInternal, WebElement targetElement) {
        Rectangle rect = targetElement.getRect();
        Region region = checkSettingsInternal.getTargetRegion();
        if (region == null) {
            region = new Region(rect.x, rect.y, rect.width, rect.height);
        }
        this.checkWindowBase(region, checkSettingsInternal, null);
    }

    private void checkWindow(ICheckSettingsInternal checkSettingsInternal, String source) {
        this.logger.verbose("Target.Window()");
        this.checkWindowBase(null, checkSettingsInternal, source);
    }

    private void checkFullWindow(ICheckSettingsInternal checkSettingsInternal, CheckState state, WebElement scrollRootElement, String source) {
        this.logger.verbose("Target.Window().Fully(true)");
        this.initPositionProvidersForCheckWindow(state, scrollRootElement);
        this.checkWindowBase(null, checkSettingsInternal, source);
    }

    private void initPositionProvidersForCheckWindow(CheckState state, WebElement scrollRootElement) {
        if (this.getConfigurationInstance().getStitchMode() == StitchMode.SCROLL) {
            state.setStitchPositionProvider((PositionProvider)new SeleniumScrollPositionProvider(this.logger, this.driver, scrollRootElement));
        } else if (this.userDefinedSRE != null) {
            state.setStitchPositionProvider(new ElementPositionProvider(this.logger, this.driver, this.userDefinedSRE));
        } else {
            state.setStitchPositionProvider(new CssTranslatePositionProvider(this.logger, this.driver, scrollRootElement));
            state.setOriginPositionProvider((PositionProvider)new SeleniumScrollPositionProvider(this.logger, this.driver, scrollRootElement));
        }
    }

    private static Region computeCropRectangle(Region fullRect, Region cropRect) {
        if (cropRect == null) {
            return null;
        }
        Region crop = new Region((IRegion)fullRect);
        Location cropLocation = crop.getLocation();
        Region cropRectClone = cropRect.offset(cropLocation);
        crop.intersect(cropRectClone);
        return crop;
    }

    private Location getFrameChainOffset(FrameChain frameChain) {
        Location offset = Location.ZERO;
        for (Frame frame : frameChain) {
            offset = offset.offset(frame.getLocation());
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region bringRegionToViewCss(Region bounds, Location viewportLocation) {
        FrameChain frames = this.driver.getFrameChain().clone();
        if (frames.size() <= 0) {
            return this.bringRegionToView(bounds, viewportLocation);
        }
        Location currentFrameOffset = frames.getCurrentFrameOffset();
        EyesTargetLocator locator = (EyesTargetLocator)this.driver.switchTo();
        locator.defaultContent();
        try {
            EyesRemoteWebElement currentFrameSRE = (EyesRemoteWebElement)this.getCurrentFrameScrollRootElement();
            PositionProvider currentFramePositionProvider = PositionProviderFactory.getPositionProvider(this.logger, StitchMode.CSS, this.jsExecutor, (WebElement)currentFrameSRE, this.userAgent);
            Location currentFramePosition = currentFramePositionProvider.getCurrentPosition();
            Location boundsPosition = bounds.getLocation();
            Location newFramePosition = boundsPosition.offset(-viewportLocation.getX(), -viewportLocation.getY());
            newFramePosition = newFramePosition.offset(currentFrameOffset);
            Location currentCssLocation = currentFrameSRE.getCurrentCssStitchingLocation();
            if (currentCssLocation != null) {
                newFramePosition = newFramePosition.offset(currentCssLocation);
            }
            Location actualFramePosition = currentFramePositionProvider.setPosition(newFramePosition);
            bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
            Region region = bounds = bounds.offset(currentFramePosition);
            return region;
        }
        finally {
            locator.frames(frames);
        }
    }

    private Region bringRegionToView(Region bounds, Location viewportLocation) {
        WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
        StitchMode stitchMode = this.getConfigurationInstance().getStitchMode();
        PositionProvider currentFramePositionProvider = PositionProviderFactory.getPositionProvider(this.logger, stitchMode, this.jsExecutor, currentFrameSRE, this.userAgent);
        Location currentFramePosition = currentFramePositionProvider.getCurrentPosition();
        Location boundsPosition = bounds.getLocation();
        Location newFramePosition = boundsPosition.offset(-viewportLocation.getX(), -viewportLocation.getY());
        if (stitchMode.equals((Object)StitchMode.SCROLL)) {
            newFramePosition = newFramePosition.offset(currentFramePosition);
        }
        Location actualFramePosition = currentFramePositionProvider.setPosition(newFramePosition);
        bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
        bounds = bounds.offset(currentFramePosition);
        return bounds;
    }

    private void initPositionProvidersForCheckElement(boolean isScrollableElement, WebElement targetElement, CheckState state) {
        if (isScrollableElement) {
            state.setStitchPositionProvider(new ElementPositionProvider(this.logger, this.driver, targetElement));
        } else {
            WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
            if (this.getConfigurationInstance().getStitchMode() == StitchMode.CSS) {
                state.setStitchPositionProvider(new CssTranslatePositionProvider(this.logger, this.driver, targetElement));
                state.setOriginPositionProvider(new NullPositionProvider());
            } else {
                state.setStitchPositionProvider((PositionProvider)new SeleniumScrollPositionProvider(this.logger, this.driver, scrollRootElement));
            }
        }
        this.logger.verbose("isScrollableElement ?" + isScrollableElement);
    }

    public static WebElement tryGetUserDefinedSREFromSREContainer(IScrollRootElementContainer scrollRootElementContainer, EyesSeleniumDriver driver) {
        By scrollRootSelector;
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement == null && (scrollRootSelector = scrollRootElementContainer.getScrollRootSelector()) != null) {
            scrollRootElement = driver.findElement(scrollRootSelector);
        }
        return scrollRootElement;
    }

    public static WebElement getScrollRootElementFromSREContainer(Logger logger, IScrollRootElementContainer scrollRootElementContainer, EyesSeleniumDriver driver) {
        WebElement scrollRootElement = SeleniumEyes.tryGetUserDefinedSREFromSREContainer(scrollRootElementContainer, driver);
        if (scrollRootElement == null) {
            scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        return scrollRootElement;
    }

    private PositionProvider getPositionProviderForScrollRootElement(WebElement scrollRootElement) {
        return SeleniumEyes.getPositionProviderForScrollRootElement(this.logger, this.driver, this.getConfigurationInstance().getStitchMode(), this.userAgent, scrollRootElement);
    }

    public static PositionProvider getPositionProviderForScrollRootElement(Logger logger, EyesSeleniumDriver driver, StitchMode stitchMode, UserAgent ua, WebElement scrollRootElement) {
        Object positionProvider = PositionProviderFactory.tryGetPositionProviderForElement(scrollRootElement);
        if (positionProvider == null) {
            logger.verbose("creating a new position provider.");
            WebElement defaultSRE = EyesSeleniumUtils.getDefaultRootElement(logger, driver);
            positionProvider = scrollRootElement.equals(defaultSRE) ? PositionProviderFactory.getPositionProvider(logger, stitchMode, driver, scrollRootElement, ua) : new ElementPositionProvider(logger, driver, scrollRootElement);
        }
        logger.verbose("position provider: " + positionProvider);
        return positionProvider;
    }

    private Region computeEffectiveViewport(FrameChain frameChain, RectangleSize initialSize) {
        Region viewport = new Region(Location.ZERO, initialSize);
        if (this.userDefinedSRE != null) {
            Region sreInnerBounds = EyesRemoteWebElement.getClientBoundsWithoutBorders(this.userDefinedSRE, this.driver, this.logger);
            viewport.intersect(sreInnerBounds);
        }
        Location offset = Location.ZERO;
        for (Frame frame : frameChain) {
            offset = offset.offset(frame.getLocation());
            Region frameViewport = new Region(offset, frame.getInnerSize());
            viewport.intersect(frameViewport);
            Region frameSreInnerBounds = frame.getScrollRootElementInnerBounds();
            if (frameSreInnerBounds.isSizeEmpty()) continue;
            frameSreInnerBounds = frameSreInnerBounds.offset(offset);
            viewport.intersect(frameSreInnerBounds);
        }
        return viewport;
    }

    private WebElement getTargetElementFromSettings(ISeleniumCheckTarget seleniumCheckTarget) {
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        } else if (targetElement != null && !(targetElement instanceof EyesRemoteWebElement)) {
            targetElement = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)targetElement);
        }
        return targetElement;
    }

    public void closeBatch(String batchId) {
        this.getServerConnector().closeBatch(batchId);
    }

    protected ScaleProviderFactory updateScalingParams() {
        if (this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            ScaleProviderFactory factory;
            this.logger.verbose("Trying to extract device pixel ratio...");
            try {
                this.devicePixelRatio = this.driver.getDevicePixelRatio();
            }
            catch (Exception e) {
                this.logger.verbose("Failed to extract device pixel ratio! Using default.");
                this.devicePixelRatio = 1.0;
            }
            this.logger.verbose(String.format("Device pixel ratio: %f", this.devicePixelRatio));
            if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
                this.logger.verbose("Setting web scale provider...");
                factory = this.getScaleProviderFactory();
            } else {
                this.logger.verbose("Setting native app scale provider...");
                factory = new FixedScaleProviderFactory(this.logger, 1.0 / this.devicePixelRatio, this.scaleProviderHandler);
            }
            this.logger.verbose("Done!");
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory(this.logger, (ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    private ScaleProviderFactory getScaleProviderFactory() {
        WebElement element = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        RectangleSize entireSize = EyesDriverUtils.getEntireElementSize((Logger)this.logger, (IEyesJsExecutor)this.jsExecutor, (WebElement)element);
        return new ContextBasedScaleProviderFactory(this.logger, entireSize, this.getConfigurationInstance().getViewportSize(), this.devicePixelRatio, false, (PropertyHandler<ScaleProvider>)this.scaleProviderHandler);
    }

    public WebElement getCurrentFrameScrollRootElement() {
        return EyesSeleniumUtils.getCurrentFrameScrollRootElement(this.logger, this.driver, this.userDefinedSRE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentFrame(int matchTimeout, String tag, String source) {
        try {
            this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
            this.checkFrameOrElement = true;
            this.logger.verbose("Getting screenshot as base64..");
            String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating image object...");
            BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
            ScaleProvider scaleProvider = this.updateScalingParams().getScaleProvider(screenshotImage.getWidth());
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (double)scaleProvider.getScaleRatio());
            this.logger.verbose("Done! Building required object...");
            EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("Done!");
            this.logger.verbose("replacing regionToCheck");
            this.setRegionToCheck(screenshot.getFrameWindow());
            super.checkWindowBase(null, tag, matchTimeout, source);
        }
        finally {
            this.checkFrameOrElement = false;
            this.regionToCheck = null;
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.check((String)null, (ICheckSettings)Target.frame(frameNameOrId));
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully());
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).timeout(matchTimeout).fully());
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout).fully());
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.check((String)null, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    public void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    public RectangleSize getViewportSize() {
        RectangleSize vpSize;
        if (!this.isOpen && this.driver == null) {
            this.logger.log("Called getViewportSize before calling open");
            return null;
        }
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            if (this.imageProvider instanceof MobileScreenshotImageProvider) {
                BufferedImage image = this.imageProvider.getImage();
                vpSize = new RectangleSize((int)Math.round((double)image.getWidth() / this.devicePixelRatio), (int)Math.round((double)image.getHeight() / this.devicePixelRatio));
            } else {
                vpSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)this.driver);
            }
        } else {
            vpSize = SeleniumEyes.getViewportSize((WebDriver)this.driver);
        }
        return vpSize;
    }

    static RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesDriverUtils.getViewportSizeOrDisplaySize((Logger)new Logger(), (WebDriver)driver);
    }

    protected Configuration setViewportSize(RectangleSize size) {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            FrameChain originalFrame = this.driver.getFrameChain();
            this.driver.switchTo().defaultContent();
            try {
                EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)this.driver, (RectangleSize)size);
                this.effectiveViewport = new Region(Location.ZERO, size);
            }
            catch (EyesException e1) {
                ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e1);
                throw new TestFailedException("Failed to set the viewport size", (Throwable)e1);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        }
        this.getConfigurationInstance().setViewportSize(new RectangleSize(size.getWidth(), size.getHeight()));
        return this.getConfigurationInstance();
    }

    protected EyesScreenshot getScreenshot(Region targetRegion, ICheckSettingsInternal checkSettingsInternal) {
        EyesWebDriverScreenshot result;
        Region fullRegion;
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        CheckState state = ((ISeleniumCheckTarget)checkSettingsInternal).getState();
        WebElement targetElement = state.getTargetElementInternal();
        boolean stitchContent = state.isStitchContent();
        Region effectiveViewport = state.getEffectiveViewport();
        if (effectiveViewport.contains(fullRegion = state.getFullRegion()) && !fullRegion.isEmpty()) {
            this.logger.verbose("effectiveViewport: " + effectiveViewport + " ; fullRegion: " + fullRegion);
            result = this.getViewportScreenshot(scaleProviderFactory);
            result = result.getSubScreenshot(fullRegion, true);
        } else {
            result = targetElement != null || stitchContent ? this.getFrameOrElementScreenshot(scaleProviderFactory, state) : this.getViewportScreenshot(scaleProviderFactory);
        }
        if (targetRegion != null) {
            result = result.getSubScreenshot(targetRegion, false);
            this.debugScreenshotsProvider.save(result.getImage(), "SUB_SCREENSHOT");
        }
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            result.setDomUrl(this.tryCaptureAndPostDom(checkSettingsInternal));
        }
        return result;
    }

    private EyesWebDriverScreenshot getViewportScreenshot(ScaleProviderFactory scaleProviderFactory) {
        try {
            Thread.sleep(this.getWaitBeforeScreenshots());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        EyesWebDriverScreenshot result = this.getScaledAndCroppedScreenshot(scaleProviderFactory);
        return result;
    }

    boolean shouldTakeFullPageScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        Boolean isFully = checkSettingsInternal.getStitchContent();
        if (isFully != null) {
            return isFully;
        }
        Boolean isForceFullPage = this.getConfigurationInstance().getForceFullPageScreenshot();
        if (isForceFullPage == null) {
            return false;
        }
        return isForceFullPage;
    }

    private EyesWebDriverScreenshot getFrameOrElementScreenshot(ScaleProviderFactory scaleProviderFactory, CheckState state) {
        RenderingInfo renderingInfo = this.serverConnector.getRenderInfo();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory, renderingInfo);
        this.logger.verbose("Check frame/element requested");
        PositionProvider positionProvider = state.getStitchPositionProvider();
        PositionProvider originPositionProvider = state.getOriginPositionProvider();
        if (positionProvider == null) {
            this.logger.verbose("positionProvider is null, updating it.");
            WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
            positionProvider = SeleniumEyes.getPositionProviderForScrollRootElement(this.logger, this.driver, this.getConfigurationInstance().getStitchMode(), this.userAgent, scrollRootElement);
        }
        if (originPositionProvider == null) {
            originPositionProvider = new NullPositionProvider();
        }
        this.markElementForLayoutRCA(positionProvider);
        BufferedImage entireFrameOrElement = algo.getStitchedRegion(state.getEffectiveViewport(), state.getFullRegion(), positionProvider, originPositionProvider, state.getStitchOffset());
        this.logger.verbose("Building screenshot object...");
        Location frameLocationInScreenshot = new Location(-state.getFullRegion().getLeft(), -state.getFullRegion().getTop());
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight()), frameLocationInScreenshot);
        return result;
    }

    private EyesWebDriverScreenshot getScaledAndCroppedScreenshot(ScaleProviderFactory scaleProviderFactory) {
        BufferedImage screenshotImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
        CutProvider cutProvider = (CutProvider)this.cutProviderHandler.get();
        if (scaleProvider.getScaleRatio() != 1.0) {
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (double)scaleProvider.getScaleRatio());
            this.debugScreenshotsProvider.save(screenshotImage, "scaled");
            cutProvider.scale(scaleProvider.getScaleRatio());
        }
        if (!(cutProvider instanceof NullCutProvider)) {
            screenshotImage = cutProvider.cut(screenshotImage);
            this.debugScreenshotsProvider.save(screenshotImage, "cut");
        }
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
        return result;
    }

    private long getWaitBeforeScreenshots() {
        return this.getConfigurationInstance().getWaitBeforeScreenshots();
    }

    private void markElementForLayoutRCA(PositionProvider elemPositionProvider) {
        ISeleniumPositionProvider positionProvider = elemPositionProvider != null ? (ISeleniumPositionProvider)elemPositionProvider : (ISeleniumPositionProvider)this.getPositionProvider();
        WebElement scrolledElement = positionProvider.getScrolledElement();
        if (scrolledElement != null) {
            try {
                this.jsExecutor.executeScript("var e = arguments[0]; if (e != null) e.setAttribute('data-applitools-scroll','true');", scrolledElement);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
    }

    private FullPageCaptureAlgorithm createFullPageCaptureAlgorithm(ScaleProviderFactory scaleProviderFactory, RenderingInfo renderingInfo) {
        ISizeAdjuster sizeAdjuster = ImageProviderFactory.getImageSizeAdjuster(this.userAgent, this.jsExecutor);
        return new FullPageCaptureAlgorithm(this.logger, this.regionPositionCompensation, this.getConfigurationInstance().getWaitBeforeScreenshots(), this.debugScreenshotsProvider, this.screenshotFactory, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getConfigurationInstance().getStitchOverlap(), this.imageProvider, renderingInfo.getMaxImageHeight(), renderingInfo.getMaxImageArea(), sizeAdjuster);
    }

    protected String getTitle() {
        if (!this.doNotGetTitle && !EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("failed (" + ex.getMessage() + ")");
                this.doNotGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected Object getAppEnvironment() {
        AppEnvironment appEnv = (AppEnvironment)super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesDriverUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesDriverUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesDriverUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesDriverUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                }
                if (appEnv.getDeviceInfo() == null) {
                    appEnv.setDeviceInfo(EyesDriverUtils.getMobileDeviceName((HasCapabilities)this.driver.getRemoteWebDriver()));
                }
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    public void setIsDisabled(Boolean disabled) {
        super.setIsDisabled(disabled);
    }

    protected String getAUTSessionId() {
        try {
            if (this.cachedAUTSessionId == null) {
                this.cachedAUTSessionId = this.driver.getRemoteWebDriver().getSessionId().toString();
            }
            return this.cachedAUTSessionId;
        }
        catch (Exception e) {
            this.logger.log("WARNING: Failed to get AUT session ID! (maybe driver is not available?). Error: " + e.getMessage());
            return "";
        }
    }

    @Override
    public TestResults close(boolean throwEx) {
        TestResults results;
        block3: {
            results = null;
            try {
                results = super.close(throwEx);
            }
            catch (Throwable e) {
                this.logger.log(e.getMessage());
                if (!throwEx) break block3;
                throw e;
            }
        }
        if (this.runner != null) {
            this.runner.aggregateResult(results);
        }
        this.cachedAUTSessionId = null;
        this.getServerConnector().closeConnector();
        return results;
    }

    public Object getAgentSetup() {
        return new EyesSeleniumAgentSetup();
    }

    public Boolean isSendDom() {
        return !EyesDriverUtils.isMobileDevice((WebDriver)this.driver) && super.isSendDom() != false;
    }

    protected Configuration getConfigurationInstance() {
        return this.configurationProvider.get();
    }

    void setDebugScreenshotProvider(DebugScreenshotsProvider debugScreenshotProvider) {
        this.debugScreenshotsProvider = debugScreenshotProvider;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public ScaleProvider getScaleProvider() {
        return (ScaleProvider)this.scaleProviderHandler.get();
    }

    public CutProvider getCutProvider() {
        return (CutProvider)this.cutProviderHandler.get();
    }

    class EyesSeleniumAgentSetup {
        private RemoteWebDriver remoteWebDriver;

        public EyesSeleniumAgentSetup() {
            this.remoteWebDriver = SeleniumEyes.this.driver.getRemoteWebDriver();
        }

        public String getSeleniumSessionId() {
            return this.remoteWebDriver.getSessionId().toString();
        }

        public WebDriverInfo getWebDriver() {
            return new WebDriverInfo();
        }

        public StitchMode getStitchMode() {
            return SeleniumEyes.this.getConfigurationInstance().getStitchMode();
        }

        public boolean getHideScrollbars() {
            return SeleniumEyes.this.getConfigurationInstance().getHideScrollbars();
        }

        public boolean getForceFullPageScreenshot() {
            Boolean forceFullPageScreenshot = SeleniumEyes.this.getConfigurationInstance().getForceFullPageScreenshot();
            if (forceFullPageScreenshot == null) {
                return false;
            }
            return forceFullPageScreenshot;
        }

        class WebDriverInfo {
            WebDriverInfo() {
            }

            public String getName() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getClass().getName();
            }

            public Capabilities getCapabilities() {
                return EyesSeleniumAgentSetup.this.remoteWebDriver.getCapabilities();
            }
        }
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

