/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.rendering;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.IPutFuture;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.config.IConfigurationSetter;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.selenium.IConfigurationGetter;
import com.applitools.eyes.selenium.ISeleniumConfigurationProvider;
import com.applitools.eyes.visualgrid.model.EmulationDevice;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IResourceFuture;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import java.net.URI;
import java.net.URL;
import java.util.List;

class EyesConnector
extends EyesBase
implements IEyesConnector,
IBatchCloser {
    private final ISeleniumConfigurationProvider configProvider;
    private RenderBrowserInfo browserInfo;
    private String userAgent;
    private String device;
    private RectangleSize deviceSize;
    private IConfigurationGetter configurationGetter;
    private String appName;
    private String testName;

    public EyesConnector(ISeleniumConfigurationProvider configProvider, List<PropertyData> properties, RenderBrowserInfo browserInfo) {
        this.configProvider = configProvider;
        this.configurationGetter = configProvider.get();
        this.browserInfo = browserInfo;
        if (properties != null) {
            for (PropertyData property : properties) {
                this.addProperty(property);
            }
        }
    }

    public void open(IConfigurationGetter config, String appName, String testName) {
        this.configurationGetter = config;
        this.appName = appName;
        this.testName = testName;
        this.logger.verbose("opening EyesConnector with viewport size: " + this.browserInfo.getViewportSize());
        this.openBase();
    }

    public IResourceFuture getResource(URL url, String userAgent) {
        return this.serverConnector.downloadResource(url, userAgent);
    }

    public IPutFuture renderPutResource(RunningRender runningRender, RGridResource resource, String UserAgent2) {
        return this.serverConnector.renderPutResource(runningRender, resource, this.userAgent, null);
    }

    public List<RunningRender> render(RenderRequest ... renderRequests) {
        return this.serverConnector.render(renderRequests);
    }

    public List<RenderStatusResults> renderStatusById(String ... renderIds) {
        return this.serverConnector.renderStatusById(renderIds);
    }

    public IResourceFuture createResourceFuture(RGridResource rg) {
        return this.serverConnector.createResourceFuture(rg, this.userAgent);
    }

    public MatchResult matchWindow(String resultImageURL, String domLocation, ICheckSettings checkSettings, List<? extends IRegion> regions, List<VisualGridSelector[]> regionSelectors, Location location, String renderId, String source) {
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        if (checkSettingsInternal.getStitchContent() == null) {
            checkSettings.fully();
        }
        MatchWindowTask matchWindowTask = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.getConfigGetter().getMatchTimeout(), (EyesBase)this);
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings((ICheckSettingsInternal)checkSettingsInternal, (EyesBase)this);
        String tag = checkSettingsInternal.getName();
        AppOutput appOutput = new AppOutput(tag, null, domLocation, resultImageURL);
        AppOutputWithScreenshot appOutputWithScreenshot = new AppOutputWithScreenshot(appOutput, null, location);
        return matchWindowTask.performMatch(appOutputWithScreenshot, tag, false, checkSettingsInternal, imageMatchSettings, regions, regionSelectors, (EyesBase)this, renderId, source);
    }

    public void open(String appName, String testName, RectangleSize dimensions) {
        this.openBase(appName, testName, dimensions, null);
    }

    protected String getBaseAgentId() {
        return "eyes.selenium.visualgrid.java/3.158.8";
    }

    protected RectangleSize getViewportSize() {
        return null;
    }

    protected IConfigurationSetter setViewportSize(RectangleSize size) {
        this.logger.log("WARNING setViewportSize() was called in Visual-Grid context");
        return this.getConfigSetter();
    }

    protected String getInferredEnvironment() {
        return "useragent:" + this.userAgent;
    }

    protected EyesScreenshot getScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        return null;
    }

    protected String getTitle() {
        return null;
    }

    protected String getAUTSessionId() {
        return null;
    }

    protected <T extends com.applitools.eyes.config.IConfigurationGetter> T getConfigGetter() {
        return (T)this.configurationGetter;
    }

    protected <T extends IConfigurationSetter> T getConfigSetter() {
        return (T)((IConfigurationSetter)this.configurationGetter);
    }

    public void setRenderInfo(RenderingInfo renderInfo) {
        this.renderInfo = renderInfo;
        this.serverConnector.setRenderingInfo(renderInfo);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected void openLogger() {
    }

    protected void closeLogger() {
    }

    public String tryCaptureDom() {
        return null;
    }

    public IConfigurationSetter setApiKey(String apiKey) {
        return super.setApiKey(apiKey);
    }

    public IConfigurationSetter setServerUrl(URI serverUrl) {
        return super.setServerUrl(serverUrl);
    }

    public void setBranchName(String branchName) {
        this.getConfigSetter().setBranchName(branchName);
    }

    public void setParentBranchName(String parentBranchName) {
        this.getConfigSetter().setParentBranchName(parentBranchName);
    }

    public void setDevice(String device) {
        this.device = device;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        appEnv.setDeviceInfo(this.device);
        if (this.userAgent == null) {
            appEnv.setOs(VisualGridTask.toPascalCase((String)this.browserInfo.getPlatform()));
            String browserName = this.browserInfo.getBrowserType();
            browserName = browserName.equals("ie") ? "IE 11" : (browserName.equals("ie10") ? "IE 10" : VisualGridTask.toPascalCase((String)browserName));
            appEnv.setHostingApp(browserName);
        }
        this.logger.log("Done!");
        return appEnv;
    }

    public RectangleSize getDeviceSize() {
        return this.deviceSize;
    }

    public void setDeviceSize(RectangleSize deviceSize) {
        this.deviceSize = deviceSize;
    }

    public RunningSession getSession() {
        return this.runningSession;
    }

    protected RectangleSize getViewportSizeForOpen() {
        if (this.device != null) {
            return this.deviceSize;
        }
        if (this.browserInfo.getViewportSize() != null) {
            return this.browserInfo.getViewportSize();
        }
        if (this.browserInfo.getEmulationInfo() instanceof EmulationDevice) {
            EmulationDevice emulationDevice = (EmulationDevice)this.browserInfo.getEmulationInfo();
            return new RectangleSize(emulationDevice.getWidth(), emulationDevice.getHeight());
        }
        return super.getViewportSizeForOpen();
    }

    protected String getBaselineEnvName() {
        String baselineEnvName = this.browserInfo.getBaselineEnvName();
        if (baselineEnvName != null) {
            return baselineEnvName;
        }
        return this.getConfigGetter().getBaselineEnvName();
    }

    protected String getAppName() {
        return this.appName;
    }

    protected String getTestName() {
        return this.testName;
    }

    public void closeBatch(String batchId) {
        this.serverConnector.closeBatch(batchId);
    }
}

