/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IDriverProvider;
import com.applitools.eyes.IGetAccessibilityRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.IGetAccessibilityRegionType;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AccessibilityRegionBySelector
implements IGetAccessibilityRegion,
IGetSeleniumRegion,
IGetAccessibilityRegionType {
    private final AccessibilityRegionType regionType;
    private final By selector;

    public AccessibilityRegionBySelector(By selector, AccessibilityRegionType regionType) {
        this.selector = selector;
        this.regionType = regionType;
    }

    public List<AccessibilityRegionByRectangle> getRegions(IDriverProvider eyesBase, EyesScreenshot screenshot) {
        List elements = ((SeleniumEyes)eyesBase).getDriver().findElements(this.selector);
        ArrayList<AccessibilityRegionByRectangle> retVal = new ArrayList<AccessibilityRegionByRectangle>();
        for (WebElement element : elements) {
            Point p = element.getLocation();
            Location pTag = screenshot.convertLocation(new Location(p.x, p.y), CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
            retVal.add(new AccessibilityRegionByRectangle(new Region(pTag, new RectangleSize(element.getSize().width, element.getSize().height)), this.regionType));
        }
        return retVal;
    }

    public AccessibilityRegionType getAccessibilityRegionType() {
        return this.regionType;
    }

    @Override
    public List<WebElement> getElements(WebDriver driver) {
        List elements = driver.findElements(this.selector);
        return elements;
    }
}

