/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class InternetExplorerScreenshotImageProvider
implements ImageProvider {
    private final SeleniumEyes eyes;
    private final Logger logger;
    private final TakesScreenshot tsInstance;
    private final IEyesJsExecutor jsExecutor;
    private final UserAgent userAgent;

    public InternetExplorerScreenshotImageProvider(SeleniumEyes eyes, Logger logger, TakesScreenshot tsInstance, UserAgent userAgent) {
        this.eyes = eyes;
        this.logger = logger;
        this.tsInstance = tsInstance;
        this.jsExecutor = new SeleniumJavaScriptExecutor((EyesWebDriver)eyes.getDriver());
        this.userAgent = userAgent;
    }

    public BufferedImage getImage() {
        Location loc;
        this.logger.verbose("Getting current position...");
        double scaleRatio = this.eyes.getDevicePixelRatio();
        FrameChain currentFrameChain = ((EyesWebDriver)this.eyes.getDriver()).getFrameChain();
        ScrollPositionProvider positionProvider = null;
        if (currentFrameChain.size() == 0) {
            positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, this.jsExecutor, this.eyes.getDriver().findElement(By.tagName((String)"html")));
            loc = positionProvider.getCurrentPosition();
        } else {
            loc = currentFrameChain.getDefaultContentScrollPosition();
        }
        Location scaledLoc = loc.scale(scaleRatio);
        this.logger.verbose("Getting screenshot as base64...");
        String screenshot64 = (String)this.tsInstance.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Creating BufferedImage...");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        RectangleSize originalViewportSize = this.eyes.getViewportSize();
        RectangleSize viewportSize = originalViewportSize.scale(scaleRatio);
        if (image.getHeight() > viewportSize.getHeight() || image.getWidth() > viewportSize.getWidth()) {
            this.logger.verbose("seems IE returned full page screenshot rather than only the viewport.");
            this.eyes.getDebugScreenshotsProvider().save(image, "IE");
            if (!this.eyes.getIsCutProviderExplicitlySet()) {
                image = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)image, (Region)new Region(scaledLoc, viewportSize));
            }
        }
        if (positionProvider != null) {
            positionProvider.setPosition(loc);
        }
        return image;
    }
}

