/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Frame;
import com.applitools.eyes.FrameChain;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

class EyesTargetLocator
implements WebDriver.TargetLocator {
    private final EyesWebDriver driver;
    private OnWillSwitch onWillSwitch;
    private WebDriver.TargetLocator targetLocator;

    public EyesTargetLocator(EyesWebDriver driver, WebDriver.TargetLocator targetLocator, OnWillSwitch onWillSwitch) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        ArgumentGuard.notNull((Object)onWillSwitch, (String)"onWillSwitch");
        this.driver = driver;
        this.targetLocator = targetLocator;
        this.onWillSwitch = onWillSwitch;
    }

    public WebDriver frame(int index) {
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        WebElement targetFrame = frames.get(index);
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, targetFrame);
        this.targetLocator.frame(index);
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0 && (frames = this.driver.findElementsById(nameOrId)).size() == 0) {
            throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
        }
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, frames.get(0));
        this.targetLocator.frame(nameOrId);
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, frameElement);
        this.targetLocator.frame(frameElement);
        return this.driver;
    }

    public WebDriver parentFrame() {
        if (this.driver.getFrameChain().size() != 0) {
            this.onWillSwitch.willSwitchToFrame(TargetType.PARENT_FRAME, null);
            this.targetLocator.parentFrame();
        }
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        for (Frame frame : frameChain) {
            this.driver.scrollTo(frame.getParentScrollPosition());
            this.driver.switchTo().frame(frame.getReference());
        }
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        this.onWillSwitch.willSwitchToWindow(nameOrHandle);
        this.targetLocator.window(nameOrHandle);
        return this.driver;
    }

    public WebDriver defaultContent() {
        if (this.driver.getFrameChain().size() != 0) {
            this.onWillSwitch.willSwitchToFrame(TargetType.DEFAULT_CONTENT, null);
            this.targetLocator.defaultContent();
        }
        return this.driver;
    }

    public WebElement activeElement() {
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        return new EyesRemoteWebElement(this.driver, (RemoteWebElement)element);
    }

    public Alert alert() {
        return this.targetLocator.alert();
    }

    protected static interface OnWillSwitch {
        public void willSwitchToFrame(TargetType var1, WebElement var2);

        public void willSwitchToWindow(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TargetType {
        FRAME,
        PARENT_FRAME,
        DEFAULT_CONTENT;

    }
}

