/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.Eyes;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageDeltaCompressor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.openqa.selenium.OutputType;

class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private Eyes eyes;
    private AgentConnector agentConnector;
    private RunningSession runningSession;
    private EyesWebDriver driver;
    private int maxWindowLoadTimeMilliSeconds;
    private MatchResult matchResult;
    private BufferedImage currentScreenshot;

    public MatchWindowTask(Eyes eyes, AgentConnector agentConnector, RunningSession runningSession, EyesWebDriver driver, int maxWindowLoadTime) {
        ArgumentGuard.notNull((Object)((Object)eyes), (String)"eyes");
        ArgumentGuard.notNull((Object)agentConnector, (String)"agentConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.greaterThanOrEqualToZero((int)maxWindowLoadTime, (String)"maxWindowLoadTime");
        this.eyes = eyes;
        this.agentConnector = agentConnector;
        this.runningSession = runningSession;
        this.driver = driver;
        this.maxWindowLoadTimeMilliSeconds = maxWindowLoadTime * 1000;
        this.matchResult = null;
        this.currentScreenshot = null;
    }

    private MatchWindowData createWindowData(Region region, String currentScreenshot64, String title, String tag, boolean shouldForceFullPageScreenshot, boolean ignoreMismatch) throws EyesException {
        byte[] compressedScreenshot;
        byte[] currentScreenshotEncoded = Base64.decodeBase64((byte[])currentScreenshot64.getBytes(Charset.forName("UTF-8")));
        try {
            ByteArrayInputStream screenshotStream = new ByteArrayInputStream(currentScreenshotEncoded);
            this.currentScreenshot = ImageIO.read(screenshotStream);
            screenshotStream.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to parse screenshot!", (Throwable)e);
        }
        if (shouldForceFullPageScreenshot) {
            RectangleSize entirePageSize = this.driver.getEntirePageSize();
            if (this.currentScreenshot.getWidth() < entirePageSize.getWidth() || this.currentScreenshot.getHeight() < entirePageSize.getHeight()) {
                this.currentScreenshot = this.driver.getFullPageScreenshot();
                currentScreenshotEncoded = null;
            }
        }
        if (!region.equals((Object)Region.EMPTY)) {
            region.intersect(new Region(0, 0, this.currentScreenshot.getWidth(), this.currentScreenshot.getHeight()));
            if (!region.equals((Object)Region.EMPTY)) {
                BufferedImage subimage = this.currentScreenshot.getSubimage(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
                ByteArrayOutputStream temp = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)subimage, "png", temp);
                    ByteArrayInputStream readTemp = new ByteArrayInputStream(temp.toByteArray());
                    temp.close();
                    this.currentScreenshot = ImageIO.read(readTemp);
                    readTemp.close();
                }
                catch (IOException e) {
                    throw new EyesException("Failed to copy region from screenshot", (Throwable)e);
                }
                currentScreenshotEncoded = null;
            }
        }
        if (currentScreenshotEncoded == null) {
            ByteArrayOutputStream pngBytesStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.currentScreenshot, "png", pngBytesStream);
                pngBytesStream.flush();
                currentScreenshotEncoded = pngBytesStream.toByteArray();
                pngBytesStream.close();
            }
            catch (IOException e) {
                throw new EyesException("Failed to encode region", (Throwable)e);
            }
        }
        BufferedImage source = this.eyes.getLastScreenshot() != null ? this.eyes.getLastScreenshot().getImage() : null;
        try {
            compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks((BufferedImage)this.currentScreenshot, (byte[])currentScreenshotEncoded, (BufferedImage)source);
        }
        catch (IOException e) {
            throw new EyesException("Failed to compress screenshot!", (Throwable)e);
        }
        AppOutput appOutput = new AppOutput(title, null);
        return new MatchWindowData(this.eyes.getUserInputs(), appOutput, tag, ignoreMismatch, compressedScreenshot);
    }

    public MatchResult matchWindow(Region region, String tag, boolean shouldForceFullPageScreenshot, boolean shouldRunOnceOnTimeout) throws EyesException {
        if (0 == this.maxWindowLoadTimeMilliSeconds || shouldRunOnceOnTimeout) {
            if (shouldRunOnceOnTimeout) {
                GeneralUtils.sleep((long)this.maxWindowLoadTimeMilliSeconds);
            }
            String title = this.eyes.getTitle();
            String currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            MatchWindowData matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, shouldForceFullPageScreenshot, false);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
        } else {
            String title = this.eyes.getTitle();
            String currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            long retry = this.maxWindowLoadTimeMilliSeconds;
            long start = System.currentTimeMillis();
            MatchWindowData matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, shouldForceFullPageScreenshot, true);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
            retry -= System.currentTimeMillis() - start;
            while (retry > 0L && !this.matchResult.getAsExpected()) {
                GeneralUtils.sleep((long)500L);
                title = this.eyes.getTitle();
                currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, shouldForceFullPageScreenshot, true);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
                retry -= System.currentTimeMillis() - start;
            }
            if (!this.matchResult.getAsExpected()) {
                title = this.eyes.getTitle();
                currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, shouldForceFullPageScreenshot, false);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
            }
        }
        EyesScreenshot lastScreenshot = new EyesScreenshot(this.currentScreenshot);
        if (!region.equals((Object)Region.EMPTY)) {
            lastScreenshot.setBounds(region);
        }
        this.eyes.setLastScreenshot(lastScreenshot);
        this.eyes.clearUserInputs();
        return this.matchResult;
    }
}

