/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.GetAccessibilityRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.IGetAccessibilityRegionType;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.ImplicitInitiation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.serializers.WebElementSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class AccessibilityRegionByElement
implements GetAccessibilityRegion,
IGetSeleniumRegion,
IGetAccessibilityRegionType,
ImplicitInitiation {
    @JsonIgnore
    private EyesWebDriver driver;
    protected final AccessibilityRegionType regionType;
    @JsonSerialize(using=WebElementSerializer.class)
    protected final WebElement element;

    public AccessibilityRegionByElement(WebElement element, AccessibilityRegionType regionType) {
        this.element = element;
        this.regionType = regionType;
    }

    @Override
    public void init(Logger logger, EyesWebDriver driver) {
        this.driver = driver;
    }

    public List<AccessibilityRegionByRectangle> getRegions(EyesScreenshot screenshot) {
        Rectangle rectangle = EyesDriverUtils.getVisibleElementRect(this.element, this.driver);
        Dimension size = this.element.getSize();
        Location pTag = screenshot.convertLocation(new Location(rectangle.x, rectangle.y), CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        return Collections.singletonList(new AccessibilityRegionByRectangle(new Region(pTag, new RectangleSize(size.width, size.height)), this.regionType));
    }

    public AccessibilityRegionType getAccessibilityRegionType() {
        return this.regionType;
    }

    @JsonProperty(value="element")
    public WebElement getElement() {
        return this.element;
    }

    @Override
    public List<WebElement> getElements() {
        return Collections.singletonList(this.element);
    }
}

