/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Coordinates;

public class EyesDriverUtils {
    private static final String NATIVE_APP = "NATIVE_APP";
    private static final String PLATFORM_VERSION = "platformVersion";
    private static final String DEVICE_NAME = "deviceName";
    private static final String JS_GET_VIEWPORT_SIZE = "var height = undefined;var width = undefined;  if (window.innerHeight) {height = window.innerHeight;}  else if (document.documentElement && document.documentElement.clientHeight) {height = document.documentElement.clientHeight;}  else { var b = document.getElementsByTagName('body')[0]; if (b.clientHeight) {height = b.clientHeight;}}; if (window.innerWidth) {width = window.innerWidth;} else if (document.documentElement && document.documentElement.clientWidth) {width = document.documentElement.clientWidth;} else { var b = document.getElementsByTagName('body')[0]; if (b.clientWidth) {width = b.clientWidth;}};return width+';'+height;";
    private static final String JS_GET_CURRENT_SCROLL_POSITION = "var doc = document.documentElement; var x = window.scrollX || ((window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0)); var y = window.scrollY || ((window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0));return x+';'+y;";
    private static final String JS_GET_CONTENT_ENTIRE_SIZE = "var scrollWidth = document.documentElement.scrollWidth; var bodyScrollWidth = document.body.scrollWidth; var totalWidth = Math.max(scrollWidth, bodyScrollWidth); var clientHeight = document.documentElement.clientHeight; var bodyClientHeight = document.body.clientHeight; var scrollHeight = document.documentElement.scrollHeight; var bodyScrollHeight = document.body.scrollHeight; var maxDocElementHeight = Math.max(clientHeight, scrollHeight); var maxBodyHeight = Math.max(bodyClientHeight, bodyScrollHeight); var totalHeight = Math.max(maxDocElementHeight, maxBodyHeight); return totalWidth+';'+totalHeight;";
    private static final String[] JS_TRANSFORM_KEYS = new String[]{"transform", "-webkit-transform"};
    private static final String JS_GET_ENTIRE_PAGE_SIZE = "var width = Math.max(arguments[0].clientWidth, arguments[0].scrollWidth);var height = Math.max(arguments[0].clientHeight, arguments[0].scrollHeight);return width+';'+height;";
    private static String JS_GET_VISIBLE_ELEMENT_RECT;

    public static Location getPageLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.onPage();
        return new Location(p.getX(), p.getY());
    }

    public static Location getViewportLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.inViewPort();
        return new Location(p.getX(), p.getY());
    }

    public static WebDriver getUnderlyingDriver(WebDriver driver) {
        if (driver instanceof EyesWebDriver) {
            driver = ((EyesWebDriver)driver).getRemoteWebDriver();
        }
        return driver;
    }

    public static boolean isMobileDevice(WebDriver driver) {
        block4: {
            driver = EyesDriverUtils.getUnderlyingDriver(driver);
            try {
                Method isBrowser;
                if (!EyesDriverUtils.reflectionInstanceof(driver, "AppiumDriver")) break block4;
                try {
                    isBrowser = driver.getClass().getDeclaredMethod("isBrowser", new Class[0]);
                    isBrowser.setAccessible(true);
                }
                catch (NoSuchMethodException ignored) {
                    isBrowser = driver.getClass().getMethod("isBrowser", new Class[0]);
                }
                return isBrowser.invoke((Object)driver, new Object[0]).equals(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isLandscapeOrientation(Logger logger, WebDriver driver) {
        if (EyesDriverUtils.isMobileDevice(driver)) {
            boolean bl;
            String originalContext;
            WebDriver appiumDriver;
            block16: {
                appiumDriver = EyesDriverUtils.getUnderlyingDriver(driver);
                try {
                    originalContext = appiumDriver.getClass().getMethod("getContext", new Class[0]).invoke((Object)appiumDriver, new Object[0]).toString();
                    Set contextHandles = (Set)appiumDriver.getClass().getMethod("getContextHandles", new Class[0]).invoke((Object)appiumDriver, new Object[0]);
                    if (contextHandles.size() > 1 && !originalContext.equalsIgnoreCase(NATIVE_APP)) {
                        appiumDriver.getClass().getMethod("context", String.class).invoke((Object)appiumDriver, NATIVE_APP);
                    } else {
                        originalContext = null;
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | WebDriverException e) {
                    originalContext = null;
                }
                Object orientation = appiumDriver.getClass().getMethod("getOrientation", new Class[0]).invoke((Object)appiumDriver, new Object[0]);
                boolean bl2 = bl = orientation == ScreenOrientation.LANDSCAPE;
                if (originalContext == null) break block16;
                try {
                    appiumDriver.getClass().getMethod("context", String.class).invoke((Object)appiumDriver, originalContext);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return bl;
            catch (Exception e) {
                boolean bl3;
                block17: {
                    try {
                        GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
                        bl3 = false;
                        if (originalContext == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (originalContext != null) {
                            try {
                                appiumDriver.getClass().getMethod("context", String.class).invoke((Object)appiumDriver, originalContext);
                            }
                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                                e2.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    try {
                        appiumDriver.getClass().getMethod("context", String.class).invoke((Object)appiumDriver, originalContext);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e3) {
                        e3.printStackTrace();
                    }
                }
                return bl3;
            }
        }
        return false;
    }

    public static String selectRootElement(JavascriptExecutor executor) {
        return "documentElement";
    }

    public static String setOverflow(JavascriptExecutor executor, String value, WebElement rootElement) {
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        ArgumentGuard.notNull((Object)rootElement, (String)"rootElement");
        String script = String.format("var origOF = arguments[0].style.overflow;arguments[0].style.overflow = '%s';if ('%s'.toUpperCase() === 'HIDDEN' && origOF.toUpperCase() !== 'HIDDEN') arguments[0].setAttribute('data-applitools-original-overflow',origOF);return origOF;", value, value);
        try {
            String result = (String)executor.executeScript(script, new Object[]{rootElement});
            GeneralUtils.sleep((long)200L);
            return result;
        }
        catch (WebDriverException e) {
            throw new EyesDriverOperationException("Failed to set overflow", e);
        }
    }

    public static Location getCurrentScrollPosition(IEyesJsExecutor executor) {
        return EyesDriverUtils.parseLocationString(executor.executeScript(JS_GET_CURRENT_SCROLL_POSITION, new Object[0]));
    }

    public static Location parseLocationString(Object position) {
        String[] xy = position.toString().split(";");
        if (xy.length != 2) {
            throw new EyesException("Could not get scroll position!");
        }
        float x = Float.parseFloat(xy[0]);
        float y = Float.parseFloat(xy[1]);
        return new Location((int)Math.ceil(x), (int)Math.ceil(y));
    }

    public static void setCurrentScrollPosition(IEyesJsExecutor executor, Location location) {
        executor.executeScript(String.format("window.scrollTo(%d,%d)", location.getX(), location.getY()), new Object[0]);
    }

    public static RectangleSize getCurrentFrameContentEntireSize(IEyesJsExecutor executor) {
        RectangleSize result;
        try {
            Object retVal = executor.executeScript(JS_GET_CONTENT_ENTIRE_SIZE, new Object[0]);
            String[] wh = ((String)retVal).split(";");
            if (wh.length != 2) {
                throw new EyesException("Could not get entire size!");
            }
            float w = Float.parseFloat(wh[0]);
            float h = Float.parseFloat(wh[1]);
            result = new RectangleSize(Math.round(w), Math.round(h));
        }
        catch (WebDriverException e) {
            throw new EyesDriverOperationException("Failed to extract entire size!");
        }
        return result;
    }

    public static RectangleSize getEntireElementSize(Logger logger, IEyesJsExecutor executor, WebElement element) {
        RectangleSize result;
        try {
            Object retVal = executor.executeScript(JS_GET_ENTIRE_PAGE_SIZE, new Object[]{element});
            String[] wh = ((String)retVal).split(";");
            if (wh.length != 2) {
                throw new EyesException("Could not get entire element size!");
            }
            float w = Float.parseFloat(wh[0]);
            float h = Float.parseFloat(wh[1]);
            result = new RectangleSize(Math.round(w), Math.round(h));
        }
        catch (WebDriverException e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            throw new EyesDriverOperationException("Failed to extract entire element size!");
        }
        return result;
    }

    public static RectangleSize getViewportSize(JavascriptExecutor executor) {
        String viewportSizeAsString = (String)executor.executeScript(JS_GET_VIEWPORT_SIZE, new Object[0]);
        String[] wh = viewportSizeAsString.split(";");
        if (wh.length != 2) {
            throw new EyesException("Could not get viewport size!");
        }
        float w = Float.parseFloat(wh[0]);
        float h = Float.parseFloat(wh[1]);
        return new RectangleSize(Math.round(w), Math.round(h));
    }

    public static RectangleSize getViewportSizeOrDisplaySize(Logger logger, WebDriver driver) {
        if (!EyesDriverUtils.isMobileDevice(driver)) {
            try {
                return EyesDriverUtils.getViewportSize((JavascriptExecutor)driver);
            }
            catch (Exception ex) {
                GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)ex, (String[])new String[0]);
            }
        }
        Dimension windowSize = driver.manage().window().getSize();
        int width = windowSize.getWidth();
        int height = windowSize.getHeight();
        try {
            if (EyesDriverUtils.isLandscapeOrientation(logger, driver) && height > width) {
                int height2 = width;
                width = height;
                height = height2;
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
        return new RectangleSize(width, height);
    }

    public static boolean setBrowserSize(WebDriver driver, RectangleSize requiredSize) {
        RectangleSize currentSize;
        int SLEEP = 1000;
        int retriesLeft = 3;
        Dimension dRequiredSize = new Dimension(requiredSize.getWidth(), requiredSize.getHeight());
        do {
            driver.manage().window().setSize(dRequiredSize);
            GeneralUtils.sleep((long)1000L);
            Dimension dCurrentSize = driver.manage().window().getSize();
            currentSize = new RectangleSize(dCurrentSize.getWidth(), dCurrentSize.getHeight());
        } while (--retriesLeft > 0 && !currentSize.equals((Object)requiredSize));
        return currentSize == requiredSize;
    }

    public static boolean setBrowserSizeByViewportSize(WebDriver driver, RectangleSize actualViewportSize, RectangleSize requiredViewportSize) {
        Dimension browserSize = driver.manage().window().getSize();
        RectangleSize requiredBrowserSize = new RectangleSize(browserSize.width + (requiredViewportSize.getWidth() - actualViewportSize.getWidth()), browserSize.height + (requiredViewportSize.getHeight() - actualViewportSize.getHeight()));
        return EyesDriverUtils.setBrowserSize(driver, requiredBrowserSize);
    }

    public static void setViewportSize(Logger logger, WebDriver driver, RectangleSize size) {
        RectangleSize actualViewportSize;
        ArgumentGuard.notNull((Object)size, (String)"size");
        if (size.isEmpty()) {
            return;
        }
        RectangleSize requiredSize = new RectangleSize(size.getWidth(), size.getHeight());
        try {
            actualViewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)driver);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            throw e;
        }
        if (actualViewportSize.equals((Object)requiredSize)) {
            return;
        }
        try {
            driver.manage().window().setPosition(new Point(0, 0));
        }
        catch (WebDriverException e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
        }
        EyesDriverUtils.setBrowserSizeByViewportSize(driver, actualViewportSize, requiredSize);
        actualViewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)driver);
        if (actualViewportSize.equals((Object)requiredSize)) {
            return;
        }
        EyesDriverUtils.setBrowserSizeByViewportSize(driver, actualViewportSize, requiredSize);
        actualViewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)driver);
        if (actualViewportSize.equals((Object)requiredSize)) {
            return;
        }
        int MAX_DIFF = 3;
        int widthDiff = actualViewportSize.getWidth() - requiredSize.getWidth();
        int widthStep = widthDiff > 0 ? -1 : 1;
        int heightDiff = actualViewportSize.getHeight() - requiredSize.getHeight();
        int heightStep = heightDiff > 0 ? -1 : 1;
        Dimension dBrowserSize = driver.manage().window().getSize();
        RectangleSize browserSize = new RectangleSize(dBrowserSize.getWidth(), dBrowserSize.getHeight());
        int currWidthChange = 0;
        int currHeightChange = 0;
        if (Math.abs(widthDiff) <= 3 && Math.abs(heightDiff) <= 3) {
            int retriesLeft = Math.abs((widthDiff == 0 ? 1 : widthDiff) * (heightDiff == 0 ? 1 : heightDiff)) * 2;
            RectangleSize lastRequiredBrowserSize = null;
            do {
                RectangleSize requiredBrowserSize;
                if (Math.abs(currWidthChange) <= Math.abs(widthDiff) && actualViewportSize.getWidth() != requiredSize.getWidth()) {
                    currWidthChange += widthStep;
                }
                if (Math.abs(currHeightChange) <= Math.abs(heightDiff) && actualViewportSize.getHeight() != requiredSize.getHeight()) {
                    currHeightChange += heightStep;
                }
                if ((requiredBrowserSize = new RectangleSize(browserSize.getWidth() + currWidthChange, browserSize.getHeight() + currHeightChange)).equals(lastRequiredBrowserSize)) break;
                EyesDriverUtils.setBrowserSize(driver, requiredBrowserSize);
                lastRequiredBrowserSize = requiredBrowserSize;
                actualViewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)driver);
                if (!actualViewportSize.equals((Object)requiredSize)) continue;
                return;
            } while ((Math.abs(currWidthChange) <= Math.abs(widthDiff) || Math.abs(currHeightChange) <= Math.abs(heightDiff)) && --retriesLeft > 0);
        }
        throw new EyesException("Failed to set viewport size!");
    }

    public static boolean isAndroid(WebDriver driver) {
        driver = EyesDriverUtils.getUnderlyingDriver(driver);
        return EyesDriverUtils.reflectionInstanceof(driver, "AndroidDriver");
    }

    public static boolean isIOS(WebDriver driver) {
        driver = EyesDriverUtils.getUnderlyingDriver(driver);
        return EyesDriverUtils.reflectionInstanceof(driver, "IOSDriver");
    }

    public static String getPlatformVersion(HasCapabilities driver) {
        Capabilities capabilities = driver.getCapabilities();
        Object platformVersionObj = capabilities.getCapability("os_version");
        if (platformVersionObj == null) {
            platformVersionObj = capabilities.getCapability(PLATFORM_VERSION);
        }
        return platformVersionObj == null ? null : String.valueOf(platformVersionObj);
    }

    public static String getMobileDeviceName(HasCapabilities driver) {
        Capabilities capabilities = driver.getCapabilities();
        Object desiredCaps = capabilities.getCapability("desired");
        if (desiredCaps != null) {
            Map caps = (Map)desiredCaps;
            Object deviceNameCapability = caps.get(DEVICE_NAME);
            return deviceNameCapability != null ? deviceNameCapability.toString() : "Unknown";
        }
        Object deviceNameCapability = capabilities.getCapability(DEVICE_NAME);
        String deviceName = deviceNameCapability != null ? deviceNameCapability.toString() : "Unknown";
        Object deviceCapability = capabilities.getCapability("device");
        if (deviceCapability != null && !deviceName.toLowerCase().contains(deviceCapability.toString())) {
            deviceName = deviceCapability.toString();
        }
        return deviceName;
    }

    public static Map<String, String> getCurrentTransform(IEyesJsExecutor executor) {
        StringBuilder script = new StringBuilder("return { ");
        for (String key : JS_TRANSFORM_KEYS) {
            script.append("'").append(key).append("'").append(": document.documentElement.style['").append(key).append("'],");
        }
        script.append(" }");
        return (Map)executor.executeScript(script.toString(), new Object[0]);
    }

    public static void setTransforms(IEyesJsExecutor executor, Map<String, String> transforms) {
        StringBuilder script = new StringBuilder();
        for (Map.Entry<String, String> entry : transforms.entrySet()) {
            script.append("document.documentElement.style['").append(entry.getKey()).append("'] = '").append(entry.getValue()).append("';");
        }
        executor.executeScript(script.toString(), new Object[0]);
    }

    public static void setTransform(IEyesJsExecutor executor, String transform) {
        HashMap<String, String> transforms = new HashMap<String, String>(JS_TRANSFORM_KEYS.length);
        for (String key : JS_TRANSFORM_KEYS) {
            transforms.put(key, transform);
        }
        EyesDriverUtils.setTransforms(executor, transforms);
    }

    public static RectangleSize getElementVisibleSize(Logger logger, WebElement element) {
        WebElement parent;
        Point location = element.getLocation();
        Dimension size = element.getSize();
        Region region = new Region(location.getX(), location.getY(), size.getWidth(), size.getHeight());
        try {
            parent = element.findElement(By.xpath((String)".."));
        }
        catch (Exception e) {
            parent = null;
        }
        block6: while (true) {
            try {
                while (parent != null && !region.isSizeEmpty()) {
                    Point parentLocation = parent.getLocation();
                    Dimension parentSize = parent.getSize();
                    Region parentRegion = new Region(parentLocation.getX(), parentLocation.getY(), parentSize.getWidth(), parentSize.getHeight());
                    region.intersect(parentRegion);
                    try {
                        parent = parent.findElement(By.xpath((String)".."));
                        continue block6;
                    }
                    catch (Exception e) {
                        parent = null;
                    }
                }
                break;
            }
            catch (Exception ex) {
                GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)ex, (String[])new String[0]);
                break;
            }
        }
        return region.getSize();
    }

    public static void translateTo(IEyesJsExecutor executor, Location position) {
        EyesDriverUtils.setTransform(executor, String.format("translate(-%spx, -%spx)", position.getX(), position.getY()));
    }

    public static WebElement getWrappedWebElement(WebElement webElement) {
        Field[] fields;
        if (!(webElement instanceof Proxy)) {
            return webElement;
        }
        Proxy proxy = (Proxy)webElement;
        for (Field field : fields = Proxy.class.getDeclaredFields()) {
            if (!field.getType().equals(InvocationHandler.class)) continue;
            field.setAccessible(true);
            try {
                InvocationHandler handler = (InvocationHandler)field.get(proxy);
                return (WebElement)handler.invoke(null, WrapsElement.class.getMethod("getWrappedElement", new Class[0]), null);
            }
            catch (Throwable throwable) {
                throw new EyesException("Failed getting web element from page object", throwable);
            }
        }
        throw new IllegalStateException("InvocationHandler field wasn't found in proxy class");
    }

    private static boolean reflectionInstanceof(Object object, String className) {
        for (Class<?> objectClass = object.getClass(); objectClass != null; objectClass = objectClass.getSuperclass()) {
            if (!objectClass.getSimpleName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static Rectangle getVisibleElementRect(WebElement webElement, EyesWebDriver driver) {
        if (EyesDriverUtils.isMobileDevice(driver)) {
            return new Rectangle(webElement.getLocation(), webElement.getSize());
        }
        String result = (String)driver.executeScript(JS_GET_VISIBLE_ELEMENT_RECT, new Object[]{webElement});
        String[] data = result.split(";");
        return new Rectangle(Math.round(Float.parseFloat(data[0])), Math.round(Float.parseFloat(data[1])), Math.round(Float.parseFloat(data[3])), Math.round(Float.parseFloat(data[2])));
    }

    static {
        try {
            JS_GET_VISIBLE_ELEMENT_RECT = GeneralUtils.readToEnd((InputStream)EyesDriverUtils.class.getResourceAsStream("/getVisibleRect.js"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

