/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.EyesBase;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MobileDeviceInfo;
import com.applitools.eyes.config.Feature;
import com.applitools.eyes.selenium.EyesDriverUtils;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class EyesWebDriver
implements WebDriver,
JavascriptExecutor,
TakesScreenshot,
SearchContext,
HasCapabilities {
    protected final Logger logger;
    private final EyesBase eyesBase;

    protected EyesWebDriver(Logger logger, EyesBase eyesBase) {
        this.logger = logger;
        this.eyesBase = eyesBase;
    }

    public abstract RemoteWebDriver getRemoteWebDriver();

    public abstract WebElement findElement(By var1);

    public abstract List<WebElement> findElements(By var1);

    public double getDevicePixelRatio() {
        if (this.eyesBase.getConfiguration().isFeatureActivated(Feature.USE_PREDEFINED_DEVICE_INFO)) {
            Map mobileDevicesInfo = this.eyesBase.getMobileDeviceInfo();
            String deviceName = this.eyesBase.getConfiguration().getDeviceInfo();
            deviceName = deviceName == null ? EyesDriverUtils.getMobileDeviceName(this) : deviceName;
            for (MobileDeviceInfo mobileDeviceInfo : mobileDevicesInfo.values()) {
                for (String name : mobileDeviceInfo.getAliases()) {
                    if (!deviceName.equalsIgnoreCase(name)) continue;
                    this.logger.verbose(String.format("Device name found in the server: %s. Pixel ratio: %f", deviceName, mobileDeviceInfo.getPixelRatio()));
                    return mobileDeviceInfo.getPixelRatio();
                }
            }
        }
        return this.getDevicePixelRatioInner();
    }

    protected abstract double getDevicePixelRatioInner();
}

