/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class SimpleRegionByElement
implements GetSimpleRegion,
IGetSeleniumRegion {
    protected final WebElement element;

    public SimpleRegionByElement(WebElement element) {
        this.element = element;
    }

    public List<Region> getRegions(EyesScreenshot screenshot) {
        Point locationAsPoint = this.element.getLocation();
        Dimension size = this.element.getSize();
        Location adjustedLocation = new Location(locationAsPoint.getX(), locationAsPoint.getY());
        if (screenshot != null) {
            adjustedLocation = screenshot.convertLocation(adjustedLocation, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        }
        ArrayList<Region> value = new ArrayList<Region>();
        value.add(new Region(adjustedLocation, new RectangleSize(size.getWidth(), size.getHeight()), CoordinatesType.SCREENSHOT_AS_IS));
        return value;
    }

    @Override
    public List<WebElement> getElements() {
        return Collections.singletonList(this.element);
    }
}

