/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.glassfish.jersey.message.internal;

import com.applitools.shaded.eyessdk.glassfish.jersey.internal.LocalizationMessages;
import com.applitools.shaded.eyessdk.glassfish.jersey.message.internal.Utils;
import com.applitools.shaded.eyessdk.glassfish.jersey.spi.HeaderDelegateProvider;
import com.applitools.shaded.javax.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;

@Singleton
public class UriProvider
implements HeaderDelegateProvider<URI> {
    @Override
    public boolean supports(Class<?> type) {
        return type == URI.class;
    }

    @Override
    public String toString(URI header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.URI_IS_NULL());
        return header.toASCIIString();
    }

    @Override
    public URI fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.URI_IS_NULL());
        try {
            return new URI(header);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error parsing uri '" + header + "'", e);
        }
    }
}

