/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.LogHandler;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;

public class FileLogger
implements LogHandler {
    private final boolean isVerbose;
    private final String filename;
    private final boolean append;
    private BufferedWriter file;

    public FileLogger(String filename, boolean append, boolean isVerbose) {
        ArgumentGuard.notNullOrEmpty(filename, "filename");
        this.filename = filename;
        this.append = append;
        this.isVerbose = isVerbose;
        this.file = null;
    }

    public FileLogger(boolean isVerbose) {
        this("eyes.log", true, isVerbose);
    }

    public void open() {
        try {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.file = new BufferedWriter(new FileWriter(new File(this.filename), this.append));
        }
        catch (IOException e) {
            throw new EyesException("Failed to create log file!", e);
        }
    }

    public void onMessage(boolean verbose, String logString) {
        if (this.file != null && (!verbose || this.isVerbose)) {
            String currentTime = GeneralUtils.toISO8601DateTime(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            try {
                this.file.write(currentTime + " Eyes: " + logString);
                this.file.newLine();
                this.file.flush();
            }
            catch (IOException e) {
                throw new EyesException("Failed to write log to file!", e);
            }
        }
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.file = null;
    }
}

