/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.org.apache.http.impl.execchain;

import com.applitools.shaded.eyessdk.org.apache.http.HttpException;
import com.applitools.shaded.eyessdk.org.apache.http.annotation.Immutable;
import com.applitools.shaded.eyessdk.org.apache.http.client.ServiceUnavailableRetryStrategy;
import com.applitools.shaded.eyessdk.org.apache.http.client.methods.CloseableHttpResponse;
import com.applitools.shaded.eyessdk.org.apache.http.client.methods.HttpExecutionAware;
import com.applitools.shaded.eyessdk.org.apache.http.client.methods.HttpRequestWrapper;
import com.applitools.shaded.eyessdk.org.apache.http.client.protocol.HttpClientContext;
import com.applitools.shaded.eyessdk.org.apache.http.conn.routing.HttpRoute;
import com.applitools.shaded.eyessdk.org.apache.http.impl.execchain.ClientExecChain;
import com.applitools.shaded.eyessdk.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        int c = 1;
        while (true) {
            block6: {
                CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
                try {
                    if (this.retryStrategy.retryRequest(response, c, context)) {
                        response.close();
                        long nextInterval = this.retryStrategy.getRetryInterval();
                        if (nextInterval <= 0L) break block6;
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                            break block6;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return response;
                }
                catch (RuntimeException ex) {
                    response.close();
                    throw ex;
                }
            }
            ++c;
        }
    }
}

