/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.utils.ArgumentGuard;

public class Location
implements Cloneable {
    private int x;
    private int y;
    public static final Location ZERO = new Location(0, 0);

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return this.getX() == other.getX() && this.getY() == other.getY();
    }

    public int hashCode() {
        return this.getX() + this.getY();
    }

    public Location(Location other) {
        ArgumentGuard.notNull(other, "other");
        this.x = other.getX();
        this.y = other.getY();
    }

    public void offset(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void offset(Location amount) {
        this.x += amount.getX();
        this.y += amount.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

