/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.Iso8610CalendarSerializer;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class BatchInfo {
    private static final String BATCH_TIMEZONE = "UTC";
    private String id;
    private final String name;
    private final String startedAt;

    public BatchInfo(String name, Calendar startedAt) {
        ArgumentGuard.notNull(startedAt, "startedAt");
        this.id = UUID.randomUUID().toString();
        this.name = name;
        this.startedAt = GeneralUtils.toISO8601DateTime(startedAt);
    }

    public BatchInfo(String name) {
        this(name, Calendar.getInstance(TimeZone.getTimeZone(BATCH_TIMEZONE)));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonSerialize(using=Iso8610CalendarSerializer.class)
    public Calendar getStartedAt() {
        try {
            return GeneralUtils.fromISO8601DateTime(this.startedAt);
        }
        catch (ParseException ex) {
            throw new EyesException("Failed to parse batch start time", ex);
        }
    }

    public String toString() {
        return "'" + this.name + "' - " + this.startedAt;
    }
}

