/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private long bytesCount;

    public CountingOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.bytesCount = 0L;
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.bytesCount += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.bytesCount += (long)len;
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        ++this.bytesCount;
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public long getBytesCount() {
        return this.bytesCount;
    }
}

