/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RestClient {
    protected Client restClient;
    protected WebResource endPoint;
    protected ObjectMapper jsonMapper;

    public static ClientConfig getAllCertsConfig() {
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, certs, new SecureRandom());
        }
        catch (GeneralSecurityException ex) {
            // empty catch block
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        DefaultClientConfig config = new DefaultClientConfig();
        try {
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }, ctx));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config;
    }

    public RestClient(URI serverUri) {
        ArgumentGuard.notNull(serverUri, "serverUri");
        this.jsonMapper = new ObjectMapper();
        this.restClient = Client.create((ClientConfig)RestClient.getAllCertsConfig());
        this.endPoint = this.restClient.resource(serverUri);
    }

    public RestClient(URI serverUri, Map<String, Object> additionalProperties) {
        ArgumentGuard.notNull(serverUri, "serverUri");
        ArgumentGuard.notNull(additionalProperties, "additionalProperties");
        this.jsonMapper = new ObjectMapper();
        ClientConfig cc = RestClient.getAllCertsConfig();
        cc.getProperties().putAll(additionalProperties);
        this.restClient = Client.create((ClientConfig)cc);
        this.endPoint = this.restClient.resource(serverUri);
    }

    protected String getReadResponseError(String errMsg, int statusCode, String statusPhrase, String responseBody) {
        ArgumentGuard.notNull(statusPhrase, "statusPhrase");
        if (errMsg == null) {
            errMsg = "";
        }
        if (responseBody == null) {
            responseBody = "";
        }
        return errMsg + " [" + statusCode + " " + statusPhrase + "] " + responseBody;
    }

    protected String readData(ClientResponse response) {
        String responseData;
        ArgumentGuard.notNull(response, "response");
        try {
            responseData = GeneralUtils.readToEnd(response.getEntityInputStream());
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed to read response body", response.getStatus(), response.getClientResponseStatus().getReasonPhrase(), null);
            throw new EyesException(errorMessage, e);
        }
        return responseData;
    }

    protected <T> T parseResponseWithJsonData(ClientResponse response, List<Integer> validHttpStatusCodes, Class<T> resultType) throws EyesException {
        Object resultObject;
        ArgumentGuard.notNull(response, "response");
        ArgumentGuard.notNull(validHttpStatusCodes, "validHttpStatusCodes");
        ArgumentGuard.notNull(resultType, "resultType");
        int statusCode = response.getStatus();
        String statusPhrase = response.getClientResponseStatus().getReasonPhrase();
        String data = this.readData(response);
        if (!validHttpStatusCodes.contains(statusCode)) {
            String errorMessage = this.getReadResponseError("Invalid status code", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage);
        }
        try {
            resultObject = this.jsonMapper.readValue(data, resultType);
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed to deserialize response body", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage, e);
        }
        return (T)resultObject;
    }
}

