/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.MouseTrigger;
import com.applitools.eyes.NewTestException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestFailedException;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TextTrigger;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageDeltaCompressor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.imageio.ImageIO;

abstract class EyesBase {
    protected static final MatchLevel DEFAULT_MATCH_LEVEL = MatchLevel.EXACT;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static String apiKey;
    protected AgentConnector agentConnector;
    protected RunningSession runningSession;
    protected SessionStartInfo sessionStartInfo;
    protected RectangleSize viewportSize;
    protected EyesScreenshot lastScreenshot;
    private boolean isDisabled;
    private boolean isOpen;
    private String appName;
    private String testName;
    private MatchLevel matchLevel;
    private BatchInfo batch;
    private String hostApp;
    private String hostOS;
    private String branchName;
    private String parentBranchName;
    private FailureReports failureReports;
    private final Queue<Trigger> userInputs;
    private boolean saveNewTests;
    private boolean saveFailedTests;

    public EyesBase(URI serverUrl, boolean isDisabled) {
        if (isDisabled) {
            this.isDisabled = true;
            this.userInputs = null;
            Logger.verbose("Eyes(): Ignored");
            return;
        }
        ArgumentGuard.notNull(serverUrl, "serverUrl");
        Logger.log("Eyes Server URL is " + serverUrl);
        this.userInputs = new ArrayDeque<Trigger>();
        this.viewportSize = null;
        this.agentConnector = new AgentConnector(this.getAgentId(), serverUrl);
        this.runningSession = null;
        this.failureReports = FailureReports.ON_CLOSE;
        this.saveNewTests = true;
        this.saveFailedTests = false;
        this.lastScreenshot = null;
    }

    public abstract String getAgentId();

    protected static void setLogHandler(LogHandler logHandler) {
        Logger.setLogHandler(logHandler);
    }

    protected static void setApiKey(String apiKey) {
        ArgumentGuard.notNull(apiKey, "apiKey");
        EyesBase.apiKey = apiKey;
    }

    protected static String getApiKey() {
        return apiKey;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    public FailureReports getFailureReports() {
        return this.failureReports;
    }

    public boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
    }

    public boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
    }

    public void open(String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel, FailureReports failureReports) {
        if (this.isDisabled) {
            Logger.verbose("open(): Ignored");
            return;
        }
        if (apiKey == null) {
            String errMsg = "API key is missing! Please set it using setApiKey()";
            Logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        ArgumentGuard.notNull(appName, "appName");
        ArgumentGuard.notNull(testName, "testName");
        ArgumentGuard.notEqual((Object)matchLevel, (Object)MatchLevel.NONE, "matchLevel");
        Logger.verbose("open(" + appName + ", " + testName + ", " + viewportSize + ", " + (Object)((Object)failureReports) + ")");
        if (this.isOpen) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            Logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        this.appName = appName;
        this.testName = testName;
        this.viewportSize = viewportSize;
        this.matchLevel = matchLevel;
        this.failureReports = failureReports;
        this.isOpen = true;
    }

    public TestResults close() {
        if (this.isDisabled) {
            Logger.verbose("close(): Ignored");
            return null;
        }
        Logger.verbose("close()");
        ArgumentGuard.isValidState(this.isOpen, "Eyes not open");
        this.isOpen = false;
        if (this.runningSession == null) {
            Logger.verbose("close(): Server session was not started");
            Logger.log("--- Empty test ended.");
            return new TestResults();
        }
        boolean isNewSession = this.runningSession.getIsNewSession();
        String sessionResultsUrl = this.runningSession.getUrl();
        Logger.verbose("close(): Ending server session...");
        boolean save = isNewSession && this.saveNewTests || !isNewSession && this.saveFailedTests;
        Logger.verbose("Automatically save test? " + String.valueOf(save));
        TestResults results = this.agentConnector.stopSession(this.runningSession, false, save);
        Logger.verbose("close(): " + results);
        this.runningSession = null;
        if (!(isNewSession || 0 >= results.getMismatches() && 0 >= results.getMissing())) {
            String instructions;
            if (save) {
                instructions = "Test was automatically accepted. You can review it at " + sessionResultsUrl;
                Logger.log("--- Failed test ended. " + instructions);
            } else {
                instructions = "Failed test ended. See details at " + sessionResultsUrl;
                Logger.log("--- " + instructions);
            }
            String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
            throw new TestFailedException(results, message);
        }
        if (isNewSession) {
            String instructions = save ? "Test was automatically saved. You can review it at " + sessionResultsUrl : "Please approve the new baseline at " + sessionResultsUrl;
            Logger.log("--- New test ended. " + instructions);
            String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
            throw new NewTestException(results, message);
        }
        Logger.log("--- Test passed. See details at " + sessionResultsUrl);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortIfNotClosed() {
        if (this.isDisabled) {
            Logger.verbose("abortIfNotClosed(): Ignored");
            return;
        }
        this.isOpen = false;
        if (null == this.runningSession) {
            Logger.verbose("abortIfNotClosed(): closed");
            return;
        }
        Logger.verbose("abortIfNotClosed(): Aborting server session...");
        try {
            this.agentConnector.stopSession(this.runningSession, true, false);
            Logger.log("--- Test aborted.");
        }
        catch (EyesException ex) {
            Logger.log("Failed to abort server session: " + ex.getMessage());
        }
        finally {
            this.runningSession = null;
        }
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public void setParentBranchName(String branchName) {
        this.parentBranchName = branchName;
    }

    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.isDisabled) {
            Logger.verbose("setAppEnvironment(): Ignored");
            return;
        }
        Logger.verbose("setAppEnvironment(" + hostOS + ", " + hostApp + ")");
        this.hostOS = hostOS;
        this.hostApp = hostApp;
    }

    public void setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            Logger.verbose("setBatch(): Ignored");
            return;
        }
        ArgumentGuard.isValidState(null == this.runningSession, "test is running");
        Logger.verbose("setBatch(" + batch + ")");
        this.batch = batch;
    }

    public static URI getDefaultServerUrl() {
        try {
            return new URI("https://eyes.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), ex);
        }
    }

    protected void setLastScreenshot(EyesScreenshot screenshot) {
        this.lastScreenshot = screenshot;
    }

    protected EyesScreenshot getLastScreenshot() {
        return this.lastScreenshot;
    }

    private MatchWindowData createWindowData(BufferedImage currentScreenshot, String title, String tag, boolean ignoreMismatch) {
        byte[] compressedScreenshot;
        byte[] currentScreenshotEncoded;
        ByteArrayOutputStream pngBytesStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)currentScreenshot, "png", pngBytesStream);
            pngBytesStream.flush();
            currentScreenshotEncoded = pngBytesStream.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed to encode region", e);
        }
        finally {
            try {
                pngBytesStream.close();
            }
            catch (IOException e) {
                throw new EyesException("Failed to close png byte stream", e);
            }
        }
        BufferedImage source = this.lastScreenshot != null ? this.lastScreenshot.getImage() : null;
        try {
            compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks(currentScreenshot, currentScreenshotEncoded, source);
        }
        catch (IOException e) {
            throw new EyesException("Failed to compress screenshot!", e);
        }
        AppOutput appOutput = new AppOutput(title, null);
        return new MatchWindowData(this.getUserInputs(), appOutput, tag, ignoreMismatch, compressedScreenshot);
    }

    protected void checkRegion(BufferedImage image, Region region, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            Logger.verbose("CheckRegion(Image, region, String, boolean): Ignored");
            return;
        }
        ArgumentGuard.notNull(image, "image cannot be null!");
        ArgumentGuard.notNull(image, "region cannot be null!");
        ArgumentGuard.isValidState(this.getIsOpen(), "Eyes not open");
        Logger.verbose("CheckRegion(image, '" + (tag != null ? tag : "") + "')");
        if (this.runningSession == null) {
            this.startSession();
        }
        if (!region.equals(Region.EMPTY)) {
            region.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
            if (!region.equals(Region.EMPTY)) {
                image = image.getSubimage(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
            } else {
                throw new EyesException("Requested region does not intersect with the image!");
            }
        }
        MatchWindowData matchWindowData = this.createWindowData(image, this.getTitle(), tag, ignoreMismatch);
        MatchResult result = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
        if (!ignoreMismatch) {
            this.lastScreenshot = new EyesScreenshot(image);
            if (!region.equals(Region.EMPTY)) {
                this.lastScreenshot.setBounds(region);
            }
            this.clearUserInputs();
            if (!result.getAsExpected()) {
                if (!this.runningSession.getIsNewSession()) {
                    Logger.log("Window Mismatch " + (tag == null ? "" : " (" + tag + ")"));
                }
                if (this.getFailureReports().equals((Object)FailureReports.IMMEDIATE)) {
                    throw new TestFailedException("Mismatch found in '" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'");
                }
            }
        } else if (result.getAsExpected()) {
            this.clearUserInputs();
            this.lastScreenshot = new EyesScreenshot(image);
        }
    }

    protected void checkWindow(BufferedImage image, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            Logger.verbose("CheckWindow(Image, String, boolean): Ignored");
            return;
        }
        this.checkRegion(image, Region.EMPTY, tag, ignoreMismatch);
    }

    protected void addUserInput(Trigger trigger) {
        if (this.isDisabled) {
            return;
        }
        ArgumentGuard.notNull(trigger, "trigger");
        this.userInputs.add(trigger);
    }

    protected void clearUserInputs() {
        if (this.isDisabled) {
            return;
        }
        this.userInputs.clear();
    }

    protected Trigger[] getUserInputs() {
        if (this.isDisabled) {
            return null;
        }
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    protected void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            Logger.verbose(String.format("AddMouseTrigger: Ignoring %s (disabled)", new Object[]{action}));
            return;
        }
        if (this.lastScreenshot == null) {
            Logger.verbose(String.format("AddMouseTrigger: Ignoring %s (no screenshot)", new Object[]{action}));
            return;
        }
        Region sb = this.lastScreenshot.getBounds();
        cursor.offset(control.getLocation());
        if (!sb.contains(cursor)) {
            Logger.verbose(String.format("AddMouseTrigger: Ignoring %s (out of bounds)", new Object[]{action}));
            return;
        }
        control.intersect(sb);
        if (control.equals(Region.EMPTY)) {
            cursor.offset(-sb.getLeft(), -sb.getTop());
        } else {
            cursor.offset(-control.getLeft(), -control.getTop());
            Location controlLocation = control.getLocation();
            controlLocation.offset(-sb.getLeft(), -sb.getTop());
            control.setLocation(controlLocation);
        }
        MouseTrigger trigger = new MouseTrigger(action, new Region(control), new Location(cursor));
        this.addUserInput(trigger);
        Logger.verbose(String.format("AddMouseTrigger: Added %s", trigger));
    }

    protected void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            Logger.verbose("AddTextTrigger: Ignoring " + text + " (disabled)");
            return;
        }
        if (this.lastScreenshot == null) {
            Logger.verbose("AddTextTrigger: Ignoring " + text + " (no screenshot)");
            return;
        }
        if (!control.equals(Region.EMPTY)) {
            Region sb = this.lastScreenshot.getBounds();
            control.intersect(sb);
            if (control.equals(Region.EMPTY)) {
                Logger.verbose("AddTextTrigger: Ignoring " + text + " (out of bounds)");
                return;
            }
            Location offsettedLocation = control.getLocation();
            offsettedLocation.offset(-sb.getLeft(), -sb.getTop());
            control.setLocation(offsettedLocation);
        }
        TextTrigger trigger = new TextTrigger(new Region(control), text);
        this.addUserInput(trigger);
        Logger.verbose(String.format("AddTextTrigger: Added %s", trigger));
    }

    protected RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    protected void setViewportSize(RectangleSize size) {
        this.viewportSize = size;
    }

    protected abstract String getInferredEnvironment();

    protected abstract String getTitle();

    protected AppEnvironment getEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.hostOS != null) {
            appEnv.setOs(this.hostOS);
        }
        if (this.hostApp != null) {
            appEnv.setHostingApp(this.hostApp);
        }
        appEnv.setInferred(this.getInferredEnvironment());
        appEnv.setDisplaySize(this.viewportSize);
        return appEnv;
    }

    protected void startSession() {
        BatchInfo testBatch;
        Logger.verbose("startSession()");
        if (this.viewportSize == null) {
            this.viewportSize = this.getViewportSize();
        } else {
            this.setViewportSize(this.viewportSize);
        }
        if (this.batch == null) {
            Logger.verbose("startSession(): No batch set");
            testBatch = new BatchInfo(null);
        } else {
            Logger.verbose("startSession(): Batch is " + this.batch);
            testBatch = this.batch;
        }
        AppEnvironment appEnv = this.getEnvironment();
        Logger.verbose("startSession(): Application environment is " + appEnv);
        this.sessionStartInfo = new SessionStartInfo(this.getAgentId(), this.appName, null, this.testName, testBatch, appEnv, this.matchLevel, this.branchName, this.parentBranchName);
        Logger.verbose("startSession(): Starting server session...");
        this.runningSession = this.agentConnector.startSession(this.sessionStartInfo);
        Logger.verbose("startSession(): Server session ID is " + this.runningSession.getId());
        String testInfo = "'" + this.testName + "' of '" + this.appName + "' " + appEnv;
        if (this.runningSession.getIsNewSession()) {
            Logger.log("--- New test started - " + testInfo);
        } else {
            Logger.log("--- Test started - " + testInfo);
        }
    }
}

