/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ProxySettings;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RestClient {
    protected final Client restClient;
    protected final URI serverUri;
    protected WebTarget endPoint;
    protected ObjectMapper jsonMapper;

    public RestClient(URI serverUri, int timeout, ProxySettings proxySettings) {
        ArgumentGuard.notNull(serverUri, "serverUri");
        ArgumentGuard.greaterThanOrEqualToZero(timeout, "timeout");
        this.jsonMapper = new ObjectMapper();
        ClientConfig cc = new ClientConfig();
        cc.property("jersey.config.client.connectTimeout", (Object)timeout);
        cc.property("jersey.config.client.readTimeout", (Object)timeout);
        if (proxySettings != null) {
            cc = cc.property("jersey.config.client.proxy.uri", (Object)proxySettings.getUri());
            if (proxySettings.getUsername() != null) {
                cc = cc.property("jersey.config.client.proxy.username", (Object)proxySettings.getUsername());
            }
            if (proxySettings.getPassword() != null) {
                cc = cc.property("jersey.config.client.proxy.password", (Object)proxySettings.getPassword());
            }
        }
        cc.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        cc.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        this.restClient = ClientBuilder.newBuilder().withConfig((Configuration)cc).build();
        this.endPoint = this.restClient.target(serverUri);
        this.serverUri = serverUri;
    }

    public RestClient(URI serverUri) {
        this(serverUri, 300000, null);
    }

    protected Response sendLongRequest(HttpMethodCall method, String name) throws EyesException {
        int maxDelay = 10000;
        int delay = 2000;
        Response response;
        while ((response = method.call()).getStatus() == 202) {
            Logger.verbose(String.format("%s: Still running... Retrying in %d ms", name, delay));
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new EyesException("Long request interrupted!", e);
            }
            delay = Math.min(maxDelay, (int)Math.floor((double)delay * 1.5));
        }
        return response;
    }

    protected String getReadResponseError(String errMsg, int statusCode, String statusPhrase, String responseBody) {
        ArgumentGuard.notNull(statusPhrase, "statusPhrase");
        if (errMsg == null) {
            errMsg = "";
        }
        if (responseBody == null) {
            responseBody = "";
        }
        return errMsg + " [" + statusCode + " " + statusPhrase + "] " + responseBody;
    }

    protected <T> T parseResponseWithJsonData(Response response, List<Integer> validHttpStatusCodes, Class<T> resultType) throws EyesException {
        Object resultObject;
        ArgumentGuard.notNull(response, "response");
        ArgumentGuard.notNull(validHttpStatusCodes, "validHttpStatusCodes");
        ArgumentGuard.notNull(resultType, "resultType");
        int statusCode = response.getStatus();
        String statusPhrase = response.getStatusInfo().getReasonPhrase();
        String data = (String)response.readEntity(String.class);
        if (!validHttpStatusCodes.contains(statusCode)) {
            String errorMessage = this.getReadResponseError("Invalid status code", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage);
        }
        try {
            resultObject = this.jsonMapper.readValue(data, resultType);
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed to deserialize response body", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage, e);
        }
        return (T)resultObject;
    }

    protected static interface HttpMethodCall {
        public Response call();
    }
}

