/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.IgnoreRegionByRectangle;
import java.util.ArrayList;
import java.util.List;

public class CheckSettings
implements ICheckSettings,
ICheckSettingsInternal {
    private Region targetRegion;
    private MatchLevel matchLevel = null;
    private Boolean ignoreCaret = null;
    private boolean stitchContent = false;
    private List<GetRegion> ignoreRegions = new ArrayList<GetRegion>();
    private List<GetRegion> layoutRegions = new ArrayList<GetRegion>();
    private List<GetRegion> strictRegions = new ArrayList<GetRegion>();
    private List<GetRegion> contentRegions = new ArrayList<GetRegion>();
    private List<GetFloatingRegion> floatingRegions = new ArrayList<GetFloatingRegion>();
    private int timeout = -1;
    private String name;

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(int timeout) {
        this.timeout = timeout;
    }

    protected void ignore_(Region region) {
        this.ignore_(new IgnoreRegionByRectangle(region));
    }

    protected void ignore_(GetRegion regionProvider) {
        this.ignoreRegions.add(regionProvider);
    }

    protected void layout_(Region region) {
        this.layout_(new IgnoreRegionByRectangle(region));
    }

    protected void layout_(GetRegion regionProvider) {
        this.layoutRegions.add(regionProvider);
    }

    protected void content_(Region region) {
        this.content_(new IgnoreRegionByRectangle(region));
    }

    protected void content_(GetRegion regionProvider) {
        this.contentRegions.add(regionProvider);
    }

    protected void strict_(Region region) {
        this.strict_(new IgnoreRegionByRectangle(region));
    }

    protected void strict_(GetRegion regionProvider) {
        this.strictRegions.add(regionProvider);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    protected void floating(GetFloatingRegion regionProvider) {
        this.floatingRegions.add(regionProvider);
    }

    public CheckSettings clone() {
        CheckSettings clone = new CheckSettings();
        this.populateClone(clone);
        return clone;
    }

    @Override
    public ICheckSettings ignore(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.ignore_(region);
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings layout(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.layout_(region);
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings strict(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.strict_(region);
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings content(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.content_(region);
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings fully() {
        CheckSettings clone = this.clone();
        clone.stitchContent = true;
        return clone;
    }

    @Override
    public ICheckSettings fully(boolean fully) {
        CheckSettings clone = this.clone();
        clone.stitchContent = fully;
        return clone;
    }

    @Override
    public ICheckSettings floating(int maxOffset, Region ... regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return clone;
    }

    @Override
    public ICheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        CheckSettings clone = this.clone();
        clone.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return clone;
    }

    @Override
    public ICheckSettings timeout(int timeoutMilliseconds) {
        CheckSettings clone = this.clone();
        clone.timeout = timeoutMilliseconds;
        return clone;
    }

    @Override
    public ICheckSettings layout() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.LAYOUT;
        return clone;
    }

    @Override
    public ICheckSettings exact() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.EXACT;
        return clone;
    }

    @Override
    public ICheckSettings strict() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.STRICT;
        return clone;
    }

    @Override
    public ICheckSettings content() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.CONTENT;
        return clone;
    }

    @Override
    public ICheckSettings matchLevel(MatchLevel matchLevel) {
        CheckSettings clone = this.clone();
        clone.matchLevel = matchLevel;
        return clone;
    }

    @Override
    public ICheckSettings ignoreCaret(boolean ignoreCaret) {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = ignoreCaret;
        return clone;
    }

    @Override
    public ICheckSettings ignoreCaret() {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = true;
        return clone;
    }

    @Override
    public ICheckSettings withName(String name) {
        CheckSettings clone = this.clone();
        clone.name = name;
        return clone;
    }

    @Override
    public Region getTargetRegion() {
        return this.targetRegion;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean getStitchContent() {
        return this.stitchContent;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public GetRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getStrictRegions() {
        return this.strictRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getLayoutRegions() {
        return this.layoutRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getContentRegions() {
        return this.contentRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetFloatingRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetFloatingRegion[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }

    protected void populateClone(CheckSettings clone) {
        clone.targetRegion = this.targetRegion;
        clone.matchLevel = this.matchLevel;
        clone.stitchContent = this.stitchContent;
        clone.timeout = this.timeout;
        clone.ignoreCaret = this.ignoreCaret;
        clone.name = this.name;
        clone.ignoreRegions.addAll(this.ignoreRegions);
        clone.contentRegions.addAll(this.contentRegions);
        clone.layoutRegions.addAll(this.layoutRegions);
        clone.strictRegions.addAll(this.strictRegions);
        clone.floatingRegions.addAll(this.floatingRegions);
    }
}

