/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EyesService<INPUT, OUTPUT> {
    protected Logger logger;
    protected ServerConnector serverConnector;
    protected final List<Pair<String, INPUT>> inputQueue = new ArrayList<Pair<String, INPUT>>();
    protected final List<Pair<String, OUTPUT>> outputQueue = Collections.synchronizedList(new ArrayList());
    protected final List<Pair<String, Throwable>> errorQueue = Collections.synchronizedList(new ArrayList());

    public EyesService(Logger logger, ServerConnector serverConnector) {
        this.logger = logger;
        this.serverConnector = serverConnector;
    }

    public void setLogger(Logger logger) {
        this.serverConnector.setLogger(logger);
        this.logger = logger;
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public abstract void run();

    public void addInput(String id, INPUT input) {
        this.inputQueue.add(Pair.of((Object)id, input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, OUTPUT>> getSucceededTasks() {
        List<Pair<String, OUTPUT>> list = this.outputQueue;
        synchronized (list) {
            ArrayList<Pair<String, OUTPUT>> succeededTasks = new ArrayList<Pair<String, OUTPUT>>(this.outputQueue);
            this.outputQueue.clear();
            return succeededTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, Throwable>> getFailedTasks() {
        List<Pair<String, Throwable>> list = this.errorQueue;
        synchronized (list) {
            ArrayList<Pair<String, Throwable>> failedTasks = new ArrayList<Pair<String, Throwable>>(this.errorQueue);
            this.errorQueue.clear();
            return failedTasks;
        }
    }
}

