/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RenderingTask;
import com.applitools.eyes.visualgrid.model.ResourceCollectionTask;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.EyesService;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IRenderingEyes;
import com.applitools.eyes.visualgrid.services.OpenerService;
import com.applitools.eyes.visualgrid.services.RenderingGridService;
import com.applitools.eyes.visualgrid.services.RunnerOptions;
import com.applitools.eyes.visualgrid.services.RunningTest;
import com.applitools.eyes.visualgrid.services.ScoreTask;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class VisualGridRunner
extends EyesRunner {
    private static final int CONCURRENCY_FACTOR = 5;
    static final int DEFAULT_CONCURRENCY = 5;
    final TestConcurrency testConcurrency;
    private boolean wasConcurrencyLogSent = false;
    private OpenerService eyesOpenerService;
    private EyesService eyesCloserService;
    private EyesService eyesCheckerService;
    private EyesService resourceCollectionService;
    private RenderingGridService renderingGridService;
    private final ThreadGroup servicesGroup = new ThreadGroup("Services Group");
    private final List<IRenderingEyes> eyesToOpenList = Collections.synchronizedList(new ArrayList(200));
    final Set<IRenderingEyes> allEyes = Collections.synchronizedSet(new HashSet());
    private final Map<String, RGridResource> resourcesCacheMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, SyncTaskListener<Void>> uploadedResourcesCache = Collections.synchronizedMap(new HashMap());
    private final Object openerServiceConcurrencyLock = new Object();
    private final Object openerServiceLock = new Object();
    private final Object checkerServiceLock = new Object();
    private final Object closerServiceLock = new Object();
    private final Object resourceCollectionServiceLock = new Object();
    private final Object renderingServiceLock = new Object();
    private final List<ResourceCollectionTask> resourceCollectionTaskList = Collections.synchronizedList(new ArrayList());
    private final List<RenderingTask> renderingTaskList = Collections.synchronizedList(new ArrayList());
    private RenderingInfo renderingInfo;
    private IDebugResourceWriter debugResourceWriter;
    private String serverUrl = GeneralUtils.getEnvString((String)"APPLITOOLS_SERVER_URL");
    private static final String DEFAULT_API_KEY = GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY");
    private String apiKey = DEFAULT_API_KEY;
    private boolean isDisabled;
    private boolean isServicesOn = false;
    private String suiteName;
    private final IRenderingEyes.EyesListener eyesListener = new IRenderingEyes.EyesListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskComplete(VisualGridTask visualGridTask, IRenderingEyes eyes) {
            VisualGridRunner.this.logger.verbose("Enter with: " + (Object)((Object)visualGridTask.getType()));
            VisualGridTask.TaskType type = visualGridTask.getType();
            try {
                switch (type) {
                    case OPEN: {
                        VisualGridRunner.this.logger.verbose("locking eyesToOpenList");
                        List list = VisualGridRunner.this.eyesToOpenList;
                        synchronized (list) {
                            VisualGridRunner.this.logger.verbose("removing visualGridTask " + visualGridTask.toString());
                            VisualGridRunner.this.eyesToOpenList.remove(eyes);
                        }
                        VisualGridRunner.this.logger.verbose("releasing eyesToOpenList");
                        break;
                    }
                    case ABORT: {
                        VisualGridRunner.this.logger.verbose("VisualGridTask Abort.");
                    }
                    case CLOSE: {
                        VisualGridRunner.this.logger.verbose("VisualGridTask Close.");
                        VisualGridRunner.this.eyesOpenerService.decrementConcurrency();
                        Object object = VisualGridRunner.this.openerServiceConcurrencyLock;
                        synchronized (object) {
                            VisualGridRunner.this.openerServiceConcurrencyLock.notify();
                        }
                        VisualGridRunner.this.logger.verbose("releasing openerServiceConcurrencyLock");
                        VisualGridRunner.this.logger.verbose("VisualGridTask Close.");
                        break;
                    }
                    case CHECK: {
                        VisualGridRunner.this.logger.verbose("Check complete.");
                    }
                }
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)VisualGridRunner.this.logger, (Throwable)e);
            }
            VisualGridRunner.this.notifyAllServices();
        }

        @Override
        public void onRenderComplete() {
            VisualGridRunner.this.notifyAllServices();
        }
    };

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey != null ? apiKey : DEFAULT_API_KEY;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public boolean isServicesOn() {
        return this.isServicesOn;
    }

    private void setServicesOn(boolean servicesOn) {
        this.isServicesOn = servicesOn;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getOrWaitForTask(Object lock, EyesService.Tasker tasker) {
        FutureTask<TestResultContainer> nextTestToOpen = tasker.getNextTask();
        if (nextTestToOpen == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(500L);
                }
                nextTestToOpen = tasker.getNextTask();
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
        return nextTestToOpen;
    }

    public VisualGridRunner() {
        this(Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(String suiteName) {
        this.testConcurrency = new TestConcurrency();
        this.init(suiteName);
    }

    public VisualGridRunner(int testConcurrency) {
        this(testConcurrency, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(int testConcurrency, String suiteName) {
        this.testConcurrency = new TestConcurrency(testConcurrency, true);
        this.init(suiteName);
    }

    public VisualGridRunner(RunnerOptions runnerOptions) {
        this(runnerOptions, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(RunnerOptions runnerOptions, String suiteName) {
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        this.testConcurrency = new TestConcurrency(testConcurrency, false);
        this.init(suiteName);
    }

    private void init(String suiteName) {
        this.suiteName = suiteName;
        this.logger = new EyesRunner.IdPrintingLogger(suiteName);
        this.logger.log("runner created");
        this.initServices();
        this.startServices();
        this.logger.verbose("rendering grid manager is built");
    }

    public Map<String, RGridResource> getResourcesCacheMap() {
        return this.resourcesCacheMap;
    }

    public Map<String, SyncTaskListener<Void>> getUploadedResourcesCache() {
        return this.uploadedResourcesCache;
    }

    public RenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    private void initServices() {
        this.eyesOpenerService = new OpenerService("eyesOpenerService", this.servicesGroup, this.logger, this.testConcurrency.actualConcurrency, this.openerServiceConcurrencyLock, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.openerServiceLock, tasker);
            }
        }, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextTestToOpen();
            }
        });
        this.eyesCloserService = new EyesService("eyesCloserService", this.servicesGroup, this.logger, this.testConcurrency.actualConcurrency, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.closerServiceLock, tasker);
            }
        }, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextTestToClose();
            }
        });
        this.resourceCollectionService = new EyesService("resourceCollectionService", this.servicesGroup, this.logger, this.testConcurrency.actualConcurrency, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.resourceCollectionServiceLock, tasker);
            }
        }, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextResourceCollectionTask();
            }
        });
        this.renderingGridService = new RenderingGridService("renderingGridService", this.servicesGroup, this.logger, this.testConcurrency.actualConcurrency, new RenderingGridService.RGServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RenderingTask getNextTask() {
                RenderingTask nextTestToRender = VisualGridRunner.this.getNextRenderingTask();
                if (nextTestToRender == null) {
                    Object object = VisualGridRunner.this.renderingServiceLock;
                    synchronized (object) {
                        try {
                            nextTestToRender = VisualGridRunner.this.getNextRenderingTask();
                            if (nextTestToRender == null) {
                                VisualGridRunner.this.renderingServiceLock.wait(500L);
                                nextTestToRender = VisualGridRunner.this.getNextRenderingTask();
                            }
                        }
                        catch (Exception e) {
                            GeneralUtils.logExceptionStackTrace((Logger)VisualGridRunner.this.logger, (Throwable)e);
                        }
                    }
                }
                return nextTestToRender;
            }
        });
        this.eyesCheckerService = new EyesService("eyesCheckerService", this.servicesGroup, this.logger, this.testConcurrency.actualConcurrency, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.checkerServiceLock, tasker);
            }
        }, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextCheckTask();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getNextCheckTask() {
        VisualGridTask visualGridTask;
        try {
            ScoreTask bestScoreTask = null;
            int bestScore = -1;
            Set<IRenderingEyes> set = this.allEyes;
            synchronized (set) {
                for (IRenderingEyes eyes : this.allEyes) {
                    int currentTestMark;
                    ScoreTask currentScoreTask = eyes.getBestScoreTaskForCheck();
                    if (currentScoreTask == null || bestScore >= (currentTestMark = currentScoreTask.getScore())) continue;
                    bestScoreTask = currentScoreTask;
                    bestScore = currentTestMark;
                }
            }
            if (bestScoreTask == null) {
                return null;
            }
            visualGridTask = bestScoreTask.getVisualGridTask();
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            return null;
        }
        return new FutureTask<TestResultContainer>(visualGridTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getNextResourceCollectionTask() {
        List<ResourceCollectionTask> list = this.resourceCollectionTaskList;
        synchronized (list) {
            if (this.resourceCollectionTaskList.isEmpty()) {
                return null;
            }
            ResourceCollectionTask resourceCollectionTask = this.resourceCollectionTaskList.get(0);
            this.resourceCollectionTaskList.remove(resourceCollectionTask);
            return new FutureTask<TestResultContainer>(resourceCollectionTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderingTask getNextRenderingTask() {
        List<RenderingTask> list = this.renderingTaskList;
        synchronized (list) {
            if (this.renderingTaskList.isEmpty()) {
                return null;
            }
            RenderingTask finalRenderingTask = null;
            ArrayList<RenderingTask> chosenTasks = new ArrayList<RenderingTask>();
            for (RenderingTask renderingTask : this.renderingTaskList) {
                if (!renderingTask.isReady()) continue;
                if (finalRenderingTask == null) {
                    finalRenderingTask = renderingTask;
                } else {
                    finalRenderingTask.merge(renderingTask);
                }
                chosenTasks.add(renderingTask);
            }
            RenderingTask renderingTask = finalRenderingTask = finalRenderingTask != null && finalRenderingTask.isReady() ? finalRenderingTask : null;
            if (finalRenderingTask != null) {
                this.logger.verbose(String.format("Next rendering task contains %d render requests", chosenTasks.size()));
                this.renderingTaskList.removeAll(chosenTasks);
            }
            return finalRenderingTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getNextTestToClose() {
        Set<IRenderingEyes> set = this.allEyes;
        synchronized (set) {
            for (IRenderingEyes eyes : this.allEyes) {
                RunningTest runningTest = eyes.getNextTestToClose();
                if (runningTest == null) continue;
                return runningTest.getNextCloseTask();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FutureTask<TestResultContainer> getNextTestToOpen() {
        ScoreTask bestScoreTask = null;
        int bestMark = -1;
        Set<IRenderingEyes> set = this.allEyes;
        synchronized (set) {
            for (IRenderingEyes eyes : this.allEyes) {
                if (!eyes.isServerConcurrencyLimitReached()) continue;
                return null;
            }
            for (IRenderingEyes eyes : this.allEyes) {
                int currentScore;
                ScoreTask currentTestMark = null;
                try {
                    currentTestMark = eyes.getBestScoreTaskForOpen();
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                }
                if (currentTestMark == null || bestMark >= (currentScore = currentTestMark.getScore())) continue;
                bestMark = currentScore;
                bestScoreTask = currentTestMark;
            }
        }
        if (bestScoreTask == null) {
            return null;
        }
        this.logger.verbose("found test with mark " + bestMark);
        this.logger.verbose("calling getNextOpenTaskAndRemove on " + bestScoreTask.toString());
        VisualGridTask nextOpenVisualGridTask = bestScoreTask.getVisualGridTask();
        this.logger.verbose(String.format("Found open task for test %s", nextOpenVisualGridTask.getRunningTest().getTestName()));
        return new FutureTask<TestResultContainer>(nextOpenVisualGridTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IRenderingEyes eyes, RenderingInfo renderingInfo) {
        this.logger.verbose("enter");
        if (this.renderingInfo == null) {
            this.renderingInfo = renderingInfo;
        }
        Collection<IRenderingEyes> collection = this.eyesToOpenList;
        synchronized (collection) {
            this.eyesToOpenList.add(eyes);
        }
        if (this.allEyes.isEmpty()) {
            this.setLogger(eyes.getLogger());
        }
        collection = this.allEyes;
        synchronized (collection) {
            this.allEyes.add(eyes);
        }
        this.logger.verbose("releasing allEyes");
        eyes.setListener(this.eyesListener);
        this.logger.verbose("concurrencyLock.notify()");
        this.addBatch(eyes.getBatchId(), eyes.getBatchCloser());
    }

    private void startServices() {
        this.logger.verbose("enter");
        this.setServicesOn(true);
        this.servicesGroup.setDaemon(true);
        this.eyesOpenerService.start();
        this.eyesCloserService.start();
        this.resourceCollectionService.start();
        this.renderingGridService.start();
        this.eyesCheckerService.start();
        this.logger.verbose("exit");
    }

    private void stopServices() {
        this.logger.verbose("enter");
        this.setServicesOn(false);
        this.eyesOpenerService.stopService();
        this.eyesCloserService.stopService();
        this.resourceCollectionService.stopService();
        this.renderingGridService.stopService();
        this.eyesCheckerService.stopService();
        this.logger.verbose("exit");
    }

    @Override
    public TestResultsSummary getAllTestResultsImpl() {
        return this.getAllTestResults(true);
    }

    @Override
    public TestResultsSummary getAllTestResultsImpl(boolean throwException) {
        this.logger.log("enter");
        HashMap<IRenderingEyes, Collection<Future<TestResultContainer>>> allFutures = new HashMap<IRenderingEyes, Collection<Future<TestResultContainer>>>();
        for (IRenderingEyes eyes : this.allEyes) {
            Collection<Future<TestResultContainer>> futureList = eyes.close();
            Collection futures = (Collection)allFutures.get(eyes);
            if (futures != null && !futures.isEmpty()) {
                futureList.addAll(futures);
            }
            allFutures.put(eyes, futureList);
        }
        Throwable exception = null;
        this.notifyAllServices();
        ArrayList<TestResultContainer> allResults = new ArrayList<TestResultContainer>();
        this.logger.verbose("trying to call future.get on " + allFutures.size() + " future lists.");
        for (Map.Entry entry : allFutures.entrySet()) {
            Collection value = (Collection)entry.getValue();
            IRenderingEyes key = (IRenderingEyes)entry.getKey();
            key.getAllTestResults().clear();
            this.logger.verbose("trying to call future.get on " + value.size() + " futures of " + key);
            for (Future future : value) {
                TestResultContainer obj;
                block8: {
                    this.logger.log("calling future.get on " + key);
                    obj = null;
                    try {
                        obj = (TestResultContainer)future.get(10L, TimeUnit.MINUTES);
                        if (obj.getException() != null && exception == null) {
                            exception = obj.getException();
                        }
                    }
                    catch (Throwable e) {
                        GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                        if (exception != null) break block8;
                        exception = e;
                    }
                }
                this.logger.log("got TestResultContainer: " + obj);
                allResults.add(obj);
                key.getAllTestResults().add(obj);
            }
        }
        this.stopServices();
        this.notifyAllServices();
        this.logger.log("exit");
        if (throwException && exception != null) {
            throw new Error(exception);
        }
        return new TestResultsSummary(allResults);
    }

    public void close(IRenderingEyes eyes) {
        this.logger.verbose("adding eyes to close list: " + eyes);
        this.notifyAllServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void check(ICheckSettings settings, IDebugResourceWriter debugResourceWriter, FrameData domData, IEyesConnector connector, List<VisualGridTask> checkVisualGridTasks, List<VisualGridSelector[]> selectors, UserAgent userAgent) {
        if (debugResourceWriter == null) {
            debugResourceWriter = this.debugResourceWriter;
        }
        if (debugResourceWriter == null) {
            debugResourceWriter = new NullDebugResourceWriter();
        }
        TaskListener<List<RenderingTask>> listener = new TaskListener<List<RenderingTask>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(List<RenderingTask> renderingTasks) {
                VisualGridRunner.this.logger.verbose("locking renderingTaskList");
                List list = VisualGridRunner.this.renderingTaskList;
                synchronized (list) {
                    VisualGridRunner.this.renderingTaskList.addAll(renderingTasks);
                }
                VisualGridRunner.this.logger.verbose("releasing renderingTaskList");
                VisualGridRunner.this.notifyAllServices();
            }

            public void onFail() {
                VisualGridRunner.this.notifyAllServices();
            }
        };
        ResourceCollectionTask resourceCollectionTask = new ResourceCollectionTask(this, connector, domData, userAgent, selectors, settings, checkVisualGridTasks, debugResourceWriter, listener, new RenderingTask.RenderTaskListener(){

            @Override
            public void onRenderSuccess() {
                VisualGridRunner.this.logger.verbose("enter");
                VisualGridRunner.this.notifyAllServices();
                VisualGridRunner.this.logger.verbose("exit");
            }

            @Override
            public void onRenderFailed(Exception e) {
                VisualGridRunner.this.notifyAllServices();
                GeneralUtils.logExceptionStackTrace((Logger)VisualGridRunner.this.logger, (Throwable)e);
            }
        });
        List<ResourceCollectionTask> list = this.resourceCollectionTaskList;
        synchronized (list) {
            this.resourceCollectionTaskList.add(resourceCollectionTask);
        }
        this.notifyAllServices();
    }

    private void notifyAllServices() {
        this.logger.verbose("enter");
        this.notifyOpenerService();
        this.notifyCloserService();
        this.notifyCheckerService();
        this.notifyRenderingService();
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRenderingService() {
        this.logger.verbose("trying to notify rendering service");
        Object object = this.renderingServiceLock;
        synchronized (object) {
            this.renderingServiceLock.notify();
        }
        this.logger.verbose("renderingLockFree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloserService() {
        this.logger.verbose("trying to notify closer service");
        Object object = this.closerServiceLock;
        synchronized (object) {
            this.closerServiceLock.notifyAll();
        }
        this.logger.verbose("closerLockFree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOpenerService() {
        this.logger.verbose("trying to notify opener service");
        Object object = this.openerServiceLock;
        synchronized (object) {
            this.openerServiceLock.notifyAll();
            this.logger.verbose("openerLockFree");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCheckerService() {
        this.logger.verbose("trying to notify checker service");
        Object object = this.checkerServiceLock;
        synchronized (object) {
            this.checkerServiceLock.notifyAll();
            this.logger.verbose("checkerLockFree");
        }
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter;
    }

    public IDebugResourceWriter getDebugResourceWriter() {
        return this.debugResourceWriter;
    }

    public void setLogger(Logger logger) {
        this.eyesCheckerService.setLogger(logger);
        this.eyesCloserService.setLogger(logger);
        this.eyesOpenerService.setLogger(logger);
        this.resourceCollectionService.setLogger(logger);
        this.renderingGridService.setLogger(logger);
        if (this.logger == null) {
            this.logger = logger;
        } else {
            this.logger.setLogHandler(logger.getLogHandler());
        }
    }

    public String getConcurrencyLog() throws JsonProcessingException {
        if (this.wasConcurrencyLogSent) {
            return null;
        }
        this.wasConcurrencyLogSent = true;
        String key = this.testConcurrency.isDefault ? "defaultConcurrency" : (this.testConcurrency.isLegacy ? "concurrency" : "testConcurrency");
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("type", "runnerStarted");
        objectNode.put(key, this.testConcurrency.userConcurrency);
        return objectMapper.writeValueAsString((Object)objectNode);
    }

    static class TestConcurrency {
        final int userConcurrency;
        final int actualConcurrency;
        final boolean isLegacy;
        boolean isDefault = false;

        TestConcurrency() {
            this.isDefault = true;
            this.isLegacy = false;
            this.userConcurrency = 5;
            this.actualConcurrency = 5;
        }

        TestConcurrency(int userConcurrency, boolean isLegacy) {
            this.userConcurrency = userConcurrency;
            this.actualConcurrency = isLegacy ? userConcurrency * 5 : userConcurrency;
            this.isLegacy = isLegacy;
        }
    }
}

