/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IRenderingEyes;
import com.applitools.eyes.visualgrid.services.ScoreTask;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class RunningTest {
    static final int PARALLEL_STEPS_LIMIT = 1;
    private final List<VisualGridTask> visualGridTaskList = Collections.synchronizedList(new ArrayList());
    private IRenderingEyes eyes;
    private IEyesConnector eyesConnector;
    private final RenderBrowserInfo browserInfo;
    private final AtomicBoolean isTestOpen = new AtomicBoolean(false);
    private final AtomicBoolean isTestClose = new AtomicBoolean(false);
    private final AtomicBoolean isTestInExceptionMode = new AtomicBoolean(false);
    private IRenderingEyes.EyesListener listener;
    private ConfigurationProvider configurationProvider;
    private final HashMap<VisualGridTask, FutureTask<TestResultContainer>> taskToFutureMapping = new HashMap();
    private final Logger logger;
    private final AtomicBoolean isCloseTaskIssued = new AtomicBoolean(false);
    private VisualGridTask closeTask;
    private VisualGridTask openTask;
    private String appName;
    private String testName;
    private final VisualGridTask.VGTaskListener taskListener = new VisualGridTask.VGTaskListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskComplete(VisualGridTask visualGridTask) {
            RunningTest.this.logger.verbose("locking runningTest.visualGridTaskList");
            List list = RunningTest.this.visualGridTaskList;
            synchronized (list) {
                RunningTest.this.visualGridTaskList.remove(visualGridTask);
            }
            RunningTest.this.logger.verbose("releasing runningTest.visualGridTaskList");
            switch (visualGridTask.getType()) {
                case OPEN: {
                    RunningTest.this.isTestOpen.set(true);
                    break;
                }
                case CLOSE: 
                case ABORT: {
                    RunningTest.this.isTestClose.set(true);
                }
            }
            if (RunningTest.this.listener != null) {
                RunningTest.this.listener.onTaskComplete(visualGridTask, RunningTest.this.eyes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskFailed(Throwable e, VisualGridTask visualGridTask) {
            List list = RunningTest.this.visualGridTaskList;
            synchronized (list) {
                RunningTest.this.visualGridTaskList.remove(visualGridTask);
            }
            RunningTest.this.setTestInExceptionMode(e);
            RunningTest.this.listener.onTaskComplete(visualGridTask, RunningTest.this.eyes);
        }

        @Override
        public void onRenderComplete() {
            RunningTest.this.logger.verbose("enter");
            RunningTest.this.listener.onRenderComplete();
            RunningTest.this.logger.verbose("exit");
        }
    };

    public void setCloseTask(VisualGridTask task) {
        this.closeTask = task;
    }

    public VisualGridTask getCloseTask() {
        return this.closeTask;
    }

    public void setOpenTask(VisualGridTask task) {
        this.openTask = task;
    }

    public RunningTest(RenderBrowserInfo browserInfo, Logger logger) {
        this.browserInfo = browserInfo;
        this.logger = logger;
    }

    public RunningTest(RenderBrowserInfo browserInfo, Logger logger, ConfigurationProvider configurationProvider) {
        this.browserInfo = browserInfo;
        this.configurationProvider = configurationProvider;
        this.logger = logger;
    }

    public RunningTest(IRenderingEyes eyes, IEyesConnector eyesConnector, ConfigurationProvider configurationProvider, RenderBrowserInfo browserInfo, Logger logger) {
        this.eyes = eyes;
        this.eyesConnector = eyesConnector;
        this.browserInfo = browserInfo;
        this.configurationProvider = configurationProvider;
        this.logger = logger;
        this.appName = configurationProvider.get().getAppName();
        this.testName = configurationProvider.get().getTestName();
    }

    public Future<TestResultContainer> abort(boolean forceAbort, Throwable e) {
        this.logger.verbose("enter");
        this.logger.verbose(String.format("test info: %s", this.browserInfo));
        if (this.closeTask != null) {
            this.logger.verbose("close task already exists");
            if (forceAbort && this.closeTask.getType() == VisualGridTask.TaskType.CLOSE) {
                this.logger.verbose("force abort");
                this.removeAllCheckTasks();
                this.closeTask.setExceptionAndAbort(e);
            }
            return this.taskToFutureMapping.get(this.closeTask);
        }
        if (this.isOpenTaskIssued()) {
            this.openTask.setException(e);
        }
        this.logger.verbose("close task doesn't exists, aborting the test");
        this.removeAllCheckTasks();
        VisualGridTask abortTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyesConnector, VisualGridTask.TaskType.ABORT, this.taskListener, null, this, null, null);
        this.visualGridTaskList.add(abortTask);
        this.closeTask = abortTask;
        FutureTask<TestResultContainer> futureTask = new FutureTask<TestResultContainer>(abortTask);
        this.taskToFutureMapping.put(abortTask, futureTask);
        this.isCloseTaskIssued.set(true);
        return this.taskToFutureMapping.get(this.closeTask);
    }

    public IBatchCloser getBatchCloser() {
        return (IBatchCloser)((Object)this.eyesConnector);
    }

    private void removeAllCheckTasks() {
        this.logger.verbose("enter");
        Iterator<VisualGridTask> iterator = this.visualGridTaskList.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            VisualGridTask next = iterator.next();
            if (next.getType() != VisualGridTask.TaskType.CHECK) continue;
            ++counter;
            iterator.remove();
        }
        this.logger.verbose("removed " + counter + " CHECK tasks from test");
    }

    public boolean isCloseTaskIssued() {
        return this.closeTask != null;
    }

    public boolean isTestOpen() {
        return this.isTestOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckTaskReadyForRender(VisualGridTask checkTask) {
        if (!this.isTestOpen()) {
            return false;
        }
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            int notRenderedStepsCount = 0;
            for (VisualGridTask task : this.visualGridTaskList) {
                if (task.equals(checkTask)) break;
                if (task.isTaskReadyToCheck()) continue;
                ++notRenderedStepsCount;
            }
            return notRenderedStepsCount < 1;
        }
    }

    public List<VisualGridTask> getVisualGridTaskList() {
        return this.visualGridTaskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoreTask getScoreTaskObjectByType(VisualGridTask.TaskType taskType) {
        if (!this.isTestOpen.get() && taskType == VisualGridTask.TaskType.CHECK) {
            return null;
        }
        int score = 0;
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            if (this.visualGridTaskList.isEmpty()) {
                return null;
            }
            for (VisualGridTask visualGridTask : this.visualGridTaskList) {
                if (!visualGridTask.wasRenderTaskCreated() || visualGridTask.getType() != VisualGridTask.TaskType.CHECK) continue;
                ++score;
            }
            VisualGridTask chosenVisualGridTask = this.visualGridTaskList.get(0);
            if (chosenVisualGridTask.getType() != taskType || chosenVisualGridTask.isSent()) {
                return null;
            }
            return new ScoreTask(chosenVisualGridTask, score);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FutureTask<TestResultContainer> getNextCloseTask() {
        this.logger.verbose("enter");
        if (this.visualGridTaskList.isEmpty() || !this.isCloseTaskIssued.get()) {
            this.logger.verbose("exit with null");
            return null;
        }
        VisualGridTask visualGridTask = this.visualGridTaskList.get(0);
        VisualGridTask.TaskType type = visualGridTask.getType();
        if (type != VisualGridTask.TaskType.CLOSE && type != VisualGridTask.TaskType.ABORT) {
            return null;
        }
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.logger.verbose("removing visualGridTask " + visualGridTask.toString() + " and exiting");
            this.visualGridTaskList.remove(visualGridTask);
            this.logger.verbose("tasks in visualGridTaskList: " + this.visualGridTaskList.size());
        }
        this.logger.verbose("releasing visualGridTaskList");
        return this.taskToFutureMapping.get(visualGridTask);
    }

    public RenderBrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualGridTask open() {
        VisualGridTask visualGridTask;
        this.logger.verbose(String.format("test info: %s", this.browserInfo));
        this.logger.verbose("adding Open visualGridTask...");
        this.openTask = visualGridTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyesConnector, VisualGridTask.TaskType.OPEN, this.taskListener, null, this, null, null);
        FutureTask<TestResultContainer> futureTask = new FutureTask<TestResultContainer>(visualGridTask);
        this.taskToFutureMapping.put(visualGridTask, futureTask);
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.visualGridTaskList.add(visualGridTask);
            this.logger.verbose("Open visualGridTask was added: " + visualGridTask.toString());
            this.logVGTasksList(this.visualGridTaskList);
        }
        this.logger.verbose("releasing visualGridTaskList");
        return visualGridTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureTask<TestResultContainer> close() {
        this.logger.verbose(String.format("test info: %s", this.browserInfo));
        if (!this.visualGridTaskList.isEmpty()) {
            this.logger.verbose("visual grid tasks list not empty");
            VisualGridTask lastVisualGridTask = this.visualGridTaskList.get(this.visualGridTaskList.size() - 1);
            VisualGridTask.TaskType type = lastVisualGridTask.getType();
            if (type == VisualGridTask.TaskType.CLOSE || type == VisualGridTask.TaskType.ABORT) {
                this.closeTask = lastVisualGridTask;
                this.logger.verbose("returning last task future (type of task: " + (Object)((Object)type) + ")");
                return this.taskToFutureMapping.get(lastVisualGridTask);
            }
        } else {
            if (this.closeTask != null) {
                this.logger.verbose("returning future of close task");
                return this.taskToFutureMapping.get(this.closeTask);
            }
            this.logger.verbose("task list is empty and close task doesn't exist");
            if (!this.isTestOpen()) {
                this.logger.verbose("test never opened, returning null");
                return null;
            }
        }
        this.logger.verbose("adding close visualGridTask...");
        VisualGridTask visualGridTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyesConnector, VisualGridTask.TaskType.CLOSE, this.taskListener, null, this, null, null);
        FutureTask<TestResultContainer> futureTask = new FutureTask<TestResultContainer>(visualGridTask);
        this.closeTask = visualGridTask;
        this.isCloseTaskIssued.set(true);
        this.taskToFutureMapping.put(visualGridTask, futureTask);
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.visualGridTaskList.add(visualGridTask);
            this.logger.verbose("Close visualGridTask was added: " + visualGridTask.toString());
            this.logVGTasksList(this.visualGridTaskList);
        }
        this.logger.verbose("releasing visualGridTaskList");
        return this.taskToFutureMapping.get(visualGridTask);
    }

    private void logVGTasksList(List<VisualGridTask> visualGridTaskList) {
        this.logger.verbose("tasks in visualGridTaskList: " + visualGridTaskList.size());
        if (visualGridTaskList.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (VisualGridTask vgt : visualGridTaskList) {
                sb.append((Object)vgt.getType()).append(" ; ");
            }
            this.logger.verbose(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualGridTask check(ICheckSettings checkSettings, List<VisualGridSelector[]> regionSelectors, String source) {
        this.logger.verbose(String.format("test info: %s", this.browserInfo));
        this.logger.verbose("adding check visualGridTask...");
        VisualGridTask visualGridTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyesConnector, VisualGridTask.TaskType.CHECK, this.taskListener, checkSettings, this, regionSelectors, source);
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.visualGridTaskList.add(visualGridTask);
            this.logger.verbose("Check VisualGridTask was added: " + visualGridTask.toString());
            this.logVGTasksList(this.visualGridTaskList);
        }
        this.logger.verbose("releasing visualGridTaskList");
        this.taskToFutureMapping.get(visualGridTask);
        return visualGridTask;
    }

    public boolean isTestReadyToClose() {
        if (this.visualGridTaskList.size() != 1) {
            return false;
        }
        for (VisualGridTask visualGridTask : this.visualGridTaskList) {
            if (visualGridTask.getType() != VisualGridTask.TaskType.CLOSE && visualGridTask.getType() != VisualGridTask.TaskType.ABORT) continue;
            return true;
        }
        return false;
    }

    public boolean isTestClose() {
        return this.isTestClose.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestInExceptionMode(Throwable e) {
        this.isTestInExceptionMode.set(true);
        if (this.closeTask != null) {
            this.logger.verbose("locking visualGridTaskList.");
            List<VisualGridTask> list = this.visualGridTaskList;
            synchronized (list) {
                this.removeAllCheckTasks();
                if (this.closeTask != null) {
                    if (!this.visualGridTaskList.contains(this.closeTask)) {
                        this.visualGridTaskList.add(this.closeTask);
                    }
                    this.closeTask.setExceptionAndAbort(e);
                }
            }
        }
        if (this.openTask != null) {
            this.openTask.setExceptionAndAbort(e);
        }
        this.logger.verbose("releasing visualGridTaskList.");
    }

    Logger getLogger() {
        return this.logger;
    }

    public boolean isOpenTaskIssued() {
        return this.openTask != null;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setListener(IRenderingEyes.EyesListener eyesListener) {
        this.listener = eyesListener;
    }

    public boolean isServerConcurrencyLimitReached() {
        return this.eyesConnector.isServerConcurrencyLimitReached();
    }
}

