/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.visualgrid.services.EyesService;
import com.applitools.utils.GeneralUtils;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;

public class OpenerService
extends EyesService {
    private final AtomicInteger currentTestAmount = new AtomicInteger();
    private final Object concurrencyLock;

    public OpenerService(String serviceName, ThreadGroup servicesGroup, Logger logger, int testsPoolSize, Object openerServiceLock, EyesService.EyesServiceListener listener, EyesService.Tasker tasker) {
        super(serviceName, servicesGroup, logger, testsPoolSize, listener, tasker);
        this.concurrencyLock = openerServiceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runNextTask() {
        if (!this.isServiceOn) {
            return;
        }
        if (this.eyesConcurrency > this.currentTestAmount.get()) {
            FutureTask<TestResultContainer> task = this.listener.getNextTask(this.tasker);
            if (task != null) {
                this.currentTestAmount.incrementAndGet();
                this.logger.log(String.format("A new test was added. Current amount of tests: %d", this.currentTestAmount.get()));
                this.executor.submit(task);
            }
        } else {
            Object object = this.concurrencyLock;
            synchronized (object) {
                try {
                    this.logger.verbose("Waiting for concurrency to be free");
                    this.concurrencyLock.wait();
                    this.logger.verbose("concurrency free");
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                }
            }
        }
    }

    @Override
    void stopService() {
        this.logger.verbose("concurrency on stop = " + this.currentTestAmount);
        super.stopService();
    }

    public synchronized int decrementConcurrency() {
        int currentAmount = this.currentTestAmount.decrementAndGet();
        this.logger.log(String.format("A test was ended. Current running tests: %d", currentAmount));
        return currentAmount;
    }
}

