/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.connectivity.ServerConnector;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.logging.ClientEvent;
import com.applitools.eyes.logging.LogSessionsClientEvents;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.util.Calendar;
import java.util.TimeZone;

public class NetworkLogHandler
extends LogHandler {
    private static final int MAX_EVENTS_SIZE = 100;
    private final ServerConnector serverConnector;
    final LogSessionsClientEvents clientEvents;

    protected NetworkLogHandler(ServerConnector serverConnector) {
        super(true);
        ArgumentGuard.notNull((Object)((Object)serverConnector), (String)"serverConnector");
        this.serverConnector = serverConnector;
        this.clientEvents = new LogSessionsClientEvents();
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(TraceLevel level, String message) {
        LogSessionsClientEvents logSessionsClientEvents = this.clientEvents;
        synchronized (logSessionsClientEvents) {
            String currentTime = GeneralUtils.toISO8601DateTime((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            ClientEvent event = new ClientEvent(currentTime, message, level);
            this.clientEvents.addEvent(event);
            if (this.clientEvents.size() >= 100) {
                this.sendLogs();
            }
        }
    }

    public void onMessage(String message) {
    }

    public void close() {
        this.sendLogs();
    }

    public boolean isOpen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogs() {
        LogSessionsClientEvents logSessionsClientEvents = this.clientEvents;
        synchronized (logSessionsClientEvents) {
            if (this.clientEvents.size() == 0) {
                return;
            }
            final SyncTaskListener listener = new SyncTaskListener(null, "sendLogs");
            this.serverConnector.sendLogs(new AsyncRequestCallback(){

                public void onComplete(Response response) {
                    if (response.getStatusCode() != 200) {
                        System.out.printf("Failed sending logs. Status code %d%n", response.getStatusCode());
                    }
                    listener.onComplete(null);
                }

                public void onFail(Throwable throwable) {
                    System.out.printf("Failed sending logs: %s%n", throwable);
                    listener.onComplete(null);
                }
            }, this.clientEvents);
            listener.get();
            this.clientEvents.clear();
        }
    }

    public static void sendSingleLog(ServerConnector serverConnector, TraceLevel level, String message) {
        NetworkLogHandler logHandler = new NetworkLogHandler(serverConnector);
        logHandler.onMessage(level, message);
        logHandler.close();
    }
}

