/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.logging.TraceLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiLogHandler
extends LogHandler {
    private final List<LogHandler> logHandlers = new ArrayList<LogHandler>();

    public MultiLogHandler(LogHandler ... logHandlers) {
        super(true);
        this.logHandlers.addAll(Arrays.asList(logHandlers));
    }

    public void open() {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.open();
        }
    }

    public void onMessage(TraceLevel level, String message) {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.onMessage(level, message);
        }
    }

    public void onMessage(String message) {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.onMessage(message);
        }
    }

    public void close() {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.close();
        }
    }

    public boolean isOpen() {
        return true;
    }

    public void addLogHandler(LogHandler logHandler) {
        this.logHandlers.add(logHandler);
    }
}

