/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.ICheckSettings;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.MobileDeviceInfo;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.events.SessionEventHandlers;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.positioning.InvalidPositionProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.scaling.FixedScaleProvider;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.eyes.triggers.TextTrigger;
import com.applitools.eyes.visualgrid.model.DeviceSize;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class EyesBase
implements IEyesBase {
    protected static final int USE_DEFAULT_TIMEOUT = -1;
    private static final int TIME_TO_WAIT_FOR_OPEN = 3600000;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private MatchWindowTask matchWindowTask;
    protected ServerConnector serverConnector;
    protected RunningSession runningSession;
    protected SessionStartInfo sessionStartInfo;
    protected EyesScreenshot lastScreenshot;
    protected PropertyHandler<ScaleProvider> scaleProviderHandler;
    protected PropertyHandler<CutProvider> cutProviderHandler;
    protected PropertyHandler<PositionProvider> positionProviderHandler;
    private boolean isScaleProviderSetByUser = false;
    private boolean isDisabled;
    protected Logger logger;
    protected boolean isOpen;
    private boolean isServerConcurrencyLimitReached = false;
    private final Queue<Trigger> userInputs;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private boolean isViewportSizeSet;
    private int validationId;
    private final SessionEventHandlers sessionEventHandlers = new SessionEventHandlers();
    protected DebugScreenshotsProvider debugScreenshotsProvider;

    public EyesBase() {
        if (this.isDisabled) {
            this.userInputs = null;
            return;
        }
        this.logger = new Logger();
        this.initProviders();
        this.setServerConnector(new ServerConnector());
        this.runningSession = null;
        this.userInputs = new ArrayDeque<Trigger>();
        this.lastScreenshot = null;
        this.debugScreenshotsProvider = new NullDebugScreenshotProvider();
    }

    private void initProviders(boolean hardReset) {
        if (hardReset) {
            this.scaleProviderHandler = new SimplePropertyHandler<ScaleProvider>();
            this.scaleProviderHandler.set(new NullScaleProvider(this.logger));
            this.cutProviderHandler = new SimplePropertyHandler<CutProvider>();
            this.cutProviderHandler.set(new NullCutProvider());
            this.positionProviderHandler = new SimplePropertyHandler<PositionProvider>();
            this.positionProviderHandler.set(new InvalidPositionProvider());
            return;
        }
        if (this.scaleProviderHandler == null) {
            this.scaleProviderHandler = new SimplePropertyHandler<ScaleProvider>();
            this.scaleProviderHandler.set(new NullScaleProvider(this.logger));
        }
        if (this.cutProviderHandler == null) {
            this.cutProviderHandler = new SimplePropertyHandler<CutProvider>();
            this.cutProviderHandler.set(new NullCutProvider());
        }
        if (this.positionProviderHandler == null) {
            this.positionProviderHandler = new SimplePropertyHandler<PositionProvider>();
            this.positionProviderHandler.set(new InvalidPositionProvider());
        }
    }

    private void initProviders() {
        this.initProviders(false);
    }

    public void setServerConnector(ServerConnector serverConnector) {
        ArgumentGuard.notNull((Object)((Object)serverConnector), (String)"serverConnector");
        this.serverConnector = serverConnector;
        serverConnector.setLogger(this.logger);
    }

    public ServerConnector getServerConnector() {
        if (this.serverConnector != null && this.serverConnector.getAgentId() == null) {
            this.serverConnector.setAgentId(this.getFullAgentId());
        }
        return this.serverConnector;
    }

    public Configuration setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.getConfigurationInstance().setApiKey(apiKey);
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        this.getServerConnector().setApiKey(apiKey);
        return this.getConfigurationInstance();
    }

    @Override
    public String getApiKey() {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        return this.getServerConnector().getApiKey();
    }

    public Configuration setServerUrl(String serverUrl) {
        this.setServerUrl(URI.create(serverUrl));
        return this.getConfigurationInstance();
    }

    public Configuration setServerUrl(URI serverUrl) {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        if (serverUrl == null) {
            this.getServerConnector().setServerUrl(EyesBase.getDefaultServerUrl());
        } else {
            this.getServerConnector().setServerUrl(serverUrl);
        }
        return this.getConfigurationInstance();
    }

    @Override
    public URI getServerUrl() {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        return this.getServerConnector().getServerUrl();
    }

    public Configuration setProxy(AbstractProxySettings abstractProxySettings) {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        this.getServerConnector().setProxy(abstractProxySettings);
        return this.getConfigurationInstance();
    }

    public AbstractProxySettings getProxy() {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        return this.getServerConnector().getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    @Override
    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    protected void clearUserInputs() {
        if (this.isDisabled) {
            return;
        }
        this.userInputs.clear();
    }

    protected Trigger[] getUserInputs() {
        if (this.isDisabled) {
            return null;
        }
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    protected abstract String getBaseAgentId();

    @Override
    public String getFullAgentId() {
        String agentId = this.getConfigurationInstance().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    @Override
    public boolean getIsOpen() {
        return this.isOpen;
    }

    public static URI getDefaultServerUrl() {
        try {
            return new URI("https://eyesapi.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
    }

    @Override
    public LogHandler getLogHandler() {
        return this.logger.getLogHandler();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setImageCut(CutProvider cutProvider) {
        if (cutProvider != null) {
            cutProvider.setLogger(this.logger);
            this.cutProviderHandler = new ReadOnlyPropertyHandler<CutProvider>(this.logger, cutProvider);
        } else {
            this.cutProviderHandler = new SimplePropertyHandler<CutProvider>();
            this.cutProviderHandler.set(new NullCutProvider());
        }
    }

    public boolean getIsCutProviderExplicitlySet() {
        return this.cutProviderHandler != null && !(this.cutProviderHandler.get() instanceof NullCutProvider);
    }

    public boolean getIsScaleProviderExplicitlySet() {
        return this.isScaleProviderSetByUser;
    }

    public void setScaleRatio(Double scaleRatio) {
        if (scaleRatio != null) {
            this.isScaleProviderSetByUser = true;
            FixedScaleProvider scaleProvider = new FixedScaleProvider(this.logger, scaleRatio);
            this.scaleProviderHandler = new ReadOnlyPropertyHandler<FixedScaleProvider>(this.logger, scaleProvider);
        } else {
            this.isScaleProviderSetByUser = false;
            this.scaleProviderHandler = new SimplePropertyHandler<ScaleProvider>();
            this.scaleProviderHandler.set(new NullScaleProvider(this.logger));
        }
    }

    public double getScaleRatio() {
        return this.scaleProviderHandler.get().getScaleRatio();
    }

    @Override
    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    protected void addProperty(PropertyData property) {
        this.properties.add(property);
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider(this.logger) : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        this.debugScreenshotsProvider.setPath(prev.getPath());
    }

    public boolean getSaveDebugScreenshots() {
        return !(this.debugScreenshotsProvider instanceof NullDebugScreenshotProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsProvider.getPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsProvider.getPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.debugScreenshotsProvider;
    }

    public TestResults close() {
        return this.close(true);
    }

    public TestResults close(boolean throwEx) {
        SyncTaskListener listener = new SyncTaskListener(this.logger);
        this.close((SyncTaskListener<TestResults>)listener, throwEx);
        TestResults testResults = (TestResults)listener.get();
        if (testResults == null) {
            throw new EyesException("Failed closing test");
        }
        EyesBase.logSessionResultsAndThrowException(this.logger, throwEx, testResults);
        return testResults;
    }

    private void close(final SyncTaskListener<TestResults> listener, boolean throwEx) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            listener.onComplete((Object)new TestResults());
            return;
        }
        this.logger.verbose(String.format("close(%b)", throwEx));
        if (!this.isOpen) {
            this.logger.log("WARNING: Eyes not open");
            TestResults testResults = new TestResults();
            testResults.setStatus(TestResultsStatus.NotOpened);
            listener.onComplete((Object)testResults);
            return;
        }
        this.isOpen = false;
        this.lastScreenshot = null;
        this.clearUserInputs();
        this.initProviders(true);
        if (this.runningSession == null) {
            this.logger.log("Server session was not started --- Empty test ended.");
            TestResults testResults = new TestResults();
            testResults.setStatus(TestResultsStatus.NotOpened);
            listener.onComplete((Object)testResults);
            return;
        }
        listener.setId(String.format("close test %s", this.runningSession));
        final boolean isNewSession = this.runningSession.getIsNew();
        this.logger.verbose("Ending server session...");
        boolean save = isNewSession && this.getConfigurationInstance().getSaveNewTests() || !isNewSession && this.getConfigurationInstance().getSaveFailedTests();
        this.logger.verbose("Automatically save test? " + save);
        this.getServerConnector().stopSession(new TaskListener<TestResults>(){

            public void onComplete(TestResults testResults) {
                EyesBase.this.logger.log("Test closed successfully");
                testResults.setNew(isNewSession);
                testResults.setUrl(EyesBase.this.runningSession.getUrl());
                EyesBase.this.logger.verbose(testResults.toString());
                EyesBase.this.sessionEventHandlers.testEnded(EyesBase.this.getAUTSessionId(), testResults);
                testResults.setServerConnector(EyesBase.this.getServerConnector());
                EyesBase.this.runningSession = null;
                listener.onComplete((Object)testResults);
            }

            public void onFail() {
                EyesBase.this.runningSession = null;
                listener.onFail();
            }
        }, this.runningSession, false, save);
    }

    public static void logSessionResultsAndThrowException(Logger logger, boolean throwEx, TestResults results) {
        TestResultsStatus status = results.getStatus();
        String sessionResultsUrl = results.getUrl();
        String scenarioIdOrName = results.getName();
        String appIdOrName = results.getAppName();
        if (status == null) {
            throw new EyesException("Status is null in the test results");
        }
        switch (status) {
            case Failed: {
                logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (!throwEx) break;
                throw new TestFailedException(results, scenarioIdOrName, appIdOrName);
            }
            case Passed: {
                logger.log("--- Test passed. See details at " + sessionResultsUrl);
                break;
            }
            case NotOpened: {
                logger.log("--- Test was never opened.");
                if (!throwEx) break;
                throw new EyesException("Called close before calling open");
            }
            case Unresolved: {
                if (results.isNew()) {
                    logger.log("--- New test ended. Please approve the new baseline at " + sessionResultsUrl);
                    if (!throwEx) break;
                    throw new NewTestException(results, scenarioIdOrName, appIdOrName);
                }
                logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (!throwEx) break;
                throw new DiffsFoundException(results, scenarioIdOrName, appIdOrName);
            }
        }
    }

    @Override
    public TestResults abortIfNotClosed() {
        SyncTaskListener listener = new SyncTaskListener(this.logger);
        this.abortIfNotClosed((SyncTaskListener<TestResults>)listener);
        TestResults testResults = (TestResults)listener.get();
        if (testResults == null) {
            throw new EyesException("Failed stopping session");
        }
        return testResults;
    }

    private void abortIfNotClosed(final SyncTaskListener<TestResults> listener) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            listener.onComplete((Object)new TestResults());
            return;
        }
        this.isOpen = false;
        this.lastScreenshot = null;
        this.clearUserInputs();
        if (null == this.runningSession) {
            this.logger.verbose("Closed");
            TestResults testResults = new TestResults();
            testResults.setStatus(TestResultsStatus.NotOpened);
            listener.onComplete((Object)testResults);
            return;
        }
        listener.setId(String.format("abort test %s", this.runningSession));
        this.logger.verbose("Aborting server session...");
        this.getServerConnector().stopSession(new TaskListener<TestResults>(){

            public void onComplete(TestResults testResults) {
                testResults.setNew(EyesBase.this.runningSession.getIsNew());
                testResults.setUrl(EyesBase.this.runningSession.getUrl());
                EyesBase.this.logger.log("--- Test aborted.");
                EyesBase.this.runningSession = null;
                EyesBase.this.closeLogger();
                listener.onComplete((Object)testResults);
            }

            public void onFail() {
                EyesBase.this.logger.log("Failed to abort server session");
                EyesBase.this.runningSession = null;
                EyesBase.this.closeLogger();
                listener.onFail();
            }
        }, this.runningSession, true, false);
    }

    @Override
    public TestResults abort() {
        return this.abortIfNotClosed();
    }

    protected void openLogger() {
        this.logger.getLogHandler().open();
    }

    protected void closeLogger() {
        this.logger.getLogHandler().close();
    }

    public PositionProvider getPositionProvider() {
        return this.positionProviderHandler.get();
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        if (positionProvider != null) {
            this.positionProviderHandler = new ReadOnlyPropertyHandler<PositionProvider>(this.logger, positionProvider);
        } else {
            this.positionProviderHandler = new SimplePropertyHandler<PositionProvider>();
            this.positionProviderHandler.set(new InvalidPositionProvider());
        }
    }

    protected MatchResult checkWindowBase(Region region, String tag, String source) {
        return this.checkWindowBase(region, tag, -1, source);
    }

    protected MatchResult checkWindowBase(Region region, String tag, int retryTimeout, String source) {
        return this.checkWindowBase(region, new CheckSettings(retryTimeout).withName(tag), source);
    }

    protected MatchResult checkWindowBase(Region region, String tag, ICheckSettings checkSettings) {
        return this.checkWindowBase(region, checkSettings.withName(tag), this.getAppName());
    }

    protected MatchResult checkWindowBase(Region region, ICheckSettings checkSettings, String source) {
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)((Object)checkSettings);
        return this.checkWindowBase(region, checkSettingsInternal, source);
    }

    protected MatchResult checkWindowBase(Region region, ICheckSettingsInternal checkSettingsInternal, String source) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        String tag = checkSettingsInternal.getName();
        if (tag == null) {
            tag = "";
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        MatchResult result = this.matchWindow(region, tag, checkSettingsInternal, source);
        this.logger.verbose("MatchWindow Done!");
        this.validateResult(tag, result);
        this.logger.verbose("Done!");
        return result;
    }

    protected abstract String tryCaptureDom();

    protected String tryCaptureAndPostDom(ICheckSettingsInternal checkSettingsInternal) {
        String domUrl = null;
        if (this.shouldCaptureDom(checkSettingsInternal.isSendDom())) {
            try {
                String domJson = this.tryCaptureDom();
                domUrl = this.tryPostDomCapture(domJson);
                this.logger.verbose("domUrl: " + domUrl);
            }
            catch (Exception ex) {
                this.logger.log("Error: " + ex);
            }
        }
        return domUrl;
    }

    private boolean shouldCaptureDom(Boolean sendDomFromCheckSettings) {
        boolean sendDomFromConfig = this.getConfigurationInstance().isSendDom() == null || this.getConfigurationInstance().isSendDom() != false;
        return sendDomFromCheckSettings != null && sendDomFromCheckSettings != false || sendDomFromCheckSettings == null && sendDomFromConfig;
    }

    protected ValidationInfo fireValidationWillStartEvent(String tag) {
        String autSessionId = this.getAUTSessionId();
        ValidationInfo validationInfo = new ValidationInfo();
        validationInfo.setValidationId("" + ++this.validationId);
        validationInfo.setTag(tag);
        this.getSessionEventHandlers().validationWillStart(autSessionId, validationInfo);
        return validationInfo;
    }

    private MatchResult matchWindow(Region region, String tag, ICheckSettingsInternal checkSettingsInternal, String source) {
        MatchResult result = this.matchWindowTask.matchWindow(this.getUserInputs(), region, tag, this.shouldMatchWindowRunOnceOnTimeout, checkSettingsInternal, source);
        return result;
    }

    private String tryPostDomCapture(String domJson) {
        if (domJson != null) {
            byte[] resultStream = GeneralUtils.getGzipByteArrayOutputStream((String)domJson);
            return this.matchWindowTask.tryUploadData(resultStream, "application/octet-stream", "application/json");
        }
        return null;
    }

    private void validateResult(String tag, MatchResult result) {
        if (result.getAsExpected()) {
            return;
        }
        this.shouldMatchWindowRunOnceOnTimeout = true;
        if (!this.runningSession.getIsNew().booleanValue()) {
            this.logger.log(String.format("Mismatch! (%s)", tag));
        }
        if (this.getConfigurationInstance().getFailureReports() == FailureReports.IMMEDIATE) {
            throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.sessionStartInfo.getScenarioIdOrName(), this.sessionStartInfo.getAppIdOrName()));
        }
    }

    @Override
    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    protected void openBase() throws EyesException {
        SyncTaskListener listener = new SyncTaskListener(this.logger);
        this.openBaseAsync((SyncTaskListener<Void>)listener);
        listener.get();
        if (!this.isOpen) {
            throw new EyesException("Failed starting session with the server");
        }
    }

    protected void openBaseAsync(final SyncTaskListener<Void> taskListener) throws EyesException {
        this.openLogger();
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        this.sessionEventHandlers.testStarted(this.getAUTSessionId());
        this.validateApiKey();
        this.logOpenBase();
        this.validateSessionOpen();
        this.initProviders();
        this.isViewportSizeSet = false;
        this.sessionEventHandlers.initStarted();
        RectangleSize viewportSize = this.getViewportSizeForOpen();
        if (viewportSize == null) {
            viewportSize = RectangleSize.EMPTY;
        }
        this.getConfigurationInstance().setViewportSize(viewportSize);
        if (this.runningSession != null) {
            this.logger.log("session already running.");
            return;
        }
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        this.ensureViewportSize();
        Configuration configGetter = this.getConfigurationInstance();
        BatchInfo testBatch = configGetter.getBatch();
        if (testBatch == null) {
            this.logger.verbose("No batch set");
            this.getConfigurationInstance().setBatch(new BatchInfo(null));
        } else {
            this.logger.verbose("Batch is " + testBatch);
        }
        String agentSessionId = UUID.randomUUID().toString();
        Object appEnv = this.getAppEnvironment();
        this.sessionStartInfo = new SessionStartInfo(this.getFullAgentId(), configGetter.getSessionType(), this.getAppName(), null, this.getTestName(), configGetter.getBatch(), this.getBaselineEnvName(), configGetter.getEnvironmentName(), appEnv, configGetter.getDefaultMatchSettings(), configGetter.getBranchName(), configGetter.getParentBranchName(), configGetter.getBaselineBranchName(), configGetter.getSaveDiffs(), this.properties, agentSessionId, configGetter.getAbortIdleTestTimeout());
        this.sessionEventHandlers.initEnded();
        taskListener.setId(String.format("openBase %s", this.sessionStartInfo));
        this.logger.verbose("Application environment is " + appEnv);
        String testInfo = "'" + this.getTestName() + "' of '" + this.getAppName() + "' " + appEnv;
        this.logger.log("--- Starting test - " + testInfo);
        final AtomicInteger timePassed = new AtomicInteger(0);
        final AtomicInteger sleepDuration = new AtomicInteger(2000);
        TaskListener<RunningSession> listener = new TaskListener<RunningSession>(){

            public void onComplete(RunningSession result) {
                String testName = "'" + EyesBase.this.getTestName() + "'";
                if (result.isConcurrencyFull()) {
                    EyesBase.this.isServerConcurrencyLimitReached = true;
                    EyesBase.this.logger.verbose(String.format("Failed starting test %s, concurrency is fully used. Trying again.", testName));
                    this.onFail();
                    return;
                }
                EyesBase.this.isServerConcurrencyLimitReached = false;
                EyesBase.this.runningSession = result;
                EyesBase.this.logger.verbose("Server session ID is " + EyesBase.this.runningSession.getId());
                EyesBase.this.logger.setSessionId(EyesBase.this.runningSession.getSessionId());
                if (EyesBase.this.runningSession.getIsNew().booleanValue()) {
                    EyesBase.this.logger.log("--- New test started - " + testName);
                    EyesBase.this.shouldMatchWindowRunOnceOnTimeout = true;
                } else {
                    EyesBase.this.logger.log("--- Test started - " + testName);
                    EyesBase.this.shouldMatchWindowRunOnceOnTimeout = false;
                }
                EyesBase.this.matchWindowTask = new MatchWindowTask(EyesBase.this.logger, EyesBase.this.getServerConnector(), EyesBase.this.runningSession, EyesBase.this.getConfigurationInstance().getMatchTimeout(), EyesBase.this, new AppOutputProvider(){

                    @Override
                    public AppOutputWithScreenshot getAppOutput(Region region, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings) {
                        return EyesBase.this.getAppOutputWithScreenshot(region, checkSettingsInternal, imageMatchSettings);
                    }
                });
                EyesBase.this.validationId = -1;
                EyesBase.this.isOpen = true;
                taskListener.onComplete(null);
            }

            public void onFail() {
                if (timePassed.get() > 3600000) {
                    EyesBase.this.isServerConcurrencyLimitReached = false;
                    taskListener.onFail();
                    return;
                }
                try {
                    Thread.sleep(sleepDuration.get());
                    timePassed.set(timePassed.get() + sleepDuration.get());
                    if (timePassed.get() >= 30000) {
                        sleepDuration.set(10000);
                    } else if (timePassed.get() >= 10000) {
                        sleepDuration.set(5000);
                    }
                    EyesBase.this.startSession(this);
                }
                catch (Throwable e) {
                    GeneralUtils.logExceptionStackTrace((Logger)EyesBase.this.logger, (Throwable)e);
                    taskListener.onFail();
                }
            }
        };
        this.logger.log(String.format("Calling start session with agentSessionId %s", agentSessionId));
        this.startSession(listener);
    }

    protected RectangleSize getViewportSizeForOpen() {
        return this.getConfigurationInstance().getViewportSize();
    }

    private void validateApiKey() {
        if (this.getApiKey() == null) {
            String errMsg = "API key is missing! Please set it using setApiKey()";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    private void logOpenBase() {
        this.logger.log(String.format("Eyes server URL is '%s'", this.getServerConnector().getServerUrl()));
        this.logger.verbose(String.format("Timeout = '%d'", this.getServerConnector().getTimeout()));
        this.logger.log(String.format("matchTimeout = '%d' ", this.getConfigurationInstance().getMatchTimeout()));
        this.logger.log(String.format("Default match settings = '%s' ", this.getConfigurationInstance().getDefaultMatchSettings()));
        this.logger.log(String.format("FailureReports = '%s' ", new Object[]{this.getConfigurationInstance().getFailureReports()}));
    }

    private void validateSessionOpen() {
        if (this.isOpen) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    protected abstract RectangleSize getViewportSize();

    protected abstract Configuration setViewportSize(RectangleSize var1);

    protected void setEffectiveViewportSize(RectangleSize size) {
    }

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        if (explicitViewportSize == null) {
            return;
        }
        this.logger.verbose("Viewport size explicitly set to " + explicitViewportSize);
        this.getConfigurationInstance().setViewportSize(explicitViewportSize);
        this.isViewportSizeSet = true;
    }

    protected abstract String getInferredEnvironment();

    protected abstract EyesScreenshot getScreenshot(Region var1, ICheckSettingsInternal var2);

    protected abstract String getTitle();

    protected void addUserInput(Trigger trigger) {
        if (this.isDisabled) {
            return;
        }
        ArgumentGuard.notNull((Object)trigger, (String)"trigger");
        this.userInputs.add(trigger);
    }

    protected void addTextTriggerBase(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)text, (String)"text");
        control = new Region(control);
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if ((control = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS)).isSizeEmpty()) {
            this.logger.verbose(String.format("Ignoring '%s' (out of bounds)", text));
            return;
        }
        TextTrigger trigger = new TextTrigger(control, text);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", trigger));
    }

    protected void addMouseTriggerBase(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", new Object[]{action}));
            return;
        }
        ArgumentGuard.notNull((Object)((Object)action), (String)"action");
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)cursor, (String)"cursor");
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", new Object[]{action}));
            return;
        }
        Location cursorInScreenshot = new Location(cursor);
        cursorInScreenshot = cursorInScreenshot.offset(control.getLocation());
        try {
            cursorInScreenshot = this.lastScreenshot.getLocationInScreenshot(cursorInScreenshot, CoordinatesType.CONTEXT_RELATIVE);
        }
        catch (OutOfBoundsException e) {
            this.logger.verbose(String.format("Ignoring %s (out of bounds)", new Object[]{action}));
            return;
        }
        Region controlScreenshotIntersect = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS);
        if (!controlScreenshotIntersect.isSizeEmpty()) {
            Location l = controlScreenshotIntersect.getLocation();
            cursorInScreenshot = cursorInScreenshot.offset(-l.getX(), -l.getY());
        }
        MouseTrigger trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", trigger));
    }

    protected Object getAppEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.getConfigurationInstance().getHostOS() != null) {
            appEnv.setOs(this.getConfigurationInstance().getHostOS());
        }
        if (this.getConfigurationInstance().getHostApp() != null) {
            appEnv.setHostingApp(this.getConfigurationInstance().getHostApp());
        }
        if (this.getConfigurationInstance().getHostingAppInfo() != null) {
            appEnv.setHostingAppInfo(this.getConfigurationInstance().getHostingAppInfo());
        }
        if (this.getConfigurationInstance().getOsInfo() != null) {
            appEnv.setOsInfo(this.getConfigurationInstance().getOsInfo());
        }
        if (this.getConfigurationInstance().getDeviceInfo() != null) {
            appEnv.setDeviceInfo(this.getConfigurationInstance().getDeviceInfo());
        }
        appEnv.setInferred(this.getInferredEnvironment());
        appEnv.setDisplaySize(this.getConfigurationInstance().getViewportSize());
        return appEnv;
    }

    protected void startSession(TaskListener<RunningSession> listener) {
        this.logger.verbose("Starting server session...");
        this.getServerConnector().startSession(listener, this.sessionStartInfo);
    }

    protected String getTestName() {
        return this.getConfigurationInstance().getTestName();
    }

    protected String getAppName() {
        return this.getConfigurationInstance().getAppName();
    }

    protected String getBaselineEnvName() {
        return this.getConfigurationInstance().getBaselineEnvName();
    }

    public Object getAgentSetup() {
        return null;
    }

    private void ensureViewportSize() {
        if (this.isViewportSizeSet) {
            return;
        }
        RectangleSize viewportSize = this.getConfigurationInstance().getViewportSize();
        if (viewportSize == null || viewportSize.isEmpty()) {
            try {
                viewportSize = this.getViewportSize();
                this.logger.verbose("viewport size: " + viewportSize);
                this.setEffectiveViewportSize(viewportSize);
                this.getConfigurationInstance().setViewportSize(viewportSize);
            }
            catch (NullPointerException e) {
                this.isViewportSizeSet = false;
            }
        } else {
            try {
                this.logger.verbose("Setting viewport size to " + viewportSize);
                this.setViewportSize(viewportSize);
                this.isViewportSizeSet = true;
            }
            catch (Exception ex) {
                this.isViewportSizeSet = false;
                throw ex;
            }
        }
    }

    private AppOutputWithScreenshot getAppOutputWithScreenshot(Region region, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings) {
        this.logger.verbose("getting screenshot...");
        EyesScreenshot screenshot = this.getScreenshot(region, checkSettingsInternal);
        byte[] screenshotBytes = null;
        this.logger.verbose("Done getting screenshot!");
        String domUrl = null;
        if (screenshot != null) {
            this.logger.verbose("Getting image bytes (encoded as PNG)...");
            BufferedImage screenshotImage = screenshot.getImage();
            screenshotBytes = ImageUtils.encodeAsPng(screenshotImage);
            domUrl = screenshot.domUrl;
        }
        MatchWindowTask.collectRegions(this, screenshot, checkSettingsInternal, imageMatchSettings);
        this.logger.verbose("Done! Getting title...");
        String title = this.getTitle();
        this.logger.verbose("Done!");
        AppOutputWithScreenshot result = new AppOutputWithScreenshot(new AppOutput(title, screenshotBytes, domUrl, null), screenshot, region == null || region.isEmpty() ? null : region.getLocation());
        this.logger.verbose("Done!");
        return result;
    }

    public void log(String message) {
        this.logger.log(message);
    }

    protected SessionEventHandlers getSessionEventHandlers() {
        return this.sessionEventHandlers;
    }

    public void addSessionEventHandler(ISessionEventHandler eventHandler) {
        this.sessionEventHandlers.addEventHandler(eventHandler);
    }

    public void removeSessionEventHandler(ISessionEventHandler eventHandler) {
        this.sessionEventHandlers.removeEventHandler(eventHandler);
    }

    public void clearSessionEventHandlers() {
        this.sessionEventHandlers.clearEventHandlers();
    }

    protected abstract String getAUTSessionId();

    public Boolean isSendDom() {
        return this.getConfigurationInstance().isSendDom();
    }

    public Configuration setSendDom(boolean isSendDom) {
        this.getConfigurationInstance().setSendDom(isSendDom);
        return this.getConfigurationInstance();
    }

    public RenderingInfo getRenderingInfo() {
        return this.getServerConnector().getRenderInfo();
    }

    public Map<String, DeviceSize> getDevicesSizes(String path) {
        return this.getServerConnector().getDevicesSizes(path);
    }

    public Map<String, String> getUserAgents() {
        return this.getServerConnector().getUserAgents();
    }

    public Map<String, MobileDeviceInfo> getMobileDeviceInfo() {
        return this.getServerConnector().getMobileDevicesInfo();
    }

    public Configuration setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return this.getConfigurationInstance();
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.getConfigurationInstance().setBatch(batch);
        return this.getConfigurationInstance();
    }

    protected abstract Configuration getConfigurationInstance();

    public Configuration getConfiguration() {
        return new Configuration(this.getConfigurationInstance());
    }

    @Override
    public void abortAsync() {
        this.abort();
    }

    public boolean isServerConcurrencyLimitReached() {
        return this.isServerConcurrencyLimitReached;
    }
}

