/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.ResponseParsingCallback;
import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.UfgConnector;
import com.applitools.connectivity.UploadCallback;
import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.HttpClient;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MobileDeviceInfo;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.locators.VisualLocatorsData;
import com.applitools.eyes.logging.LogSessionsClientEvents;
import com.applitools.eyes.visualgrid.model.HashObject;
import com.applitools.eyes.visualgrid.model.JobInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ServerConnector
extends UfgConnector {
    static final String CLOSE_BATCH = "api/sessions/batches/%s/close/bypointerid";
    static final String RENDER_STATUS = "/render-status";
    static final String RENDER = "/render";
    static final String RESOURCE_STATUS = "/query/resources-exist";
    static final String RENDERER_INFO = "/job-info";
    static final String MOBILE_DEVICES_PATH = "/app/info/mobile/devices";
    public static final String API_PATH = "/api/sessions/running";
    private static final String LOG_PATH = "/api/sessions/log";
    private Map<String, MobileDeviceInfo> mobileDevicesInfo = null;

    public ServerConnector(Logger logger, URI serverUrl, int timeout) {
        super(logger, serverUrl, timeout);
    }

    public ServerConnector(Logger logger, URI serverUrl) {
        this(logger, serverUrl, 300000);
    }

    public ServerConnector(Logger logger) {
        this(logger, GeneralUtils.getServerUrl());
    }

    public ServerConnector() {
        this(new Logger());
    }

    public void setAgentId(String agentId) {
        this.logger.log(String.format("Setting agent id: %s", agentId));
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setServerUrl(URI serverUrl) {
        this.setServerUrlBase(serverUrl);
    }

    public URI getServerUrl() {
        return this.getServerUrlBase();
    }

    public void updateClient(HttpClient client) {
        this.restClient = client;
    }

    public void sendLogs(AsyncRequestCallback callback, LogSessionsClientEvents clientEvents) {
        ArgumentGuard.notNull((Object)clientEvents, (String)"clientEvents");
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.LOG_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        try {
            String data = this.jsonMapper.writeValueAsString((Object)clientEvents);
            this.sendAsyncRequest(request, "POST", callback, data, "application/json");
        }
        catch (JsonProcessingException e) {
            throw new EyesException("Failed converting client events to string", (Throwable)e);
        }
    }

    public void startSession(final TaskListener<RunningSession> listener, SessionStartInfo sessionStartInfo) throws EyesException {
        String postData;
        ArgumentGuard.notNull((Object)sessionStartInfo, (String)"sessionStartInfo");
        this.logger.verbose("enter");
        this.initClient();
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        AsyncRequestCallback callback = new AsyncRequestCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Response response) {
                try {
                    if (response.getStatusCode() == 503) {
                        RunningSession runningSession = new RunningSession();
                        runningSession.setConcurrencyFull(true);
                        listener.onComplete((Object)runningSession);
                        return;
                    }
                    ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
                    validStatusCodes.add(200);
                    validStatusCodes.add(201);
                    RunningSession runningSession = (RunningSession)ServerConnector.this.parseResponseWithJsonData(response, validStatusCodes, (TypeReference)new TypeReference<RunningSession>(){});
                    if (runningSession.getIsNew() == null) {
                        runningSession.setIsNew(response.getStatusCode() == 201);
                    }
                    runningSession.setConcurrencyFull(false);
                    listener.onComplete((Object)runningSession);
                }
                catch (Throwable t) {
                    this.onFail(t);
                }
                finally {
                    response.close();
                }
            }

            public void onFail(Throwable throwable) {
                GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)throwable);
                listener.onFail();
            }
        };
        this.sendLongRequest(request, "POST", callback, postData, "application/json");
    }

    public void stopSession(TaskListener<TestResults> listener, final RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).path(runningSession.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).queryParam("aborted", String.valueOf(isAborted)).queryParam("updateBaseline", String.valueOf(save)).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<TestResults>(){});
        this.sendLongRequest(request, "DELETE", (AsyncRequestCallback)callback, null, null);
    }

    public void deleteSession(final TaskListener<Void> listener, final TestResults testResults) {
        ArgumentGuard.notNull((Object)testResults, (String)"testResults");
        if (testResults.getId() == null || testResults.getBatchId() == null || testResults.getSecretToken() == null) {
            this.logger.log("Can't delete session, results are null");
            return;
        }
        this.initClient();
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("/api/sessions/batches/").path(testResults.getBatchId()).path("/").path(testResults.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).queryParam("AccessToken", testResults.getSecretToken()).asyncRequest(new String[]{"application/json"});
            }
        });
        this.sendAsyncRequest(request, "DELETE", new AsyncRequestCallback(){

            public void onComplete(Response response) {
                listener.onComplete(null);
            }

            public void onFail(Throwable throwable) {
                listener.onFail();
            }
        });
    }

    public void matchWindow(TaskListener<MatchResult> listener, final RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        String jsonData;
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)matchData, (String)"model");
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize model for matchWindow!", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).path(runningSession.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<MatchResult>(){});
        this.sendLongRequest(request, "POST", (AsyncRequestCallback)callback, jsonData, "application/json");
    }

    public void render(final TaskListener<List<RunningRender>> listener, RenderRequest ... renderRequests) {
        ArgumentGuard.notNull((Object)renderRequests, (String)"renderRequests");
        this.logger.verbose("called with " + Arrays.toString(renderRequests));
        AsyncRequest request = this.restClient.target(this.getRenderInfo().getServiceUrl()).path(RENDER).asyncRequest(new String[]{"application/json"});
        request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        validStatusCodes.add(404);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)renderRequests);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, (TaskListener)new TaskListener<RunningRender[]>(){

                public void onComplete(RunningRender[] runningRenders) {
                    listener.onComplete(runningRenders == null ? null : Arrays.asList(runningRenders));
                }

                public void onFail() {
                    listener.onFail();
                }
            }, (TypeReference)new TypeReference<RunningRender[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            listener.onComplete(null);
        }
    }

    public void renderStatusById(final TaskListener<List<RenderStatusResults>> listener, String ... renderIds) {
        try {
            ArgumentGuard.notNull((Object)renderIds, (String)"renderIds");
            this.logger.verbose("called for render: " + Arrays.toString(renderIds));
            AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

                public AsyncRequest build() {
                    return ServerConnector.this.restClient.target(ServerConnector.this.getRenderInfo().getServiceUrl()).path(ServerConnector.RENDER_STATUS).asyncRequest(new String[]{"text/plain"});
                }
            });
            request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            validStatusCodes.add(404);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)renderIds);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, (TaskListener)new TaskListener<RenderStatusResults[]>(){

                public void onComplete(RenderStatusResults[] renderStatusResults) {
                    if (renderStatusResults == null) {
                        listener.onComplete(null);
                        return;
                    }
                    for (RenderStatusResults renderStatusResult : renderStatusResults) {
                        if (renderStatusResult == null || renderStatusResult.getStatus() != RenderStatus.ERROR) continue;
                        ServerConnector.this.logger.verbose("error on render id - " + renderStatusResult);
                    }
                    listener.onComplete(Arrays.asList(renderStatusResults));
                }

                public void onFail() {
                    listener.onFail();
                }
            }, (TypeReference)new TypeReference<RenderStatusResults[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            listener.onComplete(null);
        }
    }

    public void checkResourceStatus(TaskListener<Boolean[]> listener, String renderId, HashObject ... hashes) {
        try {
            ArgumentGuard.notNull((Object)hashes, (String)"hashes");
            renderId = renderId == null ? "NONE" : renderId;
            AsyncRequest request = this.restClient.target(this.getRenderInfo().getServiceUrl()).queryParam("rg_render-id", renderId).path(RESOURCE_STATUS).asyncRequest(new String[]{"application/json"});
            request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)hashes);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<Boolean[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            listener.onComplete(null);
        }
    }

    public void getJobInfo(TaskListener<JobInfo[]> listener, RenderRequest[] browserInfos) {
        try {
            AsyncRequest request = this.restClient.target(this.getRenderInfo().getServiceUrl()).path(RENDERER_INFO).asyncRequest(new String[]{"application/json"});
            request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)browserInfos);
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<JobInfo[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)t);
            listener.onFail();
        }
    }

    public void uploadData(TaskListener<String> listener, byte[] bytes, String contentType, String mediaType) {
        String targetUrl;
        RenderingInfo renderingInfo = this.getRenderInfo();
        if (renderingInfo == null || (targetUrl = renderingInfo.getResultsUrl()) == null) {
            listener.onComplete(null);
            return;
        }
        UUID uuid = UUID.randomUUID();
        String finalUrl = targetUrl.replace("__random__", uuid.toString());
        this.logger.verbose("uploading viewport image to " + finalUrl);
        UploadCallback callback = new UploadCallback(listener, this, finalUrl, bytes, contentType, mediaType);
        callback.uploadDataAsync();
    }

    public void uploadImage(TaskListener<String> listener, byte[] bytes) {
        this.uploadData(listener, bytes, "image/png", "image/png");
    }

    public void postLocators(TaskListener<Map<String, List<Region>>> listener, VisualLocatorsData visualLocatorsData) {
        String postData;
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
            postData = this.jsonMapper.writeValueAsString((Object)visualLocatorsData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert visualLocatorsData into Json string!", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("api/locators/locate").queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<Map<String, List<Region>>>(){});
        this.sendLongRequest(request, "POST", (AsyncRequestCallback)callback, postData, "application/json");
    }

    public void closeBatch(String batchId) {
        this.closeBatch(batchId, this.serverUrl.toString());
    }

    public void closeBatch(String batchId, String url) {
        SyncTaskListener listener = new SyncTaskListener(this.logger, "closeBatch");
        this.closeBatchAsync((TaskListener<Void>)listener, batchId, url);
        listener.get();
    }

    public void closeBatchAsync(final TaskListener<Void> listener, String batchId, final String url) {
        ArgumentGuard.notNull((Object)batchId, (String)"batchId");
        this.logger.log("called with " + batchId);
        final String path = String.format(CLOSE_BATCH, batchId);
        this.initClient();
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(url).path(path).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{null});
            }
        });
        this.sendAsyncRequest(request, "DELETE", new AsyncRequestCallback(){

            public void onComplete(Response response) {
                try {
                    ServerConnector.this.closeConnector();
                }
                catch (Throwable t) {
                    GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)t);
                }
                finally {
                    listener.onComplete(null);
                }
            }

            public void onFail(Throwable throwable) {
                try {
                    GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)throwable);
                    ServerConnector.this.closeConnector();
                }
                finally {
                    listener.onFail();
                }
            }
        });
    }

    public void closeConnector() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    public boolean getDontCloseBatches() {
        return "true".equalsIgnoreCase(GeneralUtils.getEnvString((String)"APPLITOOLS_DONT_CLOSE_BATCHES"));
    }

    public Map<String, MobileDeviceInfo> getMobileDevicesInfo() {
        if (this.mobileDevicesInfo != null) {
            return this.mobileDevicesInfo;
        }
        try {
            this.mobileDevicesInfo = (Map)this.getFromServer(new RestClient.HttpRequestBuilder(){

                public AsyncRequest build() {
                    return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.MOBILE_DEVICES_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[0]);
                }
            }, (TypeReference)new TypeReference<Map<String, MobileDeviceInfo>>(){});
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)t);
            this.mobileDevicesInfo = new HashMap<String, MobileDeviceInfo>();
        }
        return this.mobileDevicesInfo;
    }
}

