/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.api.ConnectivityTarget;
import com.applitools.connectivity.api.Request;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;

public class RemoteSessionEventHandler
extends RestClient {
    public static final int DEFAULT_CLIENT_TIMEOUT = 300000;
    private static final String SERVER_SUFFIX = "/applitools/sessions";
    private String autSessionId;
    private final String accessKey;
    private ConnectivityTarget defaultEndPoint;
    private boolean throwExceptions = true;

    public RemoteSessionEventHandler(Logger logger, URI serverUrl, String accessKey, int timeout) {
        super(logger, serverUrl, timeout);
        this.accessKey = accessKey;
        this.updateEndpoint();
    }

    public RemoteSessionEventHandler(Logger logger, URI serverUrl, String accessKey) {
        this(logger, serverUrl, accessKey, 300000);
    }

    public RemoteSessionEventHandler(URI serverUrl, String accessKey) {
        this(new Logger(), serverUrl, accessKey);
    }

    private void updateEndpoint() {
        this.defaultEndPoint = this.restClient.target(this.serverUrl).queryParam("accessKey", this.accessKey).path(SERVER_SUFFIX);
    }

    public void setProxy(AbstractProxySettings abstractProxySettings) {
        super.setProxy(abstractProxySettings);
        this.updateEndpoint();
    }

    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        this.updateEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(RestClient.HttpMethodCall method) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String methodName = "";
        if (stackTraceElements.length >= 3) {
            methodName = stackTraceElements[2].getMethodName();
        }
        try (Response response = null;){
            response = method.call();
            if (response.getStatusCode() != 200) {
                this.logger.verbose("'" + methodName + "' notification handler returned an error: " + response.getStatusPhrase());
            } else {
                this.logger.verbose("'" + methodName + "' succeeded: " + response);
            }
        }
    }

    public void initStarted() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return request.method("PUT", (Object)"{\"action\": \"initStart\"}", "application/json");
            }
        });
    }

    public void initEnded() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return request.method("PUT", (Object)"{\"action\": \"initEnd\"}", "application/json");
            }
        });
    }

    public void setSizeWillStart(RectangleSize sizeToSet) {
        final RectangleSize size = sizeToSet;
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                String data = "{\"action\": \"setSizeStart\", \"size\":{\"width\": " + size.getWidth() + ", \"height\": " + size.getHeight() + "}}";
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return request.method("PUT", (Object)data, "application/json");
            }
        });
    }

    public void setSizeEnded() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return request.method("PUT", (Object)"{\"action\": \"setSizeEnd\"}", "application/json");
            }
        });
    }

    public void testStarted(String autSessionId) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.request(new String[]{"application/json"});
                String data = "{\"autSessionId\": \"" + autSessionIdFinal + "\"}";
                return request.method("POST", (Object)data, "application/json");
            }
        });
        this.autSessionId = autSessionId;
    }

    public void testEnded(String autSessionId, final TestResults testResults) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                String testResultJson;
                Request invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).request(new String[]{"application/json"});
                ObjectMapper jsonMapper = new ObjectMapper();
                try {
                    testResultJson = jsonMapper.writeValueAsString((Object)testResults);
                }
                catch (JsonProcessingException e) {
                    testResultJson = "{}";
                    e.printStackTrace();
                }
                String data = "{\"action\": \"testEnd\", \"testResults\":" + testResultJson + "}";
                return invocationBuilder.method("PUT", (Object)data, "application/json");
            }
        });
    }

    public void validationWillStart(String autSessionId, final ValidationInfo validationInfo) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).path("validations").request(new String[]{"application/json"});
                return request.method("POST", (Object)validationInfo.toJsonString(), "application/json");
            }
        });
    }

    public void validationEnded(String autSessionId, final String validationId, final ValidationResult validationResult) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            public Response call() {
                Request request = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).path("validations").path(validationId).request(new String[]{"application/json"});
                String data = "{\"action\":\"validationEnd\", \"asExpected\":" + validationResult.isAsExpected() + "}";
                return request.method("PUT", (Object)data, "application/json");
            }
        });
    }

    public boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }
}

