/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import java.util.ArrayList;
import java.util.List;

public class CheckSettings
implements ICheckSettings,
ICheckSettingsInternal {
    private Region targetRegion;
    private List<Region> ignoreRegions = new ArrayList<Region>();
    private MatchLevel matchLevel;
    private Boolean ignoreCaret;
    private boolean stitchContent = false;
    private List<FloatingMatchSettings> floatingRegions = new ArrayList<FloatingMatchSettings>();
    private int timeout = -1;

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(int timeout) {
        this.timeout = timeout;
    }

    protected void ignore(Region region) {
        this.ignoreRegions.add(region);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingMatchSettings(region.getLeft(), region.getTop(), region.getLeft() + region.getWidth(), region.getTop() + region.getHeight(), maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    @Override
    public ICheckSettings ignore(Region ... regions) {
        for (Region r : regions) {
            this.ignore(r);
        }
        return this;
    }

    @Override
    public ICheckSettings fully() {
        this.stitchContent = true;
        return this;
    }

    @Override
    public ICheckSettings floating(int maxOffset, Region ... regions) {
        for (Region r : regions) {
            this.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return this;
    }

    @Override
    public ICheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return this;
    }

    @Override
    public ICheckSettings timeout(int timeoutMilliseconds) {
        this.timeout = timeoutMilliseconds;
        return this;
    }

    @Override
    public ICheckSettings layout() {
        this.matchLevel = MatchLevel.LAYOUT;
        return this;
    }

    @Override
    public ICheckSettings exact() {
        this.matchLevel = MatchLevel.EXACT;
        return this;
    }

    @Override
    public ICheckSettings strict() {
        this.matchLevel = MatchLevel.STRICT;
        return this;
    }

    @Override
    public ICheckSettings content() {
        this.matchLevel = MatchLevel.CONTENT;
        return this;
    }

    @Override
    public ICheckSettings matchLevel(MatchLevel matchLevel) {
        this.matchLevel = matchLevel;
        return this;
    }

    @Override
    public ICheckSettings ignoreCaret(boolean ignoreCaret) {
        this.ignoreCaret = ignoreCaret;
        return this;
    }

    @Override
    public ICheckSettings ignoreCaret() {
        this.ignoreCaret = true;
        return this;
    }

    @Override
    public Region getTargetRegion() {
        return this.targetRegion;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean getStitchContent() {
        return this.stitchContent;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public Region[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new Region[0]);
    }

    @Override
    public FloatingMatchSettings[] getFloatingRegions() {
        return this.floatingRegions.toArray(new FloatingMatchSettings[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }
}

