/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.URI;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class RemoteSessionEventHandler
extends RestClient
implements ISessionEventHandler {
    private String autSessionId;
    private static final String SERVER_SUFFIX = "/applitools/sessions";
    private final WebTarget defaultEndPoint;
    private boolean throwExceptions = true;

    public RemoteSessionEventHandler(Logger logger, URI serverUrl, String accessKey, int timeout) {
        super(logger, serverUrl, timeout);
        this.defaultEndPoint = this.endPoint.queryParam("accessKey", new Object[]{accessKey}).path(SERVER_SUFFIX);
    }

    public RemoteSessionEventHandler(Logger logger, URI serverUrl, String accessKey) {
        this(logger, serverUrl, accessKey, 30000);
    }

    public RemoteSessionEventHandler(URI serverUrl, String accessKey, int timeout) {
        this(new Logger(), serverUrl, accessKey, timeout);
    }

    public RemoteSessionEventHandler(URI serverUrl, String accessKey) {
        this(new Logger(), serverUrl, accessKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(RestClient.HttpMethodCall method) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String methodName = "";
        if (stackTraceElements.length >= 3) {
            methodName = stackTraceElements[2].getMethodName();
        }
        try (Response response = null;){
            response = method.call();
            if (response.getStatus() != 200) {
                this.logger.verbose("'" + methodName + "' notification handler returned an error: " + response.getStatusInfo());
            } else {
                this.logger.verbose("'" + methodName + "' succeeded: " + response);
            }
        }
    }

    public void initStarted() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return invocationBuilder.put(Entity.json((Object)"{\"action\": \"initStart\"}"));
            }
        });
    }

    public void initEnded() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return invocationBuilder.put(Entity.json((Object)"{\"action\": \"initEnd\"}"));
            }
        });
    }

    public void setSizeWillStart(RectangleSize sizeToSet) {
        final RectangleSize size = sizeToSet;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return invocationBuilder.put(Entity.json((Object)("{\"action\": \"setSizeStart\", \"size\":{\"width\": " + size.getWidth() + ", \"height\": " + size.getHeight() + "}}")));
            }
        });
    }

    public void setSizeEnded() {
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(RemoteSessionEventHandler.this.autSessionId).request(new String[]{"application/json"});
                return invocationBuilder.put(Entity.json((Object)"{\"action\": \"setSizeEnd\"}"));
            }
        });
    }

    public void testStarted(String autSessionId) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.request(new String[]{"application/json"});
                return invocationBuilder.post(Entity.json((Object)("{\"autSessionId\": \"" + autSessionIdFinal + "\"}")));
            }
        });
        this.autSessionId = autSessionId;
    }

    public void testEnded(String autSessionId, final TestResults testResults) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                String testResultJson;
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).request(new String[]{"application/json"});
                ObjectMapper jsonMapper = new ObjectMapper();
                jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
                try {
                    testResultJson = jsonMapper.writeValueAsString((Object)testResults);
                }
                catch (JsonProcessingException e) {
                    testResultJson = "{}";
                    e.printStackTrace();
                }
                return invocationBuilder.put(Entity.json((Object)("{\"action\": \"testEnd\", \"testResults\":" + testResultJson + "}")));
            }
        });
    }

    public void validationWillStart(String autSessionId, final ValidationInfo validationInfo) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).path("validations").request(new String[]{"application/json"});
                return invocationBuilder.post(Entity.json((Object)validationInfo.toJsonString()));
            }
        });
    }

    public void validationEnded(String autSessionId, final String validationId, final ValidationResult validationResult) {
        final String autSessionIdFinal = autSessionId;
        this.sendMessage(new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                Invocation.Builder invocationBuilder = RemoteSessionEventHandler.this.defaultEndPoint.path(autSessionIdFinal).path("validations").path(validationId).request(new String[]{"application/json"});
                return invocationBuilder.put(Entity.json((Object)("{\"action\":\"validationEnd\", \"asExpected\":" + validationResult.isAsExpected() + "}")));
            }
        });
    }

    public boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }
}

